// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import jakarta.servlet.*;
import jakarta.servlet.http.*;
import java.io.*;
import java.util.*;
import java.text.*;
import java.util.regex.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/**
Validates a time entered in a text box. Typical examples may
look like: <tt>1:23 pm</tt>, <tt>1 am</tt>, <tt>1:00 am</tt>,
and <tt>01:23 pm</tt> (with or without "am/pm" as part of the
entered text). By default, all of the above patterns are allowed and
the space between the time and "am/pm" is optional. This can be
changed via the {@link #useAM_PM} and {@link #allowSpaceBeforeAM_PM}
methods.

@author hursh jain
**/
public final class VTime extends FieldValidator
{
boolean useAM_PM = true;
boolean allow_space = true;

public VTime(AbstractText field, String errorMessage)
	{
	super(field, errorMessage);
	}

public void useAM_PM(boolean useAM_PM)
	{
	this.useAM_PM = useAM_PM;
	}

public void allowSpaceBeforeAM_PM(boolean allow)
	{
	this.allow_space = allow;
	}
		
/** 
Works with any field that returns a <b>String</b> via it's {@link
Field#getValue} method.
<p>
If validation succeeds, this method puts the parsed date in the specified
form data as the validated value for the target field. This saves the
hassle of reparsing the text when (typically) retrieving it later to save
the value out to the database.

@throws ClassCastException  If the field's {@link Field#getValue} method
							does not return a String
**/
public boolean validate(FormData fd, HttpServletRequest req) 
	{
	String val = ((AbstractText) field).getValue(fd);
	
	if (val == null)
		return false;
		
	boolean result = true;

	DateFormat df1 = null, df2 = null;

	if (useAM_PM) 
		{
		df1 = new SimpleDateFormat("h:mma");
		if (allow_space) {
			df2 = new SimpleDateFormat("h:mm a");
			}
		}
	else
		df1 = new SimpleDateFormat("h:mm");
	
	Date date = null;
	
	try {
		date = df1.parse(val);		
		}
	catch (Exception e) 
		{
		if (df2 != null) {
			try {
				date = df2.parse(val);
				}
			catch (Exception e2) {
				}
			}
		}
	
	if (date == null)
		result = false;
	else
		fd.putValidatedData(field.getName(), date);

	return result;
	}	

}          //~class VDate

