// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import jakarta.servlet.*;
import jakarta.servlet.http.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/**
Validates two password input boxes to see if they are the
same. All forms should ask for the password twice when
signing up the user. 
<p>
Automatically resets both password fields if they do not
match.
<p>Note, password rules such as required length, characters
etc., are not checked by this validator. Add a {@link 
VText} to each password field for that purupose. 


@author hursh jain
**/
public final class VPasswordGroup extends FormValidator
{
Password field_one;
Password field_two;

/** 
@param	field_one	the first password box
@param	field_two	the second password box
**/
public VPasswordGroup(Form f, String name, String errorMessage, 
 Password field_one, Password field_two)
	{
	super(f, name, errorMessage);
	Argcheck.notnull(field_one, "parm field_one was null");
	Argcheck.notnull(field_two, "parm field_two was null");
	this.field_one = field_one;
	this.field_two = field_two;
	}

public boolean validate(FormData fd, HttpServletRequest req) 
	{
	String one =  field_one.getValue(fd);
	String two =  field_two.getValue(fd);
	boolean result = false;
	
	//System.out.println(">>>> 1=[" + one + "]; 2=[" + two + "]");
	if ( one != null && one.equals(two) )
            		result = true;
	
	if (! result) {
		field_one.reset(fd);
		field_two.reset(fd);
		}	
	return result;
	}	

}          //~class VPasswordGroup

