// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import jakarta.servlet.*;
import jakarta.servlet.http.*;
import java.io.*;
import java.util.*;
import java.text.*;
import java.util.regex.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/**
Validates a date. 

@author hursh jain
**/
public final class VDate extends FieldValidator
{
static final DateFormat df; 
static final GregorianCalendar cal;

static {
	df = DateFormat.getDateInstance(DateFormat.SHORT);
	df.setLenient(false); 
	
	cal = (GregorianCalendar) df.getCalendar();
	cal.setLenient(false);
	}
	
public VDate(AbstractText field, String errorMessage)
	{
	super(field, errorMessage);
	}
	
/** 
Works with any field that returns a <b>String</b> via it's
{@link Field#getValue} method. The date string can be any
valid string that is parseable by the {@link
java.text.DateFormat.parse(String)} method (even if it's not
semantically valid). For example, the following parses OK:
<tt>02/<b>29</b>/1980</tt>

@throws ClassCastException  If the field's {@link Field#getValue} method
							does not return a String
**/
public boolean validate(FormData fd, HttpServletRequest req) 
	{
	String val = ((AbstractText) field).getValue(fd);
	
	if (val == null)
		return false;
		
	boolean result = true;
	try {
		df.parse(val);
		
		}
	catch (Exception e) {
		result = false;
		}
	return result;
	}	

}          //~class VDate

