// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import jakarta.servlet.*;
import jakarta.servlet.http.*;
import java.io.*;
import java.util.*;
import java.sql.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/**
A test dependency implementation.
*/
public class TestDependency implements Dependency
{ 
static List usa_states =  Arrays.asList( new Select.Option[] { 
			new Select.Option("pa"), 
			new Select.Option("ny", true)
			});

static List int_states =  Arrays.asList( new Select.Option[] { 
			new Select.Option("int#1"), 
			new Select.Option("int#2"), 
			new Select.Option("int#3")
			});

static 	String	selectCountryFirst = "--select a country first--";

static List select_country_msg =  Arrays.asList( new Select.Option[] { 
			new Select.Option(selectCountryFirst)
			});

Select 				country;
DependentSelect 	states;
Log					log;
String				last_name;

public TestDependency(Select country, DependentSelect state)
	{
	this.country = country;
	this.states = state;
	states.addDependency(this);
	log = states.log;
	last_name = country.name + "_last_value_id";
	}

public Object getInitialValues(Field f) 
	{
	DependentSelect.Data data = new DependentSelect.Data();  //initially empty
	data.addOption(new Select.Option(selectCountryFirst));
	return data;
	}
	
public void updateValues(FormData fd, HttpServletRequest req) 
throws DependencyException
	{
	String country_val = country.getStringValue(fd);
	
	log.bug("country_val:", country_val);

	if (needsUpdate(country_val, fd)) {
		log.bug("needsupdate=true");	
		fd.setDependencyUpdated();
		}

	Hidden prev_country =  fd.getDynamicField(last_name);
	String prev_val 	=  (prev_country != null) ? 
								prev_country.getValue(fd).intern() : "";
		
	DependentSelect.Data data = (DependentSelect.Data) 
												fd.getData(states.getName());
	
	if (country_val == null || country_val.equalsIgnoreCase("--- select ---")){
		states.setValue(data, select_country_msg);
		}
	else if (country_val.equalsIgnoreCase("usa")) { 
		states.setValue(data, usa_states);
		if (prev_val != "usa") 
			data.clearSubmittedData();
		}
	else if (country_val.equalsIgnoreCase("uk")) {
		states.setValue(data, int_states);
		if (prev_val != "uk") 
			data.clearSubmittedData();
		}
	else
		throw new DependencyException("Bad country value (" + country_val + "), cannot calculate state dependency from this country");	
		
	}

boolean needsUpdate(String country_val, FormData fd)
	{	
	if (country_val == null)
		return false;
	
	Hidden prev_country =  fd.getDynamicField(last_name);
	log.bug("prev_country: ", prev_country);
		
	if (prev_country == null)
		return true;
	
	String prev_val = prev_country.getValue(fd); //can be null
	
	log.bug("country_val: ", country_val, "; prev_value:", prev_val);

	return ! country_val.equals(prev_val);
	}

public void setDependencyDataFromSubmit(FormData fd, HttpServletRequest req)
	{
	String[] hidden_values = req.getParameterValues(last_name);
	
	log.bug("hidden_values=", Arrays.toString(hidden_values));
	
	if (hidden_values != null) {
		Hidden h = new Hidden(last_name, hidden_values);
		fd.addDynamicField(h);
		}
	}
		
public void renderDependencyData(FormData fd, Writer out) 
throws SQLException, IOException
	{
	log.bug("start..");
	if (fd != null) {
		String country_val = country.getStringValue(fd);
		if (country_val != null) {
			Hidden h = new Hidden(last_name, country_val);
			h.render(out); 
			}
		}
	}
		
public boolean isSubmitDataValid(FormData fd)
	{
	return true; 
	}

public String toString() {
	return "country-->state dependency";
	}

}          //~class DependencyOnSelect