// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.util;

import java.util.*;
import fc.io.*;

/**
Prints a welcome message along with some class loading and env. information.

If this runs properly, then you have molly!
*/
public final class Version 
{
//these are/should be filled in by the build (bash) script when this is copied to the build area
public static final String build_version = "1.0.30";
public static final String build_time	 = "2025-10-19 18:26";

public static void main(String args[]) 
	{
	Args myargs = new Args(args);
	myargs.setUsage("java fc.util.Version [-full]");
	boolean full = myargs.flagExists("full");
	
	System.out.println("----------------------------http://mollypages.org -----------------------");
	System.out.println("Welcome to molly - punching your ticket to happiness!");
	System.out.println("This class loaded from: " + ClassUtil.getLoadedFromPath(Version.class));
	if (! build_version.startsWith("REPLACE_")) {
		System.out.println("Framework version: " + build_version + "; source compiled at: " + build_time);
		}
	System.out.println("-------------------------------------------------------------------------");
	System.out.println("Use the -full flag to print out all the Java environment variables!");
	
	if (full) {
		printSystemInfo();
		}
	}

/**
Prints system env info to the console
*/
static void printSystemInfo() 
	{	
	System.out.println();
	System.out.println("Environment information");
	TablePrinter.PrintConfig config = new TablePrinter.PrintConfig();
	int cols = MiscUtil.getTerminalColumnCount();
	int firstcol = 34;
	int secondcol = 61;
	if (cols !=	-1) {
		cols = cols/3;
		firstcol = cols - 10; 
		secondcol = cols*2 - 10; 
		System.out.println(firstcol + "," + secondcol);
		}

	config.setCellWidthForColumn(0, firstcol);
	config.setCellWidthForColumn(1, secondcol);
	TablePrinter printer = new TablePrinter(2, System.out, config);
	config.setHeader(new String[] {"Key", "Value"});

	printer.startTable();
	
	Properties p = System.getProperties();
	Enumeration e = p.propertyNames();
	while (e.hasMoreElements()) {
		printer.startRow();
		String name = (String) e.nextElement();		
		printer.printCell(name);
		printer.printCell(StringUtil.viewableAscii(p.getProperty(name)));
		printer.endRow();	
		}	
		
	printer.endTable();
	}

}