// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.util;

import fc.util.*;
import java.net.*;
import java.util.*;
import javax.mail.*;
import javax.mail.internet.*;

/**
Sends a simple SMTP message. Useful for sending system and admin alerts
from the command line or within an application.
<p>
Notes: <br>
Make sure that the CLASSPATH is set properly. If invoked from the command
line, the CLASSPATH should include the following classes:
<blockquote>
	<pre>
	1. activation.jar  (java activation framework API's, needed for javamail)
	2. mail.jar        (javamail API's)
	3. fc.util.Args	   (for parsing arguments)
	</pre>
</blockquote>

Also, manually do a nslookup and find out the MX for the mail server that
you should use. Most any mail servers will not allow relays to email
addresses outside of that servers domain, so make sure the recipient is
in the same domain as the mail server.

@author hursh jain
**/
public class SimpleMail
{
static final String nl = System.getProperty("line.separator");

//server socket connection timeout in ms, change and recompile if needed
static final String socketConnectiontimeout = "10000";  

//server socket IO timeout in ms, change and recompile if needed
static final String socketIOtimeout = "10000";  

public static void main(String[] args)
	{
	try {
		doSend(args);
		}
	catch (Exception e) {
		e.printStackTrace();
		}
	}

static void doSend(String[] args) throws Exception 
	{
	Args myargs = new Args(args);
	myargs.setUsage
	(
		"Usage: java smtpsend <options> " + nl +
		"where <options> are: " + nl + nl +
		" -server smtpserver        the smtp server to use for the outgoing message"+ nl +
	  	" -from email-address       the from field in the email message" + nl +
		" -to email-address         the email address(only 1) to send to" + nl +										
		" [-subject subject-string] the subject of the message" + nl +
	  	" -message message-string   the plain text message to be sent" + nl +
		" [-debug true]             turns on program debugging output" + nl + nl +
		"Note: arguments (if any) shown inside \"[..]\" are optional, all else are required"
	);
	String 	server = myargs.getRequired("server"); 
	String 	from = myargs.getRequired("from");
	String 	to = myargs.getRequired("to");
	String 	subject = myargs.get("subject", "");
	String 	message = myargs.getRequired("message");
	boolean dbg = myargs.flagExists("debug");
	
	if (dbg) System.out.println("Parsed args: " + "server="+server + ";from="+from + ";to="+to + ";subject="+subject + ";message="+message);
	send(server, from, to, subject, message, dbg);
	}
	
public static void send(
	String targetMailServer, String from, String to, String subject, 
	String message, boolean dbg) throws Exception
	{
	Properties props = System.getProperties();
	props.setProperty("mail.smtp.host", targetMailServer);
	props.setProperty("mail.smtp.connectiontimeout", socketConnectiontimeout);	
	props.setProperty("mail.smtp.timeout", socketIOtimeout);	
	
	Session session = Session.getDefaultInstance(props, null);
	if (dbg) {
		session.setDebug(true);
		}
	
	Message msg = new MimeMessage(session);
	msg.setFrom(new InternetAddress(from));
	msg.setRecipient(Message.RecipientType.TO, new InternetAddress(to));
	msg.setSubject(subject);
	msg.setText(message);	
	msg.setSentDate(new Date());
	
	Transport.send(msg);
	}

}