// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.util;


/**
Identifies the current platform/OS that the JVM is running
under. There is only 1 instance of this class corresponding 
to each type of platform. Therefore reference equality
can be used to compare whether the current platform is
the same as some particular platform type.

@author hursh jain
**/

public class Platform 
{
public static final Platform LINUX = new Platform("linux");
public static final Platform WINDOWS = new Platform("windows");
public static final Platform SOLARIS = new Platform("solaris");
public static final Platform OSX = new Platform("osx");
public static final Platform FREEBSD = new Platform("freebsd");
public static final Platform OPENBSD = new Platform("openbsd");
/** other OS's including HPUX, IRIX, AIX, and many others **/
public static final Platform OTHER = new Platform("other");

private static Platform currentPlatform;
private String name;
private static byte count = 1;

//inintialize the current platform
static {
	Platform.init();	
	}

private Platform(String name) {
	this.name = name;
	}

public static Platform getPlatform() {
	return currentPlatform;
    }

//No need to define/use equals(), since there is one
//reference to each type only, == suffices

public static boolean isWindows() {
    return (currentPlatform == WINDOWS);
    }

public static boolean isOSX() {
    return (currentPlatform == OSX);
    }

public static boolean isLinux() {
    return (currentPlatform == LINUX);
    }

public static boolean isSolaris() {
    return (currentPlatform == SOLARIS);
    }

public static boolean isFreeBSD() {
    return (currentPlatform == FREEBSD);
    }

public static boolean isOpenBSD() {
    return (currentPlatform == OPENBSD);
    }

public static boolean isOther() {
    return (currentPlatform == OTHER);
    }

public static boolean isAIX() {
    return (currentPlatform == WINDOWS);
    }

private static void init() 
	{
	String osname = System.getProperty("os.name").toLowerCase();
	//System.out.println(osname);
	if ( osname.indexOf("windows") != -1 ) {
		currentPlatform = WINDOWS;
		}
	else if ( osname.indexOf("linux") != -1 ) {
		currentPlatform = LINUX;
		}
	else if ( osname.indexOf("sun") != -1 ) {
		currentPlatform = SOLARIS;
		}
	else if ( osname.toLowerCase().indexOf("mac") != -1 
			&& osname.toLowerCase().indexOf("x") != -1) {
		currentPlatform = OSX;
		}
	else if ( osname.indexOf("freebsd") != -1 ) {
		currentPlatform = FREEBSD;
		}
	else if ( osname.indexOf("openbsd") != -1 ) {
		currentPlatform = OPENBSD;
		}
	else {
		currentPlatform = OTHER;
		}
	}  	//~init

public String toString() {
	return name;
	}

public static void main(String[] args)
	{
	System.out.println("Current platform: " + getPlatform());	
	}

}
