// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.util;

import java.util.*;
import java.util.regex.*;

/* 
HTML Utility functions

@author hursh jain
*/
public final class HTMLUtil
{
/**
Replaces all occurences of single <i>and</i> double quotes
with corresponding HTML entities. This is useful when setting 
attribute values containing those characters and maintaining
state for characters typed by the user.
For example,
<pre>
&lt;input type=text value=<font size="+1">'</font><font color=blue>O<font size="+1"><font size="+1" color=red>'</font></font>Reilly</font><font size="+1">'</font>&gt;
</pre>
<tt>O'Reilly</tt> could have been typed in by the user (and we are maintaining
state so we have to show the value back to the user) or it could have been
retrieved from the database. Either way, when the form is resubmitted, it would
not be sent properly by the browser.
<p>
The embedded single quote in the value trips up the browser, because it
prematurely ends the value. One would think that the following backslash-escape
would work:
<pre>
&lt;input type=text value='<font color=blue>O<font size="+1" color=red>\</font><b>'</b>Reilly</font>'&gt;
</pre>
Unfortunately, escaping like this does <b>not</b> work reliably in firefox,
safari or IE. 
<p>
Here is another example:
<pre>
&lt;input type=text value=<font size="+1">"</font><font color=blue>foo<font size="+1" color=red>"</font>bar</font><font size="+1">"</font>&gt;
</pre>
The following escape does <b>not</b> work either:
<pre>
&lt;input type=text value=<font size="+1">"</font><font color=blue>foo<font size="+1" color=red>\"</font>bar</font><font size="+1">"</font>&gt;
</pre>
To be safe, all embedded quotes must be encoded using character escapes:
(<tt>single quote (') as &amp;#39; </tt>) and double quote (<tt>double (") as
&amp;#34; </tt>). So
<pre>
&lt;input type=text value='<font color=blue>O<b>&amp;#39;</b>Reilly</font>'&gt;
</pre>
This works fine and is submitted by the browser as <tt>O'Reilly</tt>
<p>
This method is critically useful. <a href="http://www.imdb.com/title/tt0083929/quotes">Learn it. Live it</a>.
*/
public static String quoteToEntity(String str)
	{
	if (str == null || str.equals(""))
		return str;
	
	String ret = str
		.replace("\"", "&#34;")
		.replace("'", "&#39;");
		
	return ret;
	}

/**
Replaces embedded entities for single and double quotes, back to the
correspoding single and double quote characters. This method is
the converse of {@link #quoteToEntity(String)}
*/
public static String entityToQuote(String str)
	{
	if (str == null || str.equals(""))
		return str;
	
	String ret = str
		.replace("&#34;", "\"")
		.replace("&#39;", "'");		
	
	return ret;
	}

private static void test(String desc, String s)
	{
	String tmp = null, tmp2 = null;
	
	tmp = HTMLUtil.quoteToEntity(s);
	tmp2 = HTMLUtil.entityToQuote(tmp);

	System.out.println(  String.format("%15s",desc) + " -> " 
					   + String.format("%15s", tmp) + " -> " 
					   + String.format("%10s", tmp2)
					   );	
	}

public static void main (String args[])
	{
	test("empty", "");
 	test("spaces", "  ");
 	test("single-quote", "'");
 	test("double-quote", "\"");
 	test("X'Y\"Z", "X'Y\"Z");
 	test("\\'\\'", "\\'\\'");
   	}
}			//~class HTMLUtil