// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.util;

import java.io.*;
import java.util.*;

/**
Should be implemented for custom code functionality inside a 
{@link fc.util.Template}. Implementing classes <b>must</b> have
a no-arg constructor. It is guaranteed that only one instance
of this class will be instantiated by the engine, although
multiple threads may possible use this class at the same time.

@author hursh jain
**/
public interface CustomCode 
{
/**
Called back from the template engine while substiting data inside
a template. 
@param	writer 	can be used to write data at the  point in the merged 
				file where the custom code was called. This writer
				should <b>not</b> be closed, otherwise the template engine
				will not be able to proceed after this method is invoked (since
				the template engine also uses the same writer.
@param	env		a reference to the template engine, can be used to
				invoke methods in the engine.
**/
public void code(Writer writer, Template env) throws IOException;
}           //~interface CustomCode