// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.jdbc.dbo.generated;

/*
 * Auto generated on: Wed May 18 15:51:41 EDT 2022
 * JDBC url: [jdbc:postgresql://127.0.0.1/test]
 * WARNING: Manual edits will be lost if/when this file is regenerated.
 */
import java.io.*;
import java.math.*;
import java.sql.*;
import java.util.*;

import fc.io.*;
import fc.jdbc.*;
import fc.jdbc.dbo.*;
import fc.util.*;
import fc.web.forms.*;

/**
Manages various operations on the alltypes table. 

<p>Most methods of this class take a {@link java.sql.Connection Connection} as an argument
and use that connection to run various queries. The connection parameter is never closed
by methods in this class and that connection can and should be used again. Methods of this
class will also throw a <tt>IllegalArgumentException</tt> if the specified connection
object is <tt>null</tt>.

<p>Thread Safety: Operations on this class are by and large thread safe in that multiple
threads can call the methods at the same time. However, seperate threads should use
seperate connection objects when invoking methods of this class.
*/
public final class alltypesMgr extends fc.jdbc.dbo.DBOMgr
{
/* --- Fields used for collecting usage statistics --- 
Increments to these don't need to be synchronized since these are
ints and not longs and memory visibility is not an issue in the
toString() method (in which these are read).
*/
private static int __getall_called = 0;
private static int __getlimited_called = 0;
private static int __getbykey_called = 0;
private static int __getwhere_called = 0;
private static int __getusing_called = 0;
private static int __getusing_ps_called = 0;
private static int __getfromrs_called = 0;
private static int __save_called = 0;
private static int __delete_called = 0;
private static int __deletebykey_called = 0;
private static int __deletewhere_called = 0;
private static int __deleteusing_called = 0;
private static int __count_called = 0;
private static int __countwhere_called = 0;
private static int __countusing_called = 0;
private static int __exists_called = 0;
/* -------------- end statistics fields -------------- */

/** Constructor is private since class is never instantiated */
private alltypesMgr() {
	}


static private final String getAllStmt = "SELECT id, smallint_val, int_val, bigint_val, float_val, double_val, numeric_val, char_val, varchar_val, longvarchar_val, date_val, time_val, timestamp_val, bit_val, array_val, boolean_val, varbinary_val, json_val, jsonb_val from alltypes";
/** 
Returns all rows in the table. Use with care for large tables since
this method can result in VM out of memory errors. <p>This method
also takes an optional (can be null) <tt>clause</tt> parameter which
is sent as is to the database. For example, a clause can be:
<blockquote><pre>
order by some_column_name
</pre> </blockquote>
@return 	a list containing {@link alltypes } objects <i>or an empty list</i> if there are no rows in the database*/
public static List getAll(final Connection con, final String clause) throws SQLException
	{
	__getall_called++;
	final List list = new ArrayList();
	final String getAllStmtClaused = (clause == null) ? 
						   getAllStmt : getAllStmt + " " + clause;
	PreparedStatement ps = prepareStatement(con, getAllStmtClaused);
	log.bug("Query to run: ", ps);
	final ResultSet rs = ps.executeQuery();
	while (true) {
		alltypes bean = decodeFromRS(rs);
		if (bean == null) { break; } 
		list.add(bean);
		}
	rs.close();
	return list;
	}

/** 
Convenience method that invokes {@link getAll(Connection, alltypes, String) getAll} with an empty additional clause.
*/
public static List getAll(final Connection con) throws ValidateException, SQLException
	{
	return getAll(con, null);
	}

static private final String getLimitedStmt = "SELECT id, smallint_val, int_val, bigint_val, float_val, double_val, numeric_val, char_val, varchar_val, longvarchar_val, date_val, time_val, timestamp_val, bit_val, array_val, boolean_val, varbinary_val, json_val, jsonb_val from alltypes";
/** 
Returns all rows in the table starting from some row number and limited
by a certain number of rows after that starting row. 
<p>
This method takes a required (non-null) <code>order_clause</code>, since when using
a limit clause, rows must be ordered for the limit to make sense. The
clause should be of the form <font color=blue>order by ...</font>
<p>
The <code>limit</code> specifies the number of rows that will be returned. (those many
or possibly lesser rows will be returned, if the query itself yields less
rows).
<p>
The <code>offset</code> skips that many rows before returning rows. A zero offset is
the same as a traditional query with no offset clause, where rows from
the beginning are returned. If say, offset = 10, then rows starting from
row 11 will be returned.
<p>
The sql-query generated by this method is database specific but will (typically) look like:
<blockquote><pre>
select &lt;column_list&gt; from &lt;table&gt; order by &lt;clause&gt; limit 5 offset 10
</pre> </blockquote>
@return 	a list containing {@link alltypes } objects <i>or an empty list</i> if there are no rows in the database*/
public static List getLimited(final Connection con, final String order_clause, int limit, int offset) throws SQLException
	{
	__getlimited_called++;
	final List list = new ArrayList();
	final String tmp = getLimitedStmt + " " + order_clause + " LIMIT " + limit + " OFFSET " + offset;
	PreparedStatement ps = prepareStatement(con, tmp);
	log.bug("Query to run: ", ps);
	final ResultSet rs = ps.executeQuery();
	while (true) {
		alltypes bean = decodeFromRS(rs);
		if (bean == null) { break; } 
		list.add(bean);
		}
	rs.close();
	return list;
	}

static private final String getByPKStmt = "SELECT id, smallint_val, int_val, bigint_val, float_val, double_val, numeric_val, char_val, varchar_val, longvarchar_val, date_val, time_val, timestamp_val, bit_val, array_val, boolean_val, varbinary_val, json_val, jsonb_val from alltypes WHERE id=?";
/** 
Returns <b>the</b> row corresponding to the specified primary key(s) of this table 
or <b><tt>null</tt></b> if no row was found.
<p>This method uses a prepared statement and is safe from SQL injection attacks
*/
public static alltypes getByKey(final Connection con, int id) throws SQLException
	{
	__getbykey_called++;
	PreparedStatement ps = prepareStatement(con, getByPKStmt);
	StringBuilder errbuf = null;

	//id [int] is primitive, skipping null test
	ps.setInt(1, id); 
	
	if (errbuf != null) {
		throw new ValidateException(errbuf.toString());
		}
	final ResultSet rs = ps.executeQuery();
	log.bug("Query to run: ", ps);
	alltypes bean = decodeFromRS(rs);
	rs.close();
	return bean;
	}

/** 
Returns the rows returned by querying the table with the specified
<tt>WHERE</tt> clause or <i>an empty list</i> if no rows were found.
(note: the string <tt>"WHERE"</tt> does <b>not</b> have to be
specified in the clause. It is added automatically by this method).
<p>Queries can use database functions such as: <code>lower()</code>,
<code>upper()</code>, <code>LIKE</code> etc. For example:
<pre><blockquote>alltypesMgr.getWhere("lower(col_a) = 'foo'")
//compares the lower case value of col_a with the string 'foo'
</blockquote></pre>
<p><b>The "where" clause is sent as-is to the database</b>. SQL
injection attacks are possible if it is created as-is from a <b><u>untrusted</u></b> source.

@throws	IllegalArgumentException if the specified <tt>where</tt> parameter is null
*/
public static List getWhere(final Connection con, final String where) throws SQLException
	{
	__getwhere_called++;
	Argcheck.notnull(where, "the where parameter was null (and should not be null)");
	final String where_stmt = "SELECT id, smallint_val, int_val, bigint_val, float_val, double_val, numeric_val, char_val, varchar_val, longvarchar_val, date_val, time_val, timestamp_val, bit_val, array_val, boolean_val, varbinary_val, json_val, jsonb_val from alltypes WHERE " + where ;
	Statement stmt = QueryUtil.getRewindableStmt(con);
	log.bug("Query to run: ", stmt, " ", where_stmt);
	final List list = new ArrayList();
	final ResultSet rs = stmt.executeQuery(where_stmt);
	while (true) {
		alltypes bean = decodeFromRS(rs);
		if (bean == null) { break; } 
		list.add(bean);
		}
	stmt.close();
	return list;
	}

/** 
Returns the rows returned by querying the table with the value of the
specified <tt>alltypes</tt> object or <i>an empty list</i> if no rows were found. As many
fields in <tt>alltypes</tt> can be set as needed and the values of
all set fields (including fields explicitly set to <tt>null</tt>)
are then used to perform the query.
<p>
This method is often convenient/safer than the {@link #getWhere
getWhere} method (because the <tt>getWhere</tt> method takes an
arbitrary query string which has to be properly escaped by the
user).
<p>Essentially, this method is a more convenient way to use a
PreparedStatement. Internally, a prepared statement is created and
it's parameters are set to fields that are set in this object).
Using PreparedStatements directly is also perfectly fine. For
example, the following are equivalent. 
<p> Using a PreparedStatement:
<blockquote><pre>
String foo = "select * from table_foo where x = ? and y = ?";
PreparedStatement ps = con.prepareStatement(foo);
ps.setString(1, "somevalue");
ps.setString(2, "othervalue");
ResultSet rs  = ps.executeUpdate();
while (rs.next()) {
    table_foo bean = table_fooMgr.getFromRS(rs);
    }
</pre> </blockquote>

Using this method:
<blockquote><pre>
table_foo <font color=blue>proto</font> = new table_foo();
proto.set_x("somevalue");	//compile time safety
proto.set_y("othervalue");	//compile time safety
List beans = table_fooMgr.<font color=blue>getUsing(proto)</font>;
</pre> </blockquote>
<p>This method also takes an <tt>clause</tt> parameter which
is sent as is to the database. For example, a clause can be:
<blockquote><pre>
List beans = table_fooMgr.<font color=blue>getUsing(proto, <b>"order by some_column_name"</b>)</font>;
</pre> </blockquote>
This clause is optional. Specify <tt>null</tt> to not use it at all.
If the clause is specified, do <font size='+1'><b>NOT</b></font> include the word <tt>WHERE</tt>.

The fields that are set in the proto object (as shown above) are sent as
part of a WHERE clause constructed internally. If you are specifying a clause
as well, you should not specify the word <tt>WHERE</tt>. However, you may have
to specify <tt>AND</tt> to add to the internal WHERE clause, if you have set any
fields in the proto object. For example
<blockquote><pre>
List beans = table_fooMgr.<font color=blue>getUsing(proto, <b>"and bar = 5"</b>)</font>;
</pre> </blockquote>
<p>Note: For a <i>very</i> large number of rows, it may be more
efficient to use a prepared statement directly (as opposed to using
this method). In most cases, this is not something to worry about,
but your mileage may vary...
*/
public static List getUsing(final Connection con, final alltypes bean, final String clause) throws ValidateException, SQLException
	{
	__getusing_called++;
	Argcheck.notnull(bean, "the bean parameter was null (and should not be null)");
	if (! bean.isModified()) { 
		throw new ValidateException("bean=" + bean + " not modified, ignoring query");
		}

	int __count = 0;
	final StringBuilder buf = new StringBuilder(512);
	buf.append("SELECT id, smallint_val, int_val, bigint_val, float_val, double_val, numeric_val, char_val, varchar_val, longvarchar_val, date_val, time_val, timestamp_val, bit_val, array_val, boolean_val, varbinary_val, json_val, jsonb_val from alltypes WHERE ");
	if (bean.isModified_id()) { 
		buf.append("id=? and ");
		__count++;
		}
	if (bean.isModified_smallint_val()) { 
		if (bean.isModifiedSetNull_smallint_val()) {
			buf.append("smallint_val is NULL and ");
			}
		else{
			buf.append("smallint_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_int_val()) { 
		buf.append("int_val=? and ");
		__count++;
		}
	if (bean.isModified_bigint_val()) { 
		if (bean.isModifiedSetNull_bigint_val()) {
			buf.append("bigint_val is NULL and ");
			}
		else{
			buf.append("bigint_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_float_val()) { 
		if (bean.isModifiedSetNull_float_val()) {
			buf.append("float_val is NULL and ");
			}
		else{
			buf.append("float_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_double_val()) { 
		if (bean.isModifiedSetNull_double_val()) {
			buf.append("double_val is NULL and ");
			}
		else{
			buf.append("double_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_numeric_val()) { 
		if (bean.get_numeric_val() == null) {
			buf.append("numeric_val is NULL and ");
			}
		else{
			buf.append("numeric_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_char_val()) { 
		if (bean.get_char_val() == null) {
			buf.append("char_val is NULL and ");
			}
		else{
			buf.append("char_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_varchar_val()) { 
		if (bean.get_varchar_val() == null) {
			buf.append("varchar_val is NULL and ");
			}
		else{
			buf.append("varchar_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_longvarchar_val()) { 
		if (bean.get_longvarchar_val() == null) {
			buf.append("longvarchar_val is NULL and ");
			}
		else{
			buf.append("longvarchar_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_date_val()) { 
		if (bean.get_date_val() == null) {
			buf.append("date_val is NULL and ");
			}
		else{
			buf.append("date_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_time_val()) { 
		if (bean.get_time_val() == null) {
			buf.append("time_val is NULL and ");
			}
		else{
			buf.append("time_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_timestamp_val()) { 
		if (bean.get_timestamp_val() == null) {
			buf.append("timestamp_val is NULL and ");
			}
		else{
			buf.append("timestamp_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_bit_val()) { 
		if (bean.get_bit_val() == null) {
			buf.append("bit_val is NULL and ");
			}
		else{
			buf.append("bit_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_array_val()) { 
		if (bean.get_array_val() == null) {
			buf.append("array_val is NULL and ");
			}
		else{
			buf.append("array_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_boolean_val()) { 
		if (bean.get_boolean_val() == null) {
			buf.append("boolean_val is NULL and ");
			}
		else{
			buf.append("boolean_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_varbinary_val()) { 
		if (bean.get_varbinary_val() == null) {
			buf.append("varbinary_val is NULL and ");
			}
		else{
			buf.append("varbinary_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_json_val()) { 
		if (bean.get_json_val() == null) {
			buf.append("json_val is NULL and ");
			}
		else{
			buf.append("json_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_jsonb_val()) { 
		if (bean.get_jsonb_val() == null) {
			buf.append("jsonb_val is NULL and ");
			}
		else{
			buf.append("jsonb_val=? and ");
			__count++;
			}
		}

	buf.setLength(buf.length() - 4);

	if (clause != null) {
		buf.append(" ");
		buf.append(clause);
		}

	final String getUsingPKStmt = buf.toString();
	PreparedStatement ps = prepareStatement(con, getUsingPKStmt);
	int pos = 0;
	if (bean.isModified_id()) {
			pos++;
			int id = bean.get_id();
			ps.setInt(pos, id); 
			}
	if (bean.isModified_smallint_val()) {
		if (bean.isModifiedSetNull_smallint_val()) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			short smallint_val = bean.get_smallint_val();
			ps.setShort(pos, smallint_val); 
			}
		}
	if (bean.isModified_int_val()) {
			pos++;
			int int_val = bean.get_int_val();
			ps.setInt(pos, int_val); 
			}
	if (bean.isModified_bigint_val()) {
		if (bean.isModifiedSetNull_bigint_val()) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			long bigint_val = bean.get_bigint_val();
			ps.setLong(pos, bigint_val); 
			}
		}
	if (bean.isModified_float_val()) {
		if (bean.isModifiedSetNull_float_val()) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			float float_val = bean.get_float_val();
			ps.setFloat(pos, float_val); 
			}
		}
	if (bean.isModified_double_val()) {
		if (bean.isModifiedSetNull_double_val()) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			double double_val = bean.get_double_val();
			ps.setDouble(pos, double_val); 
			}
		}
	if (bean.isModified_numeric_val()) {
		if (bean.get_numeric_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			BigDecimal numeric_val = bean.get_numeric_val();
			ps.setBigDecimal(pos, numeric_val); 
			}
		}
	if (bean.isModified_char_val()) {
		if (bean.get_char_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			String char_val = bean.get_char_val();
			ps.setString(pos, char_val); 
			}
		}
	if (bean.isModified_varchar_val()) {
		if (bean.get_varchar_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			String varchar_val = bean.get_varchar_val();
			ps.setString(pos, varchar_val); 
			}
		}
	if (bean.isModified_longvarchar_val()) {
		if (bean.get_longvarchar_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			String longvarchar_val = bean.get_longvarchar_val();
			ps.setString(pos, longvarchar_val); 
			}
		}
	if (bean.isModified_date_val()) {
		if (bean.get_date_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			java.sql.Date date_val = bean.get_date_val();
			ps.setDate(pos, date_val); 
			}
		}
	if (bean.isModified_time_val()) {
		if (bean.get_time_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			Time time_val = bean.get_time_val();
			ps.setTime(pos, time_val); 
			}
		}
	if (bean.isModified_timestamp_val()) {
		if (bean.get_timestamp_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			Timestamp timestamp_val = bean.get_timestamp_val();
			ps.setTimestamp(pos, timestamp_val); 
			}
		}
	if (bean.isModified_bit_val()) {
		if (bean.get_bit_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			Boolean bit_val = bean.get_bit_val();
			ps.setObject(pos, bit_val); 
			}
		}
	if (bean.isModified_array_val()) {
		if (bean.get_array_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			java.sql.Array array_val = bean.get_array_val();
			ps.setArray(pos, array_val); 
			}
		}
	if (bean.isModified_boolean_val()) {
		if (bean.get_boolean_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			Boolean boolean_val = bean.get_boolean_val();
			ps.setObject(pos, boolean_val); 
			}
		}
	if (bean.isModified_varbinary_val()) {
		if (bean.get_varbinary_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			byte[] varbinary_val = bean.get_varbinary_val();
			ps.setBytes(pos, varbinary_val); 
			}
		}
	if (bean.isModified_json_val()) {
		if (bean.get_json_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			String json_val = bean.get_json_val();
			ps.setObject(pos, json_val, java.sql.Types.OTHER); 
			}
		}
	if (bean.isModified_jsonb_val()) {
		if (bean.get_jsonb_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			String jsonb_val = bean.get_jsonb_val();
			ps.setObject(pos, jsonb_val, java.sql.Types.OTHER); 
			}
		}
	log.bug("Query to run: ", ps);
	final List list = new ArrayList();
	final ResultSet rs = ps.executeQuery();
	while (true) {
		alltypes row = decodeFromRS(rs);
		if (row == null) { break; } 
		list.add(row);
		}
	rs.close();
	return list;
	}

/** 
Convenience method that invokes {@link getUsing(Connection, alltypes, String) getUsing} with an empty <i><tt>clause</tt></i> parameter.*/
public static List getUsing(final Connection con, final alltypes bean) throws ValidateException, SQLException
	{
	return getUsing(con, bean, null);
	}

/**
This is a <i>convenience</i> method that runs the specified 
prepared statement to perform an arbitrary query. For example: 
<blockquote>
<pre>
PreparedStatement <font color=blue>ps</font> = con.prepareStatement(
		"select * from some_table where some_column = ?");
ps.setString(1, "foo");
List list = fooMgr.<font color=blue>getUsing</font>(con, <font color=blue>ps</font>);
for (int n = 0; n < list.size(); n++) {
	sometable t = (sometable) list.get(n);
	//do something
	}
</pre>
</blockquote>
The effect of the above is <u>equivalent</u> to the following (larger) block 
of code:
<blockquote>
<pre>
PreparedStatement <font color=blue>ps</font> = con.prepareStatement(
	"select * from sometable where some_column = ?"
	);
ps.setString(1, "foo");
ResultSet rs = <font color=blue>ps.executeQuery()</font>;
List list = new ArrayList();
while (rs.next()) {
	list.add(sometableMgr.<font color=blue>getFromRS(rs)</font>);
	}

for (int n = 0; n < list.size(); n++) {
	sometable t = (sometable) list.get(n);
	//do something
	}
</pre>
</blockquote>

Note: Just as with other get<i>XXX</i> methods, for large amounts of
rows (say many thousands), it may be more efficient use and iterate
through a JDBC result set directly.
*/
public static List getUsing(final Connection con,  final PreparedStatement ps) throws ValidateException, SQLException
	{
	__getusing_ps_called++;
	log.bug("Query to run: ", ps);
	final List list = new ArrayList();
	final ResultSet rs = ps.executeQuery();
	while (true) {
		alltypes row = decodeFromRS(rs);
		if (row == null) { break; } 
		list.add(row);
		}
	rs.close();
	return list;
	}

/**
This is a <i>convenience</i> method that runs the specified 
{@link fc.jdbc.dbo.NamedParamStatement NamedParamStatement} to perform an arbitrary query.
For example: <blockquote>
<pre>
NamedParamStatement <font color=blue>ps</font> = queryReadeer.getQuery("somequery");
ps.setString("some_placeholder", "foo");
List list = fooMgr.<font color=blue>getUsing</font>(con, <font color=blue>ps</font>);
for (int n = 0; n < list.size(); n++) {
	sometable t = (sometable) list.get(n);
	//do something
	}
</pre>
</blockquote>

Note: Just as with other get<i>XXX</i> methods, for large amounts of
rows (say many thousands), it may be more efficient use and iterate
through a JDBC result set directly.
*/
public static List getUsing(final Connection con,  final NamedParamStatement ps) throws ValidateException, SQLException
	{
	__getusing_ps_called++;
	log.bug("Query to run: ", ps);
	final List list = new ArrayList();
	final ResultSet rs = ps.executeQuery();
	while (true) {
		alltypes row = decodeFromRS(rs);
		if (row == null) { break; } 
		list.add(row);
		}
	rs.close();
	return list;
	}

/** 
Returns a <i>comma delimited list</i> of <i>all</i> columns in <tt>alltypes</tt>. These column names are fully qualified, i.e., they contain 
table name as a prefix to the column name. For example:
<blockquote><pre>
<tt>tablename.column1 AS tablename_column1, tablename.column2 AS tablename_column2 ...</tt>
</pre></blockquote>
<p>This list is suitable for placing in the column(s) clause of a select query, such as: 
<blockquote>
<tt>Single table: select <i><font color=blue>[column_list_A]</font></i> from table_A</tt><br>
<tt>Join: select <i><font color=blue>[column_list_A], [column_list_B]</font></i> from table_A, table_B</tt>
</blockquote>
The ResultSet returned by the query can be used directly or can be passed
to the {@link #getFromRS getFromRS} method to convert it into a list of <code>alltypes
</code> objects. If the query is a join across multiple tables,
then the {@link #getFromRS getFromRS} method for each table manager
can be called on the same ResultSet to retrieve the row object for
that table.
Note: the returned list of names has a trailing space, which is good when
the rest of the query is appended to this list.
*/
public static String columns() throws SQLException
	{
	return "alltypes.id as alltypes_id, alltypes.smallint_val as alltypes_smallint_val, alltypes.int_val as alltypes_int_val, alltypes.bigint_val as alltypes_bigint_val, alltypes.float_val as alltypes_float_val, alltypes.double_val as alltypes_double_val, alltypes.numeric_val as alltypes_numeric_val, alltypes.char_val as alltypes_char_val, alltypes.varchar_val as alltypes_varchar_val, alltypes.longvarchar_val as alltypes_longvarchar_val, alltypes.date_val as alltypes_date_val, alltypes.time_val as alltypes_time_val, alltypes.timestamp_val as alltypes_timestamp_val, alltypes.bit_val as alltypes_bit_val, alltypes.array_val as alltypes_array_val, alltypes.boolean_val as alltypes_boolean_val, alltypes.varbinary_val as alltypes_varbinary_val, alltypes.json_val as alltypes_json_val, alltypes.jsonb_val as alltypes_jsonb_val ";
	}

/** 
Returns a <i>comma delimited list</i> of <i>all</i> columns in <tt>alltypes</tt>. These column names are prefix with the specified prefix, which corresponds to the
table abbreviation used in the "AS" clause. For example:
<blockquote><pre>
<tt>xyz.column1 AS xyz_column1, xyz.column2 AS xyz_column2 ...</tt>
</pre></blockquote>
<p>This list is suitable for placing in the column(s) clause of a select query, such as: 
<blockquote>
<p><b>Note:</b> the "." will automatically be appended between the prefix and column name
so the prefix should not end with a "." or "_", etc<p>
<tt>Single table: select <i><font color=blue>[column_list_A]</font></i> from table_A <b>AS</b> xyz</tt><br>
<tt>Join: select <i><font color=blue>[column_list_A], [column_list_B]</font></i> from table_A <b>AS</b> xyz, table_B <b>AS</b> zzz</tt>
</blockquote>
The ResultSet returned by the query can be used directly or can be passed
to the {@link #getFromRS getFromRS(String)} method to convert it into a list of <code>alltypes
</code> objects. If the query is a join across multiple tables,
then the {@link #getFromRS getFromRS(String)} method for each table manager
can be called on the same ResultSet to retrieve the row object for
that table.
Note: the returned list of names has a trailing space, which is good when
the rest of the query is appended to this list.
*/
public static String columns(String prefix) throws SQLException
	{
	final StringBuffer buf = new StringBuffer(19 * 10);

	buf.append(prefix);
	buf.append(".");
	buf.append("id");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("id");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("smallint_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("smallint_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("int_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("int_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("bigint_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("bigint_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("float_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("float_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("double_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("double_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("numeric_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("numeric_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("char_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("char_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("varchar_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("varchar_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("longvarchar_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("longvarchar_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("date_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("date_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("time_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("time_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("timestamp_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("timestamp_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("bit_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("bit_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("array_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("array_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("boolean_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("boolean_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("varbinary_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("varbinary_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("json_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("json_val");

	buf.append(", ");
	buf.append(prefix);
	buf.append(".");
	buf.append("jsonb_val");
	buf.append(" as ");
	buf.append(prefix);
	buf.append("_");
	buf.append("jsonb_val");
	buf.append(" ");

	return buf.toString();

	}

/** 
Creates and returns a new <tt>alltypes</tt> object that represents a row from the specified ResultSet. The ResultSet is
typically obtained via a handwritten query/PreparedStatement. The resulting 
ResultSet should contain all of the
column names of table, and this will only happen if the handwritten query had
a select statement that specified all fields or used a <tt>select <b>*</b>..</tt>
clause.
<p>
In the select clause, we could also be selecting multiple tables. To disambiguate
between the same field names that may exist in multiple tables, this method 
also requires that the query should use <font color=blue>fully qualified</font>
(prefixed with the table name) column names, such as:
<blockquote><pre>
<font color=blue>tablename</font>_column1
<font color=blue>tablename</font>_column2
...etc.
</pre></blockquote>
<p>
For example:
<blockquote>
<code>select <font color=blue>foo</font>.a <b>AS</b> <font color=blue>foo</font>_a, <font color=red>bar</font>.a <b>AS</b> <font color=red>bar</font>_a from <font color=blue>foo</font>, <font color=red>bar</font> where foo.a = bar.a;</code>
</blockquote>
The {@link #columns} method conveniently returns a list of column names in fully qualified format 
and is useful for this purpose.
<p>Note: This method will read the <i>current</i> row from the specified result set
and will <b>not</b> move the result set pointer to the next row after the current
row has been read. The result set should be appropriately positioned [via <tt>rs.next()</tt>]
<i>before</i> calling this method.

@return a new {@link 
alltypes} object populated with the contents of the next		row from the result set or <tt> null </tt> if
		the ResultSet was empty.
*/
public static alltypes getFromRS(final ResultSet rs) throws SQLException
	{
	__getfromrs_called++;
	Argcheck.notnull(rs, "the specified resultset parameter was null");
	boolean hasrow = ! rs.isAfterLast();
	if (! hasrow) { 
		return null; 
		} 
	alltypes bean = new alltypes();

	bean.set_id( rs.getInt("alltypes_id") );
	bean.__orig_id = rs.getInt("alltypes_id"); /* save original PK */
	if (rs.wasNull()) {
		bean.__isNullInDB_id = true;
		}
	bean.set_smallint_val( rs.getShort("alltypes_smallint_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_smallint_val = true;
		}
	bean.set_int_val( rs.getInt("alltypes_int_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_int_val = true;
		}
	bean.set_bigint_val( rs.getLong("alltypes_bigint_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_bigint_val = true;
		}
	bean.set_float_val( rs.getFloat("alltypes_float_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_float_val = true;
		}
	bean.set_double_val( rs.getDouble("alltypes_double_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_double_val = true;
		}
	bean.set_numeric_val( rs.getBigDecimal("alltypes_numeric_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_numeric_val = true;
		}
	bean.set_char_val( rs.getString("alltypes_char_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_char_val = true;
		}
	bean.set_varchar_val( rs.getString("alltypes_varchar_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_varchar_val = true;
		}
	bean.set_longvarchar_val( rs.getString("alltypes_longvarchar_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_longvarchar_val = true;
		}
	bean.set_date_val( rs.getDate("alltypes_date_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_date_val = true;
		}
	bean.set_time_val( rs.getTime("alltypes_time_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_time_val = true;
		}
	bean.set_timestamp_val( rs.getTimestamp("alltypes_timestamp_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_timestamp_val = true;
		}
	bean.set_bit_val( ((Boolean) rs.getObject("alltypes_bit_val")) );
	if (rs.wasNull()) {
		bean.__isNullInDB_bit_val = true;
		}
	bean.set_array_val( rs.getArray("alltypes_array_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_array_val = true;
		}
	bean.set_boolean_val( ((Boolean) rs.getObject("alltypes_boolean_val")) );
	if (rs.wasNull()) {
		bean.__isNullInDB_boolean_val = true;
		}
	bean.set_varbinary_val( rs.getBytes("alltypes_varbinary_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_varbinary_val = true;
		}
	bean.set_json_val( rs.getString("alltypes_json_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_json_val = true;
		}
	bean.set_jsonb_val( rs.getString("alltypes_jsonb_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_jsonb_val = true;
		}

 	/* set to true when instantiated new, false when we populate the bean from a resultset */
	bean.setNew(false);
	/* it's not modified, just loaded from the database */
	bean.resetModified();
	return bean;
	}

/** 
Creates and returns a new <tt>alltypes</tt> object that represents a row from the specified ResultSet. The ResultSet is
typically obtained via a handwritten query/PreparedStatement. The resulting 
ResultSet should contain all of the
column names of table, prefixed with the specified <i>prefix</i> argument.
a select statement that specified all fields or used a <tt>select <b>*</b>..</tt>
clause.
<p>
In the select clause, we could also be selecting multiple tables. To disambiguate
between the same field names that may exist in multiple tables, this method 
also requires that the query should use a <font color=blue>prefix</font>
(some arbitrary prefix) before column names, such as:
<blockquote><pre>
<font color=blue>foo</font>_column1
<font color=blue>foo</font>_column2
...etc.
</pre></blockquote>
This prefix will typically be the same as the table abbreviation chosen via the <b>AS</b> clause. 
If the AS clause is not used, then it is simpler to use the {@link getFromRS(ResultSet)} method instead
<p><b>Note:</b> the "." will automatically be appended between the prefix and column name
so the prefix should not end with a "." or "_", etc<p>
<p>
For example:
<blockquote>
<code>select <font color=blue>XXX</font>.a <b>AS</b> <font color=blue>XXX</font>_a, <font color=red>YYY</font>.a <b>AS</b> <font color=red>YYY</font>_a from <font color=blue>foo as XXX</font>, <font color=red>bar as YYY</font> where foo.a = bar.a;</code>
</blockquote>
The {@link #columns} method conveniently returns a list of column names in fully qualified format 
and is useful for this purpose.
<p>Note: This method will read the <i>current</i> row from the specified result set
and will <b>not</b> move the result set pointer to the next row after the current
row has been read. The result set should be appropriately positioned [via <tt>rs.next()</tt>]
<i>before</i> calling this method.

@return a new {@link 
alltypes} object populated with the contents of the next		row from the result set or <tt> null </tt> if
		the ResultSet was empty.
*/
public static alltypes getFromRS(final ResultSet rs, String prefix) throws SQLException
	{
	__getfromrs_called++;
	Argcheck.notnull(rs, "the specified resultset parameter was null");
	boolean hasrow = ! rs.isAfterLast();
	if (! hasrow) { 
		return null; 
		} 
	alltypes bean = new alltypes();

	bean.set_id( rs.getInt(prefix+"_id") );
	bean.__orig_id = rs.getInt(prefix+"_id"); /* save original PK */
	if (rs.wasNull()) {
		bean.__isNullInDB_id = true;
		}
	bean.set_smallint_val( rs.getShort(prefix+"_smallint_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_smallint_val = true;
		}
	bean.set_int_val( rs.getInt(prefix+"_int_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_int_val = true;
		}
	bean.set_bigint_val( rs.getLong(prefix+"_bigint_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_bigint_val = true;
		}
	bean.set_float_val( rs.getFloat(prefix+"_float_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_float_val = true;
		}
	bean.set_double_val( rs.getDouble(prefix+"_double_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_double_val = true;
		}
	bean.set_numeric_val( rs.getBigDecimal(prefix+"_numeric_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_numeric_val = true;
		}
	bean.set_char_val( rs.getString(prefix+"_char_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_char_val = true;
		}
	bean.set_varchar_val( rs.getString(prefix+"_varchar_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_varchar_val = true;
		}
	bean.set_longvarchar_val( rs.getString(prefix+"_longvarchar_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_longvarchar_val = true;
		}
	bean.set_date_val( rs.getDate(prefix+"_date_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_date_val = true;
		}
	bean.set_time_val( rs.getTime(prefix+"_time_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_time_val = true;
		}
	bean.set_timestamp_val( rs.getTimestamp(prefix+"_timestamp_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_timestamp_val = true;
		}
	bean.set_bit_val( ((Boolean) rs.getObject(prefix+"_bit_val")) );
	if (rs.wasNull()) {
		bean.__isNullInDB_bit_val = true;
		}
	bean.set_array_val( rs.getArray(prefix+"_array_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_array_val = true;
		}
	bean.set_boolean_val( ((Boolean) rs.getObject(prefix+"_boolean_val")) );
	if (rs.wasNull()) {
		bean.__isNullInDB_boolean_val = true;
		}
	bean.set_varbinary_val( rs.getBytes(prefix+"_varbinary_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_varbinary_val = true;
		}
	bean.set_json_val( rs.getString(prefix+"_json_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_json_val = true;
		}
	bean.set_jsonb_val( rs.getString(prefix+"_jsonb_val") );
	if (rs.wasNull()) {
		bean.__isNullInDB_jsonb_val = true;
		}

 	/* set to true when instantiated new, false when we populate the bean from a resultset */
	bean.setNew(false);
	/* it's not modified, just loaded from the database */
	bean.resetModified();
	return bean;
	}

/** 
Creates and returns a new <tt>alltypes</tt> object that represents a row from the specified ResultSet. For this method
to work properly, the specified ResultSet should contain <b>all</b> (typically via <b>select *
</b>) of the column names of table.<tt>alltypes</tt>.
<p>
This method does not prepend the table name to columns when reading data from
the result set. It is useful when writing a JDBC query by hand that uses a single table
(no joins) and then converting the returned result set into objects of this
class. For example:
<p>
<code>select a, b, c, c*2 from foo where a = 1;</code>
<p>
This method will expect columns to be called <code><i>a, b, c</i></code> (no column aliases) in the returned
result set. In this example, there is only one table <code>foo</code> so qualifying the column
names, like <code>foo.a as foo_a</code> is not necessary). Also note, for this method to work properly, the 
column list<blockquote><code>select <i>a, b, c </i></code> ...</blockquote> should be complete, i.e., contain <i>at least</i> all the columns
of this table (<i>additional</i> expressions like c*2 are fine). It is slightly less efficient to retrieve all columns
especially for large tables but to construct a row into an object, we need all the fields. To be safe, use <blockquote><tt>select * ....</tt></blockquote>
<p>
Of course, if one needs a subset of columns, one can use the ResultSet directly and forego trying to
convert a ResultSet row into an corresponding object
<p>	
See {@link getFromRS(ResultSet)} which is more useful when writing a JDBC
query that uses multiple table joins.
<p>Note: This method will read the <i>current</i> row from the specified result set
and will <b>not</b> move the result set pointer to the next row after the current
row has been read. The result set should be appropriately positioned [via <tt>rs.next()</tt>]
<i>before</i> calling this method.

@return a new {@link alltypes} object populated with the contents of the next
		row from the result set or <tt> null </tt> if
		the ResultSet was empty.
*/
public static alltypes getFromRS1Table(final ResultSet rs) throws SQLException
	{
	__getfromrs_called++;
	Argcheck.notnull(rs, "the specified resultset parameter was null");
	boolean hasrow = ! rs.isAfterLast();
	if (! hasrow) { 
		return null; 
		} 
	alltypes bean = new alltypes();

	bean.set_id( rs.getInt(1) );
	bean.__orig_id = rs.getInt(1); /* save original PK */
	if (rs.wasNull()) {
		bean.__isNullInDB_id = true;
		}
	bean.set_smallint_val( rs.getShort(2) );
	if (rs.wasNull()) {
		bean.__isNullInDB_smallint_val = true;
		}
	bean.set_int_val( rs.getInt(3) );
	if (rs.wasNull()) {
		bean.__isNullInDB_int_val = true;
		}
	bean.set_bigint_val( rs.getLong(4) );
	if (rs.wasNull()) {
		bean.__isNullInDB_bigint_val = true;
		}
	bean.set_float_val( rs.getFloat(5) );
	if (rs.wasNull()) {
		bean.__isNullInDB_float_val = true;
		}
	bean.set_double_val( rs.getDouble(6) );
	if (rs.wasNull()) {
		bean.__isNullInDB_double_val = true;
		}
	bean.set_numeric_val( rs.getBigDecimal(7) );
	if (rs.wasNull()) {
		bean.__isNullInDB_numeric_val = true;
		}
	bean.set_char_val( rs.getString(8) );
	if (rs.wasNull()) {
		bean.__isNullInDB_char_val = true;
		}
	bean.set_varchar_val( rs.getString(9) );
	if (rs.wasNull()) {
		bean.__isNullInDB_varchar_val = true;
		}
	bean.set_longvarchar_val( rs.getString(10) );
	if (rs.wasNull()) {
		bean.__isNullInDB_longvarchar_val = true;
		}
	bean.set_date_val( rs.getDate(11) );
	if (rs.wasNull()) {
		bean.__isNullInDB_date_val = true;
		}
	bean.set_time_val( rs.getTime(12) );
	if (rs.wasNull()) {
		bean.__isNullInDB_time_val = true;
		}
	bean.set_timestamp_val( rs.getTimestamp(13) );
	if (rs.wasNull()) {
		bean.__isNullInDB_timestamp_val = true;
		}
	bean.set_bit_val( ((Boolean) rs.getObject(14)) );
	if (rs.wasNull()) {
		bean.__isNullInDB_bit_val = true;
		}
	bean.set_array_val( rs.getArray(15) );
	if (rs.wasNull()) {
		bean.__isNullInDB_array_val = true;
		}
	bean.set_boolean_val( ((Boolean) rs.getObject(16)) );
	if (rs.wasNull()) {
		bean.__isNullInDB_boolean_val = true;
		}
	bean.set_varbinary_val( rs.getBytes(17) );
	if (rs.wasNull()) {
		bean.__isNullInDB_varbinary_val = true;
		}
	bean.set_json_val( rs.getString(18) );
	if (rs.wasNull()) {
		bean.__isNullInDB_json_val = true;
		}
	bean.set_jsonb_val( rs.getString(19) );
	if (rs.wasNull()) {
		bean.__isNullInDB_jsonb_val = true;
		}

 	/* set to true when instantiated but this should be false
	 whenever we populate the bean from a result set */
	bean.setNew(false);
	//it's not modified, just loaded from the database
	bean.resetModified();
	return bean;
	}

private static alltypes decodeFromRS(final ResultSet rs) throws SQLException
	{
	Argcheck.notnull(rs, "the specified resultset parameter was null");
	boolean hasrow = rs.next();
	if (! hasrow) { 
		return null; 
		} 
	alltypes bean = new alltypes();

	bean.set_id( rs.getInt(1) );
	bean.__orig_id = rs.getInt(1); /* save original PK */
	if (rs.wasNull()) {
		bean.__isNullInDB_id = true;
		}

	bean.set_smallint_val( rs.getShort(2) );
	if (rs.wasNull()) {
		bean.__isNullInDB_smallint_val = true;
		}

	bean.set_int_val( rs.getInt(3) );
	if (rs.wasNull()) {
		bean.__isNullInDB_int_val = true;
		}

	bean.set_bigint_val( rs.getLong(4) );
	if (rs.wasNull()) {
		bean.__isNullInDB_bigint_val = true;
		}

	bean.set_float_val( rs.getFloat(5) );
	if (rs.wasNull()) {
		bean.__isNullInDB_float_val = true;
		}

	bean.set_double_val( rs.getDouble(6) );
	if (rs.wasNull()) {
		bean.__isNullInDB_double_val = true;
		}

	bean.set_numeric_val( rs.getBigDecimal(7) );
	if (rs.wasNull()) {
		bean.__isNullInDB_numeric_val = true;
		}

	bean.set_char_val( rs.getString(8) );
	if (rs.wasNull()) {
		bean.__isNullInDB_char_val = true;
		}

	bean.set_varchar_val( rs.getString(9) );
	if (rs.wasNull()) {
		bean.__isNullInDB_varchar_val = true;
		}

	bean.set_longvarchar_val( rs.getString(10) );
	if (rs.wasNull()) {
		bean.__isNullInDB_longvarchar_val = true;
		}

	bean.set_date_val( rs.getDate(11) );
	if (rs.wasNull()) {
		bean.__isNullInDB_date_val = true;
		}

	bean.set_time_val( rs.getTime(12) );
	if (rs.wasNull()) {
		bean.__isNullInDB_time_val = true;
		}

	bean.set_timestamp_val( rs.getTimestamp(13) );
	if (rs.wasNull()) {
		bean.__isNullInDB_timestamp_val = true;
		}

	bean.set_bit_val( ((Boolean) rs.getObject(14)) );
	if (rs.wasNull()) {
		bean.__isNullInDB_bit_val = true;
		}

	bean.set_array_val( rs.getArray(15) );
	if (rs.wasNull()) {
		bean.__isNullInDB_array_val = true;
		}

	bean.set_boolean_val( ((Boolean) rs.getObject(16)) );
	if (rs.wasNull()) {
		bean.__isNullInDB_boolean_val = true;
		}

	bean.set_varbinary_val( rs.getBytes(17) );
	if (rs.wasNull()) {
		bean.__isNullInDB_varbinary_val = true;
		}

	bean.set_json_val( rs.getString(18) );
	if (rs.wasNull()) {
		bean.__isNullInDB_json_val = true;
		}

	bean.set_jsonb_val( rs.getString(19) );
	if (rs.wasNull()) {
		bean.__isNullInDB_jsonb_val = true;
		}


 	/* set to true when newly instantiated but this should be false
	 whenever we populate the bean from a result set */
	bean.setNew(false);
	//it's not modified, just loaded from the database
	bean.resetModified();
	return bean;
	}

/**
Saves the specified object into the database. If the specified
object was newly created, then it is <span style="font-variant:
small-caps">insert</span>'ed into the database, else (if it was retrieved
earlier from the database) it is <span 
style="font-variant: small-caps">update</span>'ed. (this can be
overriden by the {@link #update update} method). If the object is
inserted as a new row, then after insertion, the values of
serial/auto-incremented columns will be automatically available via the
appropriate getXXX() methods on that object.
<p>
<b>NOTE 1:</b> When saving an object, only modified fields are
saved. Do not rely on default field values (such as null) of newly
created objects; instead explicitly set the value (including to null
if needed) of any field that should be saved to the database.
<p>
<b>NOTE 2:</b> Once an object is successfully saved, it is discarded
and cannot be saved again and any attempt to save it again will
result in a runtime exception. Objects that need to be modified
again must be re-instantiated or re-populated from the database
before they can be saved again. (the serial/auto-increment data will still be
available, discarding only affects the ability to save the object
again).
<p>
<b>Note 3:</b> <font color='red'>For various reasons/flexiblity, default database values
for columns <i>other</i> than serial columns are <b>not</b> available
in the saved object. To get these values, retrieve the saved object again. (this is what
we would have to do internally anyway). This is relevant, for example, when a column has
a default value of a now() timestamp, and we need to get that timestamp after the object
has been saved</font>

@return 	the number of rows inserted or updated (typically useful 
			to see if an update succeeded)
@throws	ValidateException 	on a validation error
@throws SQLException		on some SQL/Database error
@throws IOException			by the available() method if/when
							setting a stream for longvar/text types
*/
public static int save(final Connection con, final alltypes bean) throws ValidateException, SQLException, IOException
	{
	__save_called++;
	Argcheck.notnull(bean, "the specified bean parameter was null");
	checkDiscarded(bean);
	if (! bean.isModified()) { 
		log.warn("bean=", bean, " not modified, IGNORING SAVE\n====DEBUG STACK TRACE====\n", IOUtil.throwableToString(new Exception()));
		return 0;
		}
	PreparedStatement ps = null;

	boolean inserting_a_row = false;
	if (bean.isNew() && ! bean.__force_update) 
		{  //insert new row
		validateBeforeSaveNew(bean);
		int __count = 0;
		inserting_a_row = true;
		final StringBuilder buf = new StringBuilder(512);
		buf.append("INSERT into alltypes (");
		if (bean.isModified_smallint_val()) { 
			buf.append("smallint_val").append(", ");
			__count++;
			}
		if (bean.isModified_int_val()) { 
			buf.append("int_val").append(", ");
			__count++;
			}
		if (bean.isModified_bigint_val()) { 
			buf.append("bigint_val").append(", ");
			__count++;
			}
		if (bean.isModified_float_val()) { 
			buf.append("float_val").append(", ");
			__count++;
			}
		if (bean.isModified_double_val()) { 
			buf.append("double_val").append(", ");
			__count++;
			}
		if (bean.isModified_numeric_val()) { 
			buf.append("numeric_val").append(", ");
			__count++;
			}
		if (bean.isModified_char_val()) { 
			buf.append("char_val").append(", ");
			__count++;
			}
		if (bean.isModified_varchar_val()) { 
			buf.append("varchar_val").append(", ");
			__count++;
			}
		if (bean.isModified_longvarchar_val()) { 
			buf.append("longvarchar_val").append(", ");
			__count++;
			}
		if (bean.isModified_date_val()) { 
			buf.append("date_val").append(", ");
			__count++;
			}
		if (bean.isModified_time_val()) { 
			buf.append("time_val").append(", ");
			__count++;
			}
		if (bean.isModified_timestamp_val()) { 
			buf.append("timestamp_val").append(", ");
			__count++;
			}
		if (bean.isModified_bit_val()) { 
			buf.append("bit_val").append(", ");
			__count++;
			}
		if (bean.isModified_array_val()) { 
			buf.append("array_val").append(", ");
			__count++;
			}
		if (bean.isModified_boolean_val()) { 
			buf.append("boolean_val").append(", ");
			__count++;
			}
		if (bean.isModified_varbinary_val()) { 
			buf.append("varbinary_val").append(", ");
			__count++;
			}
		if (bean.isModified_json_val()) { 
			buf.append("json_val").append(", ");
			__count++;
			}
		if (bean.isModified_jsonb_val()) { 
			buf.append("jsonb_val").append(", ");
			__count++;
			}

		if (__count == 0) {
			throw new ValidateException("Cannot save this bean because no column has been modified. Use JDBC directly as needed.\n");
		}
		buf.setLength(buf.length() - 2);
 		buf.append(") values (");
		for (int n = 0; n < __count; n++) { 
			buf.append("?");
			if ((n+1) < __count)
				buf.append(", ");
			}
		buf.append(")");

		final String insertByPKStmt = buf.toString();
		ps = prepareStatement(con, insertByPKStmt);
		/* Insert any changed values into our prepared statement */
		int pos = 0;
		if (bean.isModified_smallint_val()) {
			pos++;
			if (bean.isModifiedSetNull_smallint_val()) { /* nullable in db */
				ps.setNull(pos,5)/*SMALLINT*/;
				}
			else{
				short smallint_val = bean.get_smallint_val();
				ps.setShort(pos, smallint_val); 
				}
			}
		if (bean.isModified_int_val()) {
			pos++;
			int int_val = bean.get_int_val();
			ps.setInt(pos, int_val); 
			}
		if (bean.isModified_bigint_val()) {
			pos++;
			if (bean.isModifiedSetNull_bigint_val()) { /* nullable in db */
				ps.setNull(pos,-5)/*BIGINT*/;
				}
			else{
				long bigint_val = bean.get_bigint_val();
				ps.setLong(pos, bigint_val); 
				}
			}
		if (bean.isModified_float_val()) {
			pos++;
			if (bean.isModifiedSetNull_float_val()) { /* nullable in db */
				ps.setNull(pos,7)/*REAL*/;
				}
			else{
				float float_val = bean.get_float_val();
				ps.setFloat(pos, float_val); 
				}
			}
		if (bean.isModified_double_val()) {
			pos++;
			if (bean.isModifiedSetNull_double_val()) { /* nullable in db */
				ps.setNull(pos,8)/*DOUBLE*/;
				}
			else{
				double double_val = bean.get_double_val();
				ps.setDouble(pos, double_val); 
				}
			}
		if (bean.isModified_numeric_val()) {
			pos++;
			BigDecimal numeric_val = bean.get_numeric_val();
			ps.setBigDecimal(pos, numeric_val); 
			}
		if (bean.isModified_char_val()) {
			pos++;
			String char_val = bean.get_char_val();
			ps.setString(pos, char_val); 
			}
		if (bean.isModified_varchar_val()) {
			pos++;
			String varchar_val = bean.get_varchar_val();
			ps.setString(pos, varchar_val); 
			}
		if (bean.isModified_longvarchar_val()) {
			pos++;
			String longvarchar_val = bean.get_longvarchar_val();
			ps.setString(pos, longvarchar_val); 
			}
		if (bean.isModified_date_val()) {
			pos++;
			java.sql.Date date_val = bean.get_date_val();
			ps.setDate(pos, date_val); 
			}
		if (bean.isModified_time_val()) {
			pos++;
			Time time_val = bean.get_time_val();
			ps.setTime(pos, time_val); 
			}
		if (bean.isModified_timestamp_val()) {
			pos++;
			Timestamp timestamp_val = bean.get_timestamp_val();
			ps.setTimestamp(pos, timestamp_val); 
			}
		if (bean.isModified_bit_val()) {
			pos++;
			Boolean bit_val = bean.get_bit_val();
			ps.setObject(pos, bit_val); 
			}
		if (bean.isModified_array_val()) {
			pos++;
			java.sql.Array array_val = bean.get_array_val();
			ps.setArray(pos, array_val); 
			}
		if (bean.isModified_boolean_val()) {
			pos++;
			Boolean boolean_val = bean.get_boolean_val();
			ps.setObject(pos, boolean_val); 
			}
		if (bean.isModified_varbinary_val()) {
			pos++;
			byte[] varbinary_val = bean.get_varbinary_val();
			ps.setBytes(pos, varbinary_val); 
			}
		if (bean.isModified_json_val()) {
			pos++;
			String json_val = bean.get_json_val();
			ps.setObject(pos, json_val, java.sql.Types.OTHER); 
			}
		if (bean.isModified_jsonb_val()) {
			pos++;
			String jsonb_val = bean.get_jsonb_val();
			ps.setObject(pos, jsonb_val, java.sql.Types.OTHER); 
			}
		}
	else //update existing row 
		{
		validateBeforeSaveUpdate(bean);
		int __count = 0;
		final StringBuilder buf = new StringBuilder(512);
		buf.append("UPDATE ");
		buf.append("alltypes");
		buf.append(" SET ");
		if (bean.isModified_smallint_val()) { 
			buf.append("smallint_val=?, ");
			__count++;
			}
		if (bean.isModified_int_val()) { 
			buf.append("int_val=?, ");
			__count++;
			}
		if (bean.isModified_bigint_val()) { 
			buf.append("bigint_val=?, ");
			__count++;
			}
		if (bean.isModified_float_val()) { 
			buf.append("float_val=?, ");
			__count++;
			}
		if (bean.isModified_double_val()) { 
			buf.append("double_val=?, ");
			__count++;
			}
		if (bean.isModified_numeric_val()) { 
			buf.append("numeric_val=?, ");
			__count++;
			}
		if (bean.isModified_char_val()) { 
			buf.append("char_val=?, ");
			__count++;
			}
		if (bean.isModified_varchar_val()) { 
			buf.append("varchar_val=?, ");
			__count++;
			}
		if (bean.isModified_longvarchar_val()) { 
			buf.append("longvarchar_val=?, ");
			__count++;
			}
		if (bean.isModified_date_val()) { 
			buf.append("date_val=?, ");
			__count++;
			}
		if (bean.isModified_time_val()) { 
			buf.append("time_val=?, ");
			__count++;
			}
		if (bean.isModified_timestamp_val()) { 
			buf.append("timestamp_val=?, ");
			__count++;
			}
		if (bean.isModified_bit_val()) { 
			buf.append("bit_val=?, ");
			__count++;
			}
		if (bean.isModified_array_val()) { 
			buf.append("array_val=?, ");
			__count++;
			}
		if (bean.isModified_boolean_val()) { 
			buf.append("boolean_val=?, ");
			__count++;
			}
		if (bean.isModified_varbinary_val()) { 
			buf.append("varbinary_val=?, ");
			__count++;
			}
		if (bean.isModified_json_val()) { 
			buf.append("json_val=?, ");
			__count++;
			}
		if (bean.isModified_jsonb_val()) { 
			buf.append("jsonb_val=?, ");
			__count++;
			}

		if (__count == 0) {
			throw new ValidateException("Cannot save this bean because no column has been modified. Use JDBC directly as needed.\n");
		}
		buf.setLength(buf.length() - 2);
		buf.append(" WHERE ");
		buf.append("id=?");
		ps = con.prepareStatement(buf.toString());

		/* Insert any changed values into our prepared statement */
		int pos = 0;
		if (bean.isModified_smallint_val()) {
			pos++;
			if (bean.isModifiedSetNull_smallint_val()) { /* nullable in db */
				ps.setNull(pos,5)/*SMALLINT*/;
				}
			else{
				short smallint_val = bean.get_smallint_val();
				ps.setShort(pos, smallint_val); 
				}
			}
		if (bean.isModified_int_val()) {
			pos++;
			int int_val = bean.get_int_val();
			ps.setInt(pos, int_val); 
			}
		if (bean.isModified_bigint_val()) {
			pos++;
			if (bean.isModifiedSetNull_bigint_val()) { /* nullable in db */
				ps.setNull(pos,-5)/*BIGINT*/;
				}
			else{
				long bigint_val = bean.get_bigint_val();
				ps.setLong(pos, bigint_val); 
				}
			}
		if (bean.isModified_float_val()) {
			pos++;
			if (bean.isModifiedSetNull_float_val()) { /* nullable in db */
				ps.setNull(pos,7)/*REAL*/;
				}
			else{
				float float_val = bean.get_float_val();
				ps.setFloat(pos, float_val); 
				}
			}
		if (bean.isModified_double_val()) {
			pos++;
			if (bean.isModifiedSetNull_double_val()) { /* nullable in db */
				ps.setNull(pos,8)/*DOUBLE*/;
				}
			else{
				double double_val = bean.get_double_val();
				ps.setDouble(pos, double_val); 
				}
			}
		if (bean.isModified_numeric_val()) {
			pos++;
			BigDecimal numeric_val = bean.get_numeric_val();
			ps.setBigDecimal(pos, numeric_val); 
			}
		if (bean.isModified_char_val()) {
			pos++;
			String char_val = bean.get_char_val();
			ps.setString(pos, char_val); 
			}
		if (bean.isModified_varchar_val()) {
			pos++;
			String varchar_val = bean.get_varchar_val();
			ps.setString(pos, varchar_val); 
			}
		if (bean.isModified_longvarchar_val()) {
			pos++;
			String longvarchar_val = bean.get_longvarchar_val();
			ps.setString(pos, longvarchar_val); 
			}
		if (bean.isModified_date_val()) {
			pos++;
			java.sql.Date date_val = bean.get_date_val();
			ps.setDate(pos, date_val); 
			}
		if (bean.isModified_time_val()) {
			pos++;
			Time time_val = bean.get_time_val();
			ps.setTime(pos, time_val); 
			}
		if (bean.isModified_timestamp_val()) {
			pos++;
			Timestamp timestamp_val = bean.get_timestamp_val();
			ps.setTimestamp(pos, timestamp_val); 
			}
		if (bean.isModified_bit_val()) {
			pos++;
			Boolean bit_val = bean.get_bit_val();
			ps.setObject(pos, bit_val); 
			}
		if (bean.isModified_array_val()) {
			pos++;
			java.sql.Array array_val = bean.get_array_val();
			ps.setArray(pos, array_val); 
			}
		if (bean.isModified_boolean_val()) {
			pos++;
			Boolean boolean_val = bean.get_boolean_val();
			ps.setObject(pos, boolean_val); 
			}
		if (bean.isModified_varbinary_val()) {
			pos++;
			byte[] varbinary_val = bean.get_varbinary_val();
			ps.setBytes(pos, varbinary_val); 
			}
		if (bean.isModified_json_val()) {
			pos++;
			String json_val = bean.get_json_val();
			ps.setObject(pos, json_val, java.sql.Types.OTHER); 
			}
		if (bean.isModified_jsonb_val()) {
			pos++;
			String jsonb_val = bean.get_jsonb_val();
			ps.setObject(pos, jsonb_val, java.sql.Types.OTHER); 
			}

		/* Set primary keys for the WHERE part of our prepared statement */
		int id = (bean.__force_update) ? bean.get_id() : bean.__orig_id;
		ps.setInt(++pos, id); 
		} //~else update;

	log.bug("Query to run: ", ps);
	int result = ps.executeUpdate();
	if (inserting_a_row) { //get auto increment info
		/* Retrieve values from auto-increment columns */
		ResultSet rs = null; Statement stmt = null;
		String query = null;
		boolean found = false;

		if (bean.isModified_id()) { 
			//column: id
			//not getting auto increment value for this column
			//since not using auto increment, a value was specified manually
			}
		else{
			stmt = con.createStatement();
			query = "select currval('alltypes_id_seq')";
			rs = stmt.executeQuery(query);
			found = rs.next();
			if (! found) throw new SQLException("No last inserted id returned");
			bean.set_id( rs.getInt(1));
			if (rs.wasNull()) {
				bean.__isNullInDB_id = true;
				}
			rs.close();
			}
		}

	//discard after saving/updating for safety
	bean.discard();
	return result;
	}

/**
Uses the specified object to update existing data in the database.
<p>
Note, the {@link #save save} method automatically saves newly created objects
as <i>inserts</i> in the database (and prior <i>retrieved</i> objects, when
subsequently modified, are saved as <i>updates</i>).
<p>
However, sometimes it is useful to create a <i>new</i> object and then
use its data to <i>update</i> an existing row in the database.
This method need <b>only</b> be called to save a <u>newly</u>
created object as an <u>update</u> into the database (overriding the
default action of saving new objects as inserts in the database).
<p>
Note, also, a bean can only be updated if the corresponding table it has
at least one primary key defined. To update tables with no primary keys,
use JDBC directly.
<p>
This method takes primary key(s) of {@link alltypes} as additional arguments and sets those in the
specified bean before updating the database (this way the row to update
can be uniquely identified).

@see #save

@return 	the number of rows that were updated (typically useful 
			to see if an update succeeded)
@throws	ValidateException 	on a validation error
@throws SQLException		on some SQL/Database error
*/
public static int update(final Connection con, final alltypes bean, int id) throws ValidateException, SQLException, IOException
	{
	bean.set_id(id);

	if (bean.isNew()) { /* force update (and not insert) for new bean */
		bean.__force_update = true;
		}
	return save(con, bean);
	}

static private final String deleteStmt = "DELETE  from alltypes WHERE id=?";
/** 
Deletes this object from the database. <p>
<b>NOTE 1:</b> Only objects that were retrieved from the database can be deleted. Newly
created objects cannot be deleted since they do not yet exist in the database.
Use {@link #deleteByKey deleteByKey} or {@link #deleteWhere deleteWhere} instead
for arbitrary deletions. <p><b>NOTE 2:</b> Once an object is successfully
deleted, it is discarded and cannot be deleted again and any attempt to delete
it again will result in a runtime Exception.
*/
public static void delete(final Connection con, alltypes bean) throws SQLException
	{
	__delete_called++;
	if (bean.isNew()) {
		throw new DBOException("Cannot delete new objects using this method. Use deleteByKey() or deleteWhere() instead");
		}
	checkDiscarded(bean);
	final PreparedStatement ps = prepareStatement(con, deleteStmt);
	int id = bean.get_id();
	ps.setInt(1, id); 
	log.bug("Query to run: ", ps);
	final int result = ps.executeUpdate();
	if (result != 1) { 
		throw new DBOException("The number of deleted rows was: " + result + "; [Should have been 1 row exactly] ");
		}
	}

static private final String deleteByPKStmt = "DELETE  from alltypes WHERE id=?";
/** 
Deletes the rows with the specified primary key(s) from the database. <p>This method uses a prepared statement and is safe from SQL injection attacks
*/
public static void deleteByKey(final Connection con, int id) throws SQLException
	{
	__deletebykey_called++;
	PreparedStatement ps = prepareStatement(con, deleteByPKStmt);
	ps.setInt(1, id); 
	log.bug("Query to run: ", ps);
	final int result = ps.executeUpdate();
	if (result != 1) { 
		throw new DBOException("The number of deleted rows was: " + result + "; [Should have been 1 row exactly] ");
		}
	}

/** 
Returns the rows returned by querying the table with the contents of
the specified instance of <tt>alltypes</tt> or <tt>null</tt> if no
rows were found. As many fields in <tt>alltypes</tt> can be set as
needed and the values of all set fields (including fields explicitly
set to <tt>null</tt>) are then used to perform the query. <p>Note,
however that this method does use any primary key(s). If the 
primary keys are known then one should use the {@link
#deleteByKey deleteByKey} method to delete the data instead.
<p>Likewise, to delete a previously fetched row, use the {@link 
#delete delete} method. This method is really meant to create an new
object, set various fields in it, and then use that to delete matching
row(s) from the database in a type safe way.
<p>
This method is often convenient/safer than the {@link #deleteWhere
deleteWhere} method (because the <tt>deleteWhere</tt> method takes
an arbitrary query string which has to be properly escaped by the user).

<p>However, as a middle ground, this method also takes an <tt>clause</tt> parameter which
is sent as is to the database. For example, a clause can be:
<blockquote><pre>
List beans = table_fooMgr.<font color=blue>deleteUsing(proto, <b>"xyx > 5"</b>)</font>;
</pre> </blockquote>
This clause is optional. Specify <tt>null</tt> to not use it at all.
If the clause is specified, do <font size='+1'><b>NOT</b></font> include the word <tt>WHERE</tt>.

<p>Essentially, this method is a more convenient way to use a
PreparedStatement. Internally, a prepared statement is created and
it's parameters are set to fields that are set in this object).
Using PreparedStatements directly is also perfectly fine. For
example, the following are equivalent. 
<p> Using a PreparedStatement:
<blockquote><pre>
String foo = "delete from table_foo where x = ? and y = ?";
PreparedStatement ps = con.prepareStatement(foo);
ps.setString(1, "somevalue");
ps.setString(2, "othervalue");
int rows_deleted = ps.executeUpdate();
</pre> </blockquote>	

Using this method:
<blockquote><pre>
table_foo proto = new table_foo();
proto.set_x("somevalue");	//compile time safety
proto.set_y("othervalue");	//compile time safety
int rows_deleted = table_fooMgr.<font color=blue>deleteUsing</font>(proto);
</pre></blockquote>
@return		the number of rows deleted
*/
public static int deleteUsing(final Connection con, final alltypes bean, final String clause) throws ValidateException, SQLException
	{
	__deleteusing_called++;

	Argcheck.notnull(bean, "the bean parameter was null (and should not be null)");
	if (! bean.isModified()) { 
		throw new ValidateException("bean=" + bean + " not modified, ignoring query");
		}

	final StringBuilder buf = new StringBuilder(512);
	buf.append("DELETE  from alltypes WHERE ");

	int __count = 0;
	if (bean.isModified_smallint_val()) { 
		if (bean.isModifiedSetNull_smallint_val()) {
			buf.append("smallint_val is NULL and ");
			}
		else{
			buf.append("smallint_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_int_val()) { 
		buf.append("int_val=? and ");
		__count++;
		}
	if (bean.isModified_bigint_val()) { 
		if (bean.isModifiedSetNull_bigint_val()) {
			buf.append("bigint_val is NULL and ");
			}
		else{
			buf.append("bigint_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_float_val()) { 
		if (bean.isModifiedSetNull_float_val()) {
			buf.append("float_val is NULL and ");
			}
		else{
			buf.append("float_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_double_val()) { 
		if (bean.isModifiedSetNull_double_val()) {
			buf.append("double_val is NULL and ");
			}
		else{
			buf.append("double_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_numeric_val()) { 
		if (bean.get_numeric_val() == null) {
			buf.append("numeric_val is NULL and ");
			}
		else{
			buf.append("numeric_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_char_val()) { 
		if (bean.get_char_val() == null) {
			buf.append("char_val is NULL and ");
			}
		else{
			buf.append("char_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_varchar_val()) { 
		if (bean.get_varchar_val() == null) {
			buf.append("varchar_val is NULL and ");
			}
		else{
			buf.append("varchar_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_longvarchar_val()) { 
		if (bean.get_longvarchar_val() == null) {
			buf.append("longvarchar_val is NULL and ");
			}
		else{
			buf.append("longvarchar_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_date_val()) { 
		if (bean.get_date_val() == null) {
			buf.append("date_val is NULL and ");
			}
		else{
			buf.append("date_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_time_val()) { 
		if (bean.get_time_val() == null) {
			buf.append("time_val is NULL and ");
			}
		else{
			buf.append("time_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_timestamp_val()) { 
		if (bean.get_timestamp_val() == null) {
			buf.append("timestamp_val is NULL and ");
			}
		else{
			buf.append("timestamp_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_bit_val()) { 
		if (bean.get_bit_val() == null) {
			buf.append("bit_val is NULL and ");
			}
		else{
			buf.append("bit_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_array_val()) { 
		if (bean.get_array_val() == null) {
			buf.append("array_val is NULL and ");
			}
		else{
			buf.append("array_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_boolean_val()) { 
		if (bean.get_boolean_val() == null) {
			buf.append("boolean_val is NULL and ");
			}
		else{
			buf.append("boolean_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_varbinary_val()) { 
		if (bean.get_varbinary_val() == null) {
			buf.append("varbinary_val is NULL and ");
			}
		else{
			buf.append("varbinary_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_json_val()) { 
		if (bean.get_json_val() == null) {
			buf.append("json_val is NULL and ");
			}
		else{
			buf.append("json_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_jsonb_val()) { 
		if (bean.get_jsonb_val() == null) {
			buf.append("jsonb_val is NULL and ");
			}
		else{
			buf.append("jsonb_val=? and ");
			__count++;
			}
		}
	buf.setLength(buf.length() - 4);
	if (__count == 0) {
		throw new ValidateException("No non-PrimaryKey column was modified/set in this bean. You must set at least one such column. To delete by the Primary key, use the deleteByKey method instead.");
		}
	if (clause != null) {
		buf.append(" ");
		buf.append(clause);
		}

	final String getUsingPKStmt = buf.toString();
	PreparedStatement ps = prepareStatement(con, getUsingPKStmt);
	int pos = 0;
	if (bean.isModified_smallint_val()) {
		if (bean.isModifiedSetNull_smallint_val()) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			short smallint_val = bean.get_smallint_val();
			ps.setShort(pos, smallint_val); 
			}
		}
	if (bean.isModified_int_val()) {
			pos++;
			int int_val = bean.get_int_val();
			ps.setInt(pos, int_val); 
			}
	if (bean.isModified_bigint_val()) {
		if (bean.isModifiedSetNull_bigint_val()) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			long bigint_val = bean.get_bigint_val();
			ps.setLong(pos, bigint_val); 
			}
		}
	if (bean.isModified_float_val()) {
		if (bean.isModifiedSetNull_float_val()) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			float float_val = bean.get_float_val();
			ps.setFloat(pos, float_val); 
			}
		}
	if (bean.isModified_double_val()) {
		if (bean.isModifiedSetNull_double_val()) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			double double_val = bean.get_double_val();
			ps.setDouble(pos, double_val); 
			}
		}
	if (bean.isModified_numeric_val()) {
		if (bean.get_numeric_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			BigDecimal numeric_val = bean.get_numeric_val();
			ps.setBigDecimal(pos, numeric_val); 
			}
		}
	if (bean.isModified_char_val()) {
		if (bean.get_char_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			String char_val = bean.get_char_val();
			ps.setString(pos, char_val); 
			}
		}
	if (bean.isModified_varchar_val()) {
		if (bean.get_varchar_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			String varchar_val = bean.get_varchar_val();
			ps.setString(pos, varchar_val); 
			}
		}
	if (bean.isModified_longvarchar_val()) {
		if (bean.get_longvarchar_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			String longvarchar_val = bean.get_longvarchar_val();
			ps.setString(pos, longvarchar_val); 
			}
		}
	if (bean.isModified_date_val()) {
		if (bean.get_date_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			java.sql.Date date_val = bean.get_date_val();
			ps.setDate(pos, date_val); 
			}
		}
	if (bean.isModified_time_val()) {
		if (bean.get_time_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			Time time_val = bean.get_time_val();
			ps.setTime(pos, time_val); 
			}
		}
	if (bean.isModified_timestamp_val()) {
		if (bean.get_timestamp_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			Timestamp timestamp_val = bean.get_timestamp_val();
			ps.setTimestamp(pos, timestamp_val); 
			}
		}
	if (bean.isModified_bit_val()) {
		if (bean.get_bit_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			Boolean bit_val = bean.get_bit_val();
			ps.setObject(pos, bit_val); 
			}
		}
	if (bean.isModified_array_val()) {
		if (bean.get_array_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			java.sql.Array array_val = bean.get_array_val();
			ps.setArray(pos, array_val); 
			}
		}
	if (bean.isModified_boolean_val()) {
		if (bean.get_boolean_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			Boolean boolean_val = bean.get_boolean_val();
			ps.setObject(pos, boolean_val); 
			}
		}
	if (bean.isModified_varbinary_val()) {
		if (bean.get_varbinary_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			byte[] varbinary_val = bean.get_varbinary_val();
			ps.setBytes(pos, varbinary_val); 
			}
		}
	if (bean.isModified_json_val()) {
		if (bean.get_json_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			String json_val = bean.get_json_val();
			ps.setObject(pos, json_val, java.sql.Types.OTHER); 
			}
		}
	if (bean.isModified_jsonb_val()) {
		if (bean.get_jsonb_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			String jsonb_val = bean.get_jsonb_val();
			ps.setObject(pos, jsonb_val, java.sql.Types.OTHER); 
			}
		}
	log.bug("Query to run: ", ps);
	List list = new ArrayList();
	int result = ps.executeUpdate();
	return result;
	}

/** 
Convenience method that invokes {@link getUsing(Connection, alltypes, String) getUsing} with an empty <i><tt>clause</tt></i> parameter.*/
public static int deleteUsing(final Connection con, final alltypes bean) throws ValidateException, SQLException
	{
	return deleteUsing(con, bean, null);
	}

/** 
Deletes the rows with the specified where clause. <p><b>The
where clause is sent as-is to the database and SQL injection
attacks are possible if it is created as-is from a untrusted
source.</b>
(note: the string <tt>"WHERE"</tt> does <b>not</b> have to be
specified in the clause. It is added automatically by this method).

@return the number of rows deleted by the database
*/
public static int deleteWhere(final Connection con, final String where) throws SQLException	{
	__deletewhere_called++;
	Argcheck.notnull(where, "the where parameter was null (and should not be null)");
	final String stmt_string = "DELETE from alltypes WHERE " + where ;
	Statement stmt = con.createStatement();
	log.bug("Query to run: ", stmt_string);
	final int result = stmt.executeUpdate(stmt_string);
	return result;
}

private final static String countStmt = "SELECT count(*) from alltypes";
/**
Returns the count of all rows in the table. <p><b>Note</b>: This may
be an expensive operation in MVCC databases like PostgresQL, Oracle and
others, where an entire non-optimized table scan <i>may</i> be
required -- hence speed will typically be O(n). However, on Postgres (for
example), this is still very fast for small values of n (on a
mid-level test machine) as of 2004, counting 4k records was about
15 milli-seconds(ms); this scaled almost linearly, so count(*) for 16k records was
about 70 ms, 65k records was about 370 ms, 524k records was about
2000 ms and 1 million records was about 4000 ms. Results will vary
on your machine and database but the general O(n) principle will
remain the same.
*/
public static int count(final Connection con) throws SQLException
	{
	__count_called++;
  	int __count = -1;
	final Statement stmt = con.createStatement();
    final ResultSet rs = stmt.executeQuery(countStmt);
    if (rs.next())
    	{
      	__count = rs.getInt(1);
    	}
	else { //rs returned no count, which should never happen
		throw new DBOException("The COUNT query [" + countStmt + "] returned no rows. [Should have returned 1 row exactly] ");
		}
	stmt.close();
	return __count;
	}

/**
Returns the count of rows in the table using the specified <tt>where</tt> clause.
(note: the string <tt>"WHERE"</tt> does <b>not</b> have to be
specified in the clause. It is added automatically by this method).

@throws 	IllegalArgumentException 	if the where paramater was null
*/
public static int countWhere(final Connection con, final String where) throws SQLException
	{
	__countwhere_called++;
	Argcheck.notnull(where, "the where parameter was null");
  	int __count = -1;
	final String countWhereStmt = "SELECT count(*) from alltypes WHERE " + where;
	Statement stmt = con.createStatement();
	log.bug("Query to run: ", stmt, " ", countWhereStmt);
    ResultSet rs = stmt.executeQuery(countWhereStmt);
    if (rs.next())
    	{
      	__count = rs.getInt(1);
    	}
	else { //rs returned no count, which should never happen
		throw new DBOException("The COUNT query [" + countWhereStmt + "] returned no rows. [Should have returned 1 row exactly] ");
		}
	stmt.close();
	return __count;
	}

/** 
Returns the rows count by querying the table with the contents of the
specified instance of <tt>alltypes</tt> As many fields in <tt>alltypes</tt> can be set as needed and the
values of all set fields (including fields explicitly set to
<tt>null</tt>) are then used to perform the query. If the primary
key(s) are known then one can also use the {@link #exists} method to
see if that row exists in the database.
<p>
This method is often convenient/safer than the {@link #countWhere
countWhere} method (because the <tt>countWhere</tt> method takes an
arbitrary query string which has to be properly escaped by the
user). 
<p>Essentially, this method is a more convenient way to use a
PreparedStatement (with parameters set to fields that are set in
this object). Using PreparedStatements directly is also perfectly
fine. For example, the following two are equivalent. <p>
Using a PreparedStatement:
<blockquote><pre>
String foo = "select <i>count(*)</i> from table_foo where x = ? and y = ?";
PreparedStatement ps = con.prepareStatement(foo);
ps.setString(1, "somevalue");
ps.setString(2, "othervalue");
ResultSet rs  = ps.executeUpdate();
rs.next();
int count = rs.getInt(1);
</pre> </blockquote>

Using this method:
<blockquote><pre>
table_foo proto = new table_foo();
proto.set_x("somevalue");	//compile time safety
proto.set_y("othervalue");	//compile time safety
int count = table_fooMgr.<font color=blue>countUsing</font>(proto);
</pre> </blockquote>
The clause is optional. Specify <tt>null</tt> to not use it at all.
If the clause is specified, do <font size='+1'><b>NOT</b></font> include the word <tt>WHERE</tt>.
*/
public static int countUsing(final Connection con, final alltypes bean, final String clause) throws ValidateException, SQLException
	{
	__countusing_called++;
	Argcheck.notnull(bean, "the bean parameter was null (and should not be null)");	if (! bean.isModified()) { 
		throw new ValidateException("bean=" + bean + " not modified, ignoring query");
		}

	int __count = 0;
	final StringBuilder buf = new StringBuilder(512);
	buf.append("SELECT count(*)  from alltypes WHERE ");
	if (bean.isModified_id()) { 
		buf.append("id=? and ");
		__count++;
		}
	if (bean.isModified_smallint_val()) { 
		if (bean.isModifiedSetNull_smallint_val()) {
			buf.append("smallint_val is NULL and ");
			}
		else{
			buf.append("smallint_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_int_val()) { 
		buf.append("int_val=? and ");
		__count++;
		}
	if (bean.isModified_bigint_val()) { 
		if (bean.isModifiedSetNull_bigint_val()) {
			buf.append("bigint_val is NULL and ");
			}
		else{
			buf.append("bigint_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_float_val()) { 
		if (bean.isModifiedSetNull_float_val()) {
			buf.append("float_val is NULL and ");
			}
		else{
			buf.append("float_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_double_val()) { 
		if (bean.isModifiedSetNull_double_val()) {
			buf.append("double_val is NULL and ");
			}
		else{
			buf.append("double_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_numeric_val()) { 
		if (bean.get_numeric_val() == null) {
			buf.append("numeric_val is NULL and ");
			}
		else{
			buf.append("numeric_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_char_val()) { 
		if (bean.get_char_val() == null) {
			buf.append("char_val is NULL and ");
			}
		else{
			buf.append("char_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_varchar_val()) { 
		if (bean.get_varchar_val() == null) {
			buf.append("varchar_val is NULL and ");
			}
		else{
			buf.append("varchar_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_longvarchar_val()) { 
		if (bean.get_longvarchar_val() == null) {
			buf.append("longvarchar_val is NULL and ");
			}
		else{
			buf.append("longvarchar_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_date_val()) { 
		if (bean.get_date_val() == null) {
			buf.append("date_val is NULL and ");
			}
		else{
			buf.append("date_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_time_val()) { 
		if (bean.get_time_val() == null) {
			buf.append("time_val is NULL and ");
			}
		else{
			buf.append("time_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_timestamp_val()) { 
		if (bean.get_timestamp_val() == null) {
			buf.append("timestamp_val is NULL and ");
			}
		else{
			buf.append("timestamp_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_bit_val()) { 
		if (bean.get_bit_val() == null) {
			buf.append("bit_val is NULL and ");
			}
		else{
			buf.append("bit_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_array_val()) { 
		if (bean.get_array_val() == null) {
			buf.append("array_val is NULL and ");
			}
		else{
			buf.append("array_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_boolean_val()) { 
		if (bean.get_boolean_val() == null) {
			buf.append("boolean_val is NULL and ");
			}
		else{
			buf.append("boolean_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_varbinary_val()) { 
		if (bean.get_varbinary_val() == null) {
			buf.append("varbinary_val is NULL and ");
			}
		else{
			buf.append("varbinary_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_json_val()) { 
		if (bean.get_json_val() == null) {
			buf.append("json_val is NULL and ");
			}
		else{
			buf.append("json_val=? and ");
			__count++;
			}
		}
	if (bean.isModified_jsonb_val()) { 
		if (bean.get_jsonb_val() == null) {
			buf.append("jsonb_val is NULL and ");
			}
		else{
			buf.append("jsonb_val=? and ");
			__count++;
			}
		}

	buf.setLength(buf.length() - 4);
	if (clause != null) {
		buf.append(" ");
		buf.append(clause);
		}

	final String countUsingStmt = buf.toString();
	PreparedStatement ps = prepareStatement(con, countUsingStmt);
	int pos = 0;
	if (bean.isModified_id()) {
			pos++;
			int id = bean.get_id();
			ps.setInt(pos, id); 
			}
	if (bean.isModified_smallint_val()) {
		if (bean.isModifiedSetNull_smallint_val()) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			short smallint_val = bean.get_smallint_val();
			ps.setShort(pos, smallint_val); 
			}
		}
	if (bean.isModified_int_val()) {
			pos++;
			int int_val = bean.get_int_val();
			ps.setInt(pos, int_val); 
			}
	if (bean.isModified_bigint_val()) {
		if (bean.isModifiedSetNull_bigint_val()) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			long bigint_val = bean.get_bigint_val();
			ps.setLong(pos, bigint_val); 
			}
		}
	if (bean.isModified_float_val()) {
		if (bean.isModifiedSetNull_float_val()) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			float float_val = bean.get_float_val();
			ps.setFloat(pos, float_val); 
			}
		}
	if (bean.isModified_double_val()) {
		if (bean.isModifiedSetNull_double_val()) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			double double_val = bean.get_double_val();
			ps.setDouble(pos, double_val); 
			}
		}
	if (bean.isModified_numeric_val()) {
		if (bean.get_numeric_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			BigDecimal numeric_val = bean.get_numeric_val();
			ps.setBigDecimal(pos, numeric_val); 
			}
		}
	if (bean.isModified_char_val()) {
		if (bean.get_char_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			String char_val = bean.get_char_val();
			ps.setString(pos, char_val); 
			}
		}
	if (bean.isModified_varchar_val()) {
		if (bean.get_varchar_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			String varchar_val = bean.get_varchar_val();
			ps.setString(pos, varchar_val); 
			}
		}
	if (bean.isModified_longvarchar_val()) {
		if (bean.get_longvarchar_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			String longvarchar_val = bean.get_longvarchar_val();
			ps.setString(pos, longvarchar_val); 
			}
		}
	if (bean.isModified_date_val()) {
		if (bean.get_date_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			java.sql.Date date_val = bean.get_date_val();
			ps.setDate(pos, date_val); 
			}
		}
	if (bean.isModified_time_val()) {
		if (bean.get_time_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			Time time_val = bean.get_time_val();
			ps.setTime(pos, time_val); 
			}
		}
	if (bean.isModified_timestamp_val()) {
		if (bean.get_timestamp_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			Timestamp timestamp_val = bean.get_timestamp_val();
			ps.setTimestamp(pos, timestamp_val); 
			}
		}
	if (bean.isModified_bit_val()) {
		if (bean.get_bit_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			Boolean bit_val = bean.get_bit_val();
			ps.setObject(pos, bit_val); 
			}
		}
	if (bean.isModified_array_val()) {
		if (bean.get_array_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			java.sql.Array array_val = bean.get_array_val();
			ps.setArray(pos, array_val); 
			}
		}
	if (bean.isModified_boolean_val()) {
		if (bean.get_boolean_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			Boolean boolean_val = bean.get_boolean_val();
			ps.setObject(pos, boolean_val); 
			}
		}
	if (bean.isModified_varbinary_val()) {
		if (bean.get_varbinary_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			byte[] varbinary_val = bean.get_varbinary_val();
			ps.setBytes(pos, varbinary_val); 
			}
		}
	if (bean.isModified_json_val()) {
		if (bean.get_json_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			String json_val = bean.get_json_val();
			ps.setObject(pos, json_val, java.sql.Types.OTHER); 
			}
		}
	if (bean.isModified_jsonb_val()) {
		if (bean.get_jsonb_val() == null) { 
			/* no value to set here, uses [xxx IS NULL] syntax*/
			}
		else{
			pos++;
			String jsonb_val = bean.get_jsonb_val();
			ps.setObject(pos, jsonb_val, java.sql.Types.OTHER); 
			}
		}
	log.bug("Query to run: ", ps);
	ResultSet rs = ps.executeQuery();
	if (! rs.next()) {
		throw new DBOException("The COUNT query [" + countUsingStmt + "] returned no rows. [Should have returned 1 row exactly] ");
		}
	int rows = rs.getInt(1);
	rs.close();
	return rows;
	}

/** 
Convenience method that invokes {@link getUsing(Connection, alltypes, String) getUsing} with an empty <i><tt>clause</tt></i> parameter.*/
public static int countUsing(final Connection con, final alltypes bean) throws ValidateException, SQLException
	{
	return countUsing(con, bean, null);
	}

static private final String existsStmt = "SELECT count(*) from alltypes WHERE id=?";
/**
Returns <tt>true</tt> if a row with the specified primary keys exists, <tt>false</tt> otherwise.
<p>This method uses a prepared statement and is safe from SQL injection attacks
*/
public static boolean exists(final Connection con, int id) throws SQLException
	{
	__exists_called++;
	PreparedStatement ps = prepareStatement(con, existsStmt);
	ps.setInt(1, id); 
	log.bug("Query to run: ", ps);
	ResultSet rs = ps.executeQuery();
	int __count = -1;
    if (rs.next())
    	{
      	__count = rs.getInt(1);
    	}
	else { //rs returned no count, which should never happen
		throw new DBOException("The COUNT query [" + existsStmt + "] returned no rows. [Should have returned 1 row exactly] ");
		}
	rs.close();
	return (__count > 0); //exists if __count > 0
	}
/**
A thin wrapper around {@link getUsing(Connection,alltypes) getUsing}
that returns <tt>false</tt> if no rows are returned, <tt>true</tt> otherwise.
*/
public static boolean existsUsing(final Connection con, final alltypes bean) throws ValidateException, SQLException
	{
	final List list = getUsing(con, bean, null);
	return (list.size() > 0);
	}

/**
Returns a prepared statement given it's variable name.

Essentially speeds up the creation of prepared statements perhaps
using a per connection cache -- which makes sense for pooled
connections since they are not closed but returned to the pool
and hence don't need to "prepare" statements every time (the
prepareStatement call is seperate from actually filling in the
placeholders in a already created prepared statement -- which
does need to be done every time). <p>
Prepared statements are unique per connection, so multiple threads
using different connections won't stomp over each other's prepared
statements. Multiple threads using the SAME connection will cause
bizarre errors but multiple threads won't get the same connection
from the connection manager -- ever :-), so that should never happen.
*/
private static final PreparedStatement prepareStatement ( final Connection con, final String sql) throws SQLException
	{
	if (! (con instanceof fc.jdbc.PooledConnection) ) { 
		return con.prepareStatement(sql);
		}
	final PooledConnection pc = (PooledConnection) con;
	return pc.getCachedPreparedStatement(sql);
	}

private static final void checkDiscarded(final DBO bean) throws DBOException
	{
	if (bean.isDiscarded()) {
		throw new DBOException("===== Attempt to save a discarded object === " + bean);
		}
	}

private static final java.util.Date __loadDate = new java.util.Date();
/** Returns usage statistics for this class */
public static String stats() 
	{
	//locally created _numberFormat for thread safety
	final java.text.NumberFormat _numberFormat = java.text.NumberFormat.getInstance();
	final String nl = fc.io.IOUtil.LINE_SEP;
	StringBuffer buf = new StringBuffer(256);
	buf.append("Class Name: [alltypesMgr]; Class loaded on: ");
	buf.append(__loadDate);
	buf.append(nl);
	buf.append("---- Start Usage Statistics ----").append(nl);

	ByteArrayOutputStream out = new ByteArrayOutputStream(512);
	TablePrinter.PrintConfig config = new TablePrinter.PrintConfig();
	config.setPrintBorders(false);
	config.setCellSpacing(1);
	config.setCellPadding(0);
	config.setAutoFit(true);
	TablePrinter p = new TablePrinter(2, new PrintStream(out), config);
	p.startTable();

	p.startRow();
	p.printCell("Method");
	p.printCell("# times called");
	p.endRow();

	p.startRow();
	p.printCell("getAll()");
	p.printCell(_numberFormat.format(__getall_called));
	p.endRow();

	p.startRow();
	p.printCell("getLimited()");
	p.printCell(_numberFormat.format(__getlimited_called));
	p.endRow();

	p.startRow();
	p.printCell("getByKey()");
	p.printCell(_numberFormat.format(__getbykey_called));
	p.endRow();

	p.startRow();
	p.printCell("getWhere()");
	p.printCell(_numberFormat.format(__getwhere_called));
	p.endRow();

	p.startRow();
	p.printCell("getUsing()");
	p.printCell(_numberFormat.format(__getusing_called));
	p.endRow();

	p.startRow();
	p.printCell("getUsing(prepared_stmt)");
	p.printCell(_numberFormat.format(__getusing_ps_called));
	p.endRow();

	p.startRow();
	p.printCell("getFromRS()");
	p.printCell(_numberFormat.format(__getfromrs_called));
	p.endRow();

	p.startRow();
	p.printCell("save()");
	p.printCell(_numberFormat.format(__save_called));
	p.endRow();

	p.startRow();
	p.printCell("delete()");
	p.printCell(_numberFormat.format(__delete_called));
	p.endRow();

	p.startRow();
	p.printCell("deleteByKey()");
	p.printCell(_numberFormat.format(__deletebykey_called));
	p.endRow();

	p.startRow();
	p.printCell("deleteWhere()");
	p.printCell(_numberFormat.format(__deletewhere_called));
	p.endRow();

	p.startRow();
	p.printCell("deleteUsing()");
	p.printCell(_numberFormat.format(__deleteusing_called));
	p.endRow();

	p.startRow();
	p.printCell("count()");
	p.printCell(_numberFormat.format(__count_called));
	p.endRow();

	p.startRow();
	p.printCell("countWhere()");
	p.printCell(_numberFormat.format(__countwhere_called));
	p.endRow();

	p.startRow();
	p.printCell("countUsing()");
	p.printCell(_numberFormat.format(__countusing_called));
	p.endRow();

	p.startRow();
	p.printCell("exists()");
	p.printCell(_numberFormat.format(__exists_called));
	p.endRow();

	p.endTable();
	buf.append(out.toString());
	return buf.toString();
	}

public String toString() 
	{
	return getClass().getName() + " [call stats() for more info]";
	}

// ================ Validation  ==================== 

/** 
Creates and attaches validators for all the fields in the
specified {@link fc.web.forms.Form}. These fields should
<i>have the same name</i> in the form as in {@link alltypes}. If this is not the case, then the then the differences can be specifed
as follows. <p>
<dl>
<dt>with a prefix</dt>
	<dd><tt>(prefix + alltypes column)</tt> should equal <tt>form fieldname</tt></dd>
<dt>with a suffix</dt> 
	<dd><tt>(alltypes column + suffix)</tt> should equal <tt>form fieldname</tt></dd>
<dt>with both a prefix/suffix</dt> 
	<dd><tt>(prefix + alltypes + suffix)</tt> should equal <tt>form fieldname</tt></dd>
<dt>with a arbitrary map</dt> 
	<dd>[key] <tt>alltypes column</tt> -> [value] <tt>form fieldname</tt>
	<u>If a map is specified, then the prefix/suffix are not used.</u>
	</dd>
</dl>
<p>These validators are for database constraints such as <i>nullability</i> & <i>column length</i>.
These validators save a lot of grunt-work in adding such schema
constraints to the front-end {@link fc.web.forms.Form}. <p><b>However, <i>business and
other validation constraints</i> still need to be manually added to
the application code/front-end forms as/when needed</b>.
<p>

The following table shows the kind of validators added by this method
<table border=1 width=90%>
<tr bgcolor='#CCCCCC'>
	<td>Database SQL Type</td>
	<td><b>Nullable</b>validator</td>
	<td><b>Length</b> validator</td>
	<td><b>Digits only</b> input validator ({@link VText#allowIntegersOnly})</td>
</tr>
	<tr>
		<td><tt>CHAR</tt>, <tt>VARCHAR</tt></td>
		<td>Yes (maximum length constraint).<br><font size='-1' color=red>This
		only applies to form fields that are subclasses of {@link 
		fc.web.forms.MaxSizable} </font></td>
		<td>-NO-</td>
	</tr>
	<tr>
		<td><tt>TINYINT, MEDIUMINT, INT, BIGINT (integral types)</tt></td>
		<td>Yes</td>
		<td>-NO-</td>
		<td>Yes to integer columns displayed using form fields that are subclasses of {@link fc.web.forms.AbstractText}<br> Note: <b>not</b> added non-<i>integral</i> number types such as <tt>FLOAT, REAL, DOUBLE, NUMERIC/DECIMAL</tt></td>
	</tr>
	<tr>
		<td>All other SQL types</td>
		<td>Yes</td>
		<td>-NO-</td>
	</tr>
</table>
<p>Automatic validators are very useful but can be very tricky to understand. It is
suggested to invoke this method, print the form using it's <tt>toString</tt>
method and then examine the output to see what validators were added If those
automatic validators are too little, too many or too hard to understand, <u>then
simply enoough, do NOT invoke this method and simply add validators by
hand</u>. In particular, do <i>not</i> add automatic validators for
<b>tables</b> in which a row is optional but <i>if</i> some column is filled in
the front end form, <i>then</i> all columns must be filled.

@param	form	the form containing fields (some or all) representing
				this and possible other tables. These field
				objects must have been added to the form prior
				to calling this method
@param	prefix  an optional (null allowed) prefix to this table's column name with which the
				corresponding column was added to the form.
				A <tt>*</tt> specifies all possible prefixes
@param	suffix  an optional suffix (null allowed) to this table's column name with which the 
				corresponding column was added to the form.
				A <tt>*</tt> specifies all possible suffixes
@param	map		an optional map (null allowed) that maps this table's column name with which the 
				corresponding column was added to the form. 
				[key] <tt>table's column_name</tt> -> [value] <tt>form's fieldname</tt>
*/
public static void addValidators(final fc.web.forms.Form form, final String prefix, final String suffix, final Map map) 
	{
	addValidators(form, prefix, suffix, map, false);
	}

private static void addValidators(fc.web.forms.Form form, String prefix, String suffix, final Map map, final boolean onlyOnFilled) 
	{
	List list = null;
	Argcheck.notnull(form, "How can I add validators to the form when the form parameter was null ?");
	Field field = null;
	FieldValidator fv = null;
	String colname_in_form = null;
	//fields can be null if they are not being used in the html form

	/** serial (INTEGER); PK=yes; Nullable=false; AutoInc=true; MaxSize=10 */
	list = getFieldFromForm(form, "id", prefix, suffix, map, false);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is non-nullable but has a default value [nextval('alltypes_id_seq'::regclass)], skipping non-nullability validation */

			/* database type for this field is integral */
			if (field instanceof AbstractText) {
				fv = new VText((AbstractText)field, "Error: Please enter only numbers in this field")
					.allowIntegersOnly();
				}
			}
		}

	/** int2 (SMALLINT); Nullable=true; AutoInc=false; MaxSize=5 */
	list = getFieldFromForm(form, "smallint_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */

			/* database type for this field is integral */
			if (field instanceof AbstractText) {
				fv = new VText((AbstractText)field, "Error: Please enter only numbers in this field")
					.allowIntegersOnly();
				}
			}
		}

	/** int4 (INTEGER); Nullable=false; AutoInc=false; MaxSize=10 */
	list = getFieldFromForm(form, "int_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			if (field instanceof Choice) {
				//choice fields are ignored because they can
				//mean false even when NOT selected/filled
				continue;
				}
			/* field is non-nullable */
			fv = new VFilled(field, "Error: Required field, please enter a value");

			/* database type for this field is integral */
			if (field instanceof AbstractText) {
				fv = new VText((AbstractText)field, "Error: Please enter only numbers in this field")
					.allowIntegersOnly();
				}
			}
		}

	/** int8 (BIGINT); Nullable=true; AutoInc=false; MaxSize=19 */
	list = getFieldFromForm(form, "bigint_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */

			/* database type for this field is integral */
			if (field instanceof AbstractText) {
				fv = new VText((AbstractText)field, "Error: Please enter only numbers in this field")
					.allowIntegersOnly();
				}
			}
		}

	/** float4 (REAL); Nullable=true; AutoInc=false; MaxSize=8 */
	list = getFieldFromForm(form, "float_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */
			}
		}

	/** float8 (DOUBLE); Nullable=true; AutoInc=false; MaxSize=17 */
	list = getFieldFromForm(form, "double_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */
			}
		}

	/** numeric (NUMERIC); Nullable=true; AutoInc=false; MaxSize=5 */
	list = getFieldFromForm(form, "numeric_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */
			}
		}

	/** bpchar (CHAR); Nullable=true; AutoInc=false; MaxSize=10 */
	list = getFieldFromForm(form, "char_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */
			if (! (field instanceof MaxSizable)) {
				log.warn("Skipping maximum length validator for field '" + field.getName() + "'; [database type='CHAR', field.type='" +  field.getType() + "' is not MaxSizable]"); 
				}
			else{
				VText vt = new VText((MaxSizable) field, "Not enough or too many characters");
				vt.setMaxSize(10);
				}
			}
		}

	/** varchar (VARCHAR); Nullable=true; AutoInc=false; MaxSize=10 */
	list = getFieldFromForm(form, "varchar_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */
			if (! (field instanceof MaxSizable)) {
				log.warn("Skipping maximum length validator for field '" + field.getName() + "'; [database type='VARCHAR', field.type='" +  field.getType() + "' is not MaxSizable]"); 
				}
			else{
				VText vt = new VText((MaxSizable) field, "Not enough or too many characters");
				vt.setMaxSize(10);
				}
			}
		}

	/** text (VARCHAR); Nullable=true; AutoInc=false; MaxSize=2147483647 */
	list = getFieldFromForm(form, "longvarchar_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */
			if (! (field instanceof MaxSizable)) {
				log.warn("Skipping maximum length validator for field '" + field.getName() + "'; [database type='VARCHAR', field.type='" +  field.getType() + "' is not MaxSizable]"); 
				}
			else{
				VText vt = new VText((MaxSizable) field, "Not enough or too many characters");
				vt.setMaxSize(2147483647);
				}
			}
		}

	/** date (DATE); Nullable=true; AutoInc=false; MaxSize=13 */
	list = getFieldFromForm(form, "date_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */
			}
		}

	/** time (TIME); Nullable=true; AutoInc=false; MaxSize=15 */
	list = getFieldFromForm(form, "time_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */
			}
		}

	/** timestamp (TIMESTAMP); Nullable=true; AutoInc=false; MaxSize=29 */
	list = getFieldFromForm(form, "timestamp_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */
			}
		}

	/** bit (BIT); Nullable=true; AutoInc=false; MaxSize=1 */
	list = getFieldFromForm(form, "bit_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */
			}
		}

	/** _varchar (ARRAY); Nullable=true; AutoInc=false; MaxSize=10 */
	list = getFieldFromForm(form, "array_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */
			}
		}

	/** bool (BIT); Nullable=true; AutoInc=false; MaxSize=1 */
	list = getFieldFromForm(form, "boolean_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */
			}
		}

	/** bytea (BINARY); Nullable=true; AutoInc=false; MaxSize=2147483647 */
	list = getFieldFromForm(form, "varbinary_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */
			}
		}

	/** json (OTHER); Nullable=true; AutoInc=false; MaxSize=2147483647 */
	list = getFieldFromForm(form, "json_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */
			}
		}

	/** jsonb (OTHER); Nullable=true; AutoInc=false; MaxSize=2147483647 */
	list = getFieldFromForm(form, "jsonb_val", prefix, suffix, map, true);
	if (list.size() > 0) 
		{ //add applicable automatic validators, empty if n/a
		for (int n = 0; n < list.size(); n++)
			{
			field = (Field) list.get(n);
			/* field is nullable, skipping non-nullability validation */
			}
		}
	}

/** 
Convenience method that calls {@link #addValidators(Form, String, String, Map)} with a 
<tt>null</tt> prefix/suffix and the specified map
*/
public static void addValidators(fc.web.forms.Form form, Map map) 
	{
	addValidators(form, null, null, map);
	}

/** 
Convenience method that calls {@link #addValidators(Form, String, String, Map)} with a 
<tt>null</tt> prefix/suffix/map
*/
public static void addValidators(fc.web.forms.Form form) 
	{
	addValidators(form, null, null, null);
	}

/** 
Convenience method that calls {@link #addValidators(Form, String, String, map)} with the 
specified prefix and a <tt>null</tt> suffix/map
*/
public static void addValidators(fc.web.forms.Form form, String prefix) 
	{
	addValidators(form, prefix, null, null);
	}

/** 
Validates a form field <i>if</i> it is filled by the user. Leaves empty fields alone.
This is very useful for fields that are optional but must have the correct value when
filled by the user
*/
public static void addIfFilledValidators(Form form, String prefix) 
	{
	addValidators(form, prefix, null, null, true);
	}

/** implementation helper method -- not for public use */
static List getFieldFromForm(Form form, String colname, String prefix, String suffix, Map map, boolean warn)
	{
	Field field = null;
	List list = Form.empty_list;
	boolean getwhere = false;
	getwhere = false;
	String colname_in_form = colname;

	if (map != null) {
		String str = (String) map.get(colname);
		if (str != null) {
			prefix = null;  /*ignored when there is a mapping*/
			suffix = null;  /*ignored when there is a mapping*/
			colname_in_form = str; /* else if not in map, colname remains as-is*/
			}
		}

	if (prefix != null) 
		{ 
		if (prefix.equals("*")) { 
			getwhere = true;
			}
		else{
			colname_in_form = prefix + colname_in_form;
			}
		}

	if (suffix != null) 
		{
		if (suffix.equals("*")) { 
			getwhere = true;
			}
		else{
			colname_in_form = colname_in_form + suffix;
			}
		}

	if (getwhere) { 
		list = form.getContaining(colname_in_form);
		if (list.size() == 0 && warn) warn(form, colname_in_form, suffix, prefix, map);
		return list;
		}
	else{
		//containsField() check prevents an un-necessary warning with form.get()
		if (! form.containsField(colname_in_form)) {
			if (warn) warn(form, colname_in_form, suffix, prefix, map);
			return list;
			}
		field = form.get(colname_in_form);
		list = new ArrayList();
		list.add(field);
		}
	return list;
	}

private static final void warn(Form form, String name, String suffix, String prefix, Map map) {
	log.warn(form.getName(),": No automatic validators will be added for Field [",name,"]. This field does not exist in the front-end form. (this could be normal). suffix=["+suffix+"] prefix=["+prefix+"] map=", map);
	}

/** 
Validates the bean before saving it to the database. This
method is called internally by the {@link save()} method
before saving a new bean (i.e., inserting a new row) to the
database.
<p>
The validation is somewhat basic and there can exist many
constraints and conditions on the database that might results in a
insert/update error anyway. But by doing some basic validation
against some known constraints, we save a needless trip to the
database.
We check to see that: <ol>
<li><i>non-nullable and non auto-increment</i> columns [and with no default
column value in the database] are modified (via a set method) since these
columns must have a explicitly set value.</li>
<li>for non-nullable columns that hold non-primitive (i.e., Object)
java types, the modified value for non-nullable columns is a
non-null object. </li>
</ol>
*/
protected static void validateBeforeSaveNew(alltypes bean) throws ValidateException
	{
	boolean error = false;
	final StringBuffer buf = new StringBuffer("The following validation errors were found").append(IOUtil.LINE_SEP);

	//[id]=>is not nullable but has a default column value [nextval('alltypes_id_seq'::regclass)], no modification check necessary, skipping...

	//[smallint_val]=>nullable, no modification check necessary, skipping...

	if (! bean.isModified_int_val()) {
		error = true;
		buf.append("int_val was not set (this field is required in the database)").append(";current value=").append(bean.get_int_val()).append(IOUtil.LINE_SEP);
		}
	//int is primitive, skipping null test

	//[bigint_val]=>nullable, no modification check necessary, skipping...

	//[float_val]=>nullable, no modification check necessary, skipping...

	//[double_val]=>nullable, no modification check necessary, skipping...

	//[numeric_val]=>nullable, no modification check necessary, skipping...

	//[char_val]=>nullable, no modification check necessary, skipping...

	//[varchar_val]=>nullable, no modification check necessary, skipping...

	//[longvarchar_val]=>nullable, no modification check necessary, skipping...

	//[date_val]=>nullable, no modification check necessary, skipping...

	//[time_val]=>nullable, no modification check necessary, skipping...

	//[timestamp_val]=>nullable, no modification check necessary, skipping...

	//[bit_val]=>nullable, no modification check necessary, skipping...

	//[array_val]=>nullable, no modification check necessary, skipping...

	//[boolean_val]=>nullable, no modification check necessary, skipping...

	//[varbinary_val]=>nullable, no modification check necessary, skipping...

	//[json_val]=>nullable, no modification check necessary, skipping...

	//[jsonb_val]=>nullable, no modification check necessary, skipping...
	if (error) { 
		throw new ValidateException(buf.toString());
		}
	}

/** 
Validates the bean before saving it to the database. This method is
called internally by the {@link save()} method before updating an
existing bean (i.e., updating a row) in the database.
<p>
For <i>each modified column</i>, if that column is non-nullable in
the database, then it must have a non-null value in the bean before
it is saved. This check is only done for fields of
<i>non</i>-primitive (Object) java types. [There is no way to ensure
a non-null value for <i>primitive</i> types since all values
[including 0] are non-null for those types].
*/
protected static void validateBeforeSaveUpdate(alltypes bean) throws ValidateException
	{
	boolean error = false;
	final StringBuffer buf = new StringBuffer("The following validation errors were found").append(IOUtil.LINE_SEP);

	//[id]=>auto-increment, no modification check necessary, skipping...
	//[smallint_val]=>nullable, no modification check necessary, skipping...
	if (bean.isModified_int_val()) {
		//int is primitive, skipping null test
		}
	//[bigint_val]=>nullable, no modification check necessary, skipping...
	//[float_val]=>nullable, no modification check necessary, skipping...
	//[double_val]=>nullable, no modification check necessary, skipping...
	//[numeric_val]=>nullable, no modification check necessary, skipping...
	//[char_val]=>nullable, no modification check necessary, skipping...
	//[varchar_val]=>nullable, no modification check necessary, skipping...
	//[longvarchar_val]=>nullable, no modification check necessary, skipping...
	//[date_val]=>nullable, no modification check necessary, skipping...
	//[time_val]=>nullable, no modification check necessary, skipping...
	//[timestamp_val]=>nullable, no modification check necessary, skipping...
	//[bit_val]=>nullable, no modification check necessary, skipping...
	//[array_val]=>nullable, no modification check necessary, skipping...
	//[boolean_val]=>nullable, no modification check necessary, skipping...
	//[varbinary_val]=>nullable, no modification check necessary, skipping...
	//[json_val]=>nullable, no modification check necessary, skipping...
	//[jsonb_val]=>nullable, no modification check necessary, skipping...
	if (error) { 
		throw new ValidateException(buf.toString());
		}
	}
}
