// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.jdbc.dbo;

import java.io.*;
import java.sql.*;
import java.util.*;
import java.util.logging.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/**
Abstracts database specific functions that are called when
examining/generating that particular database. Subclasses implement
functions for a specific database. Sometimes if most databases share a
similar implemenation for some method, then that method could be
implemented here and overridden for the specific non-conforming database
in a subclass.

Note: subclasses should be named "DB<tt>foo</tt>" where </tt>foo</tt> is
the all lower cased version of the name returned by <tt>toString()</tt>
for a database type defined in {@link DBName}

@author hursh jain
**/
abstract class DBspecific
{
/**
Takes a result set obtained via an appropriate meta data (md) getColumns() 
invocation like:
<br>
<tt>md.getColumns(catalogName, null, tableName, "%");</tt> Then this
method can be invoked for each iteration via (<tt>rs.next()</tt>). Each
iteration gives information about a different column in the table and
this method can examine a particular column to see if it's an auto
increment column. Therefore, example usage may look like:
<blockquote>
ResultSet rs = md.getColumns(catalogName, null, tableName, "%")
while (rs.next) {
	int datatype 		= rs.getInt	("DATA_TYPE");
	String typename 	= rs.getString	("TYPE_NAME");
	boolean isautoinc 	= <b>isAutoIncrement(rs)</b>;
	}
</blockquote>
The ResultSet is left as is and implementations of this method do not
call <tt>rs.next()</tt> etc., on the supplied ResultSet.
<p>
Note 1: Some databases like mysql/connector-j, no longer return auto-increment
data via the "remarks" column, so we need to pass in a connection here to
the database so that other ad-hoc approaches can be used to intuit auto
increment types.

@param	con			a connection to the database. Not typically used except
					for the mysql implementation of this method. 
@param	table		the name of the table being considered. Not used except
					for the mysql implementation. 
@param	col			the name of the column being considered. Not used except
					for the mysql implementation. 
@param	rs			ResultSet returned by the <code>metadata.getColumns(..)</code> method.

@return 	true if auto increment, false otherwise
*/
abstract boolean isAutoIncrement(Connection con, String table, String col, ResultSet rs) throws SQLException;

/**
Returns a SQL query that can be used to fetch the last auto increment value for
the specified column.
*/
abstract String getAutoIncrementQuery(ColumnData cd) throws SQLException;

/**
Returns the offset and limit phrase of a sql query. If the database does not support
offset/limit, then return <code>null</code>

Todo for future: the same offset/limit syntax is supported by postgres and mysql so is
hardcoded in the Generate.mgrWriteMethodGetLimited() method. This can be reworked if
oracle support is implemented but oracle == shit-acle (the worst possible turd). so i
really don't care about it myself.

For oracle, google tells me that we something like this:
SELECT id, name FROM
   (SELECT id, name, ROW_NUMBER() OVER (ORDER BY id) AS ora_row_num
    FROM my_table)
   WHERE ora_row_num > 10 AND ora_row_num <= 20
 --hj
*/
//abstract String getLimitClause(int offset, int limit) throws SQLException;
}		
