// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.jdbc.dbo;

import java.io.*;
import java.sql.*;
import java.util.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/**
The base dbo class which is extended by all generated
dbo classes.

@author hursh jain
*/
public class DBO
{
protected boolean 	isDiscarded;

/**
Constructs a new DBO object. The object is set to
be valid.
*/
protected DBO() 
	{
	this.isDiscarded = false;
	}	

/** 
Returns <tt>true</tt> if this object has been discarded.
Objects are discarded after they have been saved to the 
database. 
*/
public boolean isDiscarded()
	{
	return this.isDiscarded;
	}

/** 
"discards" this object. After an object is discarded, it's
contents are considered invalid and any attempt to save this
object will fail. This is a non-reversible procedure,
meaning an object cannot be marked as non-discarded after
calling this method.
*/
public void discard() 
	{
	this.isDiscarded = true;
	}

}