// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.jdbc;

import java.io.*;
import java.util.*;
import java.util.logging.*;
import java.sql.*;

import fc.io.*;
import fc.util.*;

/** 
A simple connection manager that returns a new connection to the
database every time.

@author hursh jain
*/
public class SimpleConnectionMgr extends ConnectionMgr
{

/**
{@see ConnectionMgr} 
**/
public SimpleConnectionMgr(
		String jdbc_url, String jdbc_driver, 
		String jdbc_user, String jdbc_password, 
		String jdbc_catalog) 	
throws Exception
	{
	super(jdbc_url, jdbc_driver, jdbc_user, jdbc_password, jdbc_catalog);
	}


/** {@see ConnectionMgr} **/
public SimpleConnectionMgr(PropertyMgr props) 
throws Exception
	{
	super(props);
	}

/** {@see ConnectionMgr} **/
public SimpleConnectionMgr(PropertyMgr props, String prefix) 
throws Exception
	{
	super(props, prefix);
	}

/** {@see ConnectionMgr} **/
public SimpleConnectionMgr(SystemLog log, PropertyMgr props) 
throws Exception
	{
	super(log, props);
	}

protected boolean handleMgrShutdown()
	{
	//nothing to do
	return true;
	}
	
/**
Returns a new connection to the DB everytime it's called.
**/	
protected Connection getConImpl() throws SQLException
	{
	Connection con = null;
	log.bug("enter");
	if (log.getLevel() == Log.DEBUG) {
		DriverManager.setLogStream(System.err);
		}
	try {
		con = DriverManager.getConnection(url,user,password);
		log.bug("getOneImpl(), got connection: " + con);	
		}
	catch (SQLException e) {	
		log.warn("getOneConnection(): Could not get a database connection.", e);
		String socksProxyHost = System.getProperty("socksProxyHost");
		if (socksProxyHost != null) 
			{	
			log.warn("A network proxy is in use (this could be the reason): ",
				"socksProxyHost=", socksProxyHost,
        		", socksProxyPort=", System.getProperty("socksProxyPort"));
        	log.warn("Invoke java with -DsocksProxyHost='' to get rid of the proxy");
        	}
		e.fillInStackTrace();
		throw e;
		}
	return con;
	}	//~ connect()
		
/**	
Unit Test History 	
<pre>
Tester		Status			Notes				
hj			passed		
</pre>
**/	
public static void main(String[] args) throws Exception
	{
	Args myargs = new Args(args);
	myargs.setUsage("java fc.jdbc.SimpleConnectionMgr -conf <path-to-config-file> [-query query-to-execute]");
	
	String query  	= myargs.get("query", null);
	String propfile = myargs.getRequired("conf");
	
	try {
		ConnectionMgr mgr = new SimpleConnectionMgr(  
									new FilePropertyMgr(
										new File(propfile)));
		
		Connection con = mgr.getConnection();
		System.out.println("GOT CONNECTION:" + con);

		if (query != null)
			{
			Statement stmt = con.createStatement();
			ResultSet rs = stmt.executeQuery(query);
			System.out.println("======= query using connection ===");
			QueryUtil.printRS(rs);
			System.out.println("==================================");
			stmt.close();		
			}
		System.out.println("The following should give an error");
		mgr.close();
		mgr.getConnection();
		}
	catch (Exception e) {
		e.printStackTrace();
		}	
	}
	
}  //~class JDBCConnection


