// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.io;

import java.io.*;

/**
Prepends thread information.

@author 	hursh jain
@version 	1.0, 10/19/2001
@see     	fc.io.Logger
**/
public class ClassInfoFilter implements ILogFilter
{
public void transform(Object caller, Thread callingThread, StringBuffer buf)  
	{
	if (caller == null)  {
		return;
		}
	StringBuffer tmp = new StringBuffer(64);
	tmp.append("[class=");
	tmp.append(caller.getClass().getName());
	tmp.append(";object=" + caller.toString() + "] ");
	buf.insert(0, tmp.toString());
	}

public String toString() 
	{
	return "Class and Object Information filter";
	}

}           //~class ThreadInfoFilter