// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.io.fileselectors;

import java.io.*;
import java.util.*;

/**
Filters a list of files and chooses only sub-directories.

@author hursh jain
@date 	3/24/2002
**/	 	
public class DirectorySelector extends ChainedFileSelector 
{
//for convenience
public DirectorySelector() { 
	this(null);
	}

public DirectorySelector(ChainedFileSelector filter) { 
	super(filter);
	}

protected boolean thisfilter(File name) {	
	if ( ! name.isDirectory() ) return false; 
	return true;
	}
	
public static void main(String[] args) throws Exception
	{
	new Test();
	}

/**
Unit Test History 	
<pre>
Class Version	Tester	Status		Notes
1.0				hj		passed	
</pre>
*/
static private class Test {
Test() throws Exception
	{
	File startdir = new File("c:\\temp");
	ChainedFileSelector sel = new DirectorySelector();
	File[] files = startdir.listFiles(sel);
	List list = Arrays.asList(files);			
	System.out.println("total="+ list.size() + ", files=" + list);
	}
}	//~class Test

}