/*
 * Decompiled with CFR 0.152.
 */
package fc.web.servlet;

import fc.io.IOUtil;
import fc.io.Log;
import fc.jdbc.SimpleConnectionMgr;
import fc.util.Args;
import fc.util.FilePropertyMgr;
import fc.web.servlet.JDBCSession;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.SQLException;

public class TransactionToken {
    public static final String TransactionToken_Key = "transact_token";
    static Log log = Log.get("fc.web.servlet");
    static JDBCSession session = JDBCSession.getInstance(log);

    public static void create(Connection connection, String string) throws SQLException {
        if (!session.exists(connection, string)) {
            throw new IllegalStateException("the specifed sessionID [" + string + "] does not exist");
        }
        long l = System.currentTimeMillis();
        byte[] byArray = String.valueOf(l).getBytes();
        byte[] byArray2 = string.getBytes();
        MessageDigest messageDigest = null;
        String string2 = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray2);
            messageDigest.update(byArray);
            string2 = TransactionToken.toHex(messageDigest.digest()).toString();
        }
        catch (Exception exception) {
            throw new IllegalStateException(IOUtil.throwableToString(exception));
        }
        log.bug("Adding new transaction token=", string2, " for sessionID=", string);
        session.add(connection, string, TransactionToken_Key, string2);
    }

    public static void revoke(Connection connection, String string) throws SQLException {
        session.delete(connection, string, TransactionToken_Key);
    }

    public static boolean isValid(Connection connection, String string, HttpServletRequest httpServletRequest) throws SQLException {
        String string2 = httpServletRequest.getParameter(TransactionToken_Key);
        if (string2 == null) {
            return false;
        }
        String string3 = session.get(connection, string, TransactionToken_Key);
        return string2.equals(string3);
    }

    private static StringBuffer toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF));
        }
        return stringBuffer;
    }

    public static void main(String[] stringArray) throws Exception {
        Args args = new Args(stringArray);
        args.setUsage("java fc.web.servlet.TransactionToken -conf conf-file -sessionID sessionID");
        String string = args.getRequired("conf");
        String string2 = args.getRequired("sessionID");
        SimpleConnectionMgr simpleConnectionMgr = new SimpleConnectionMgr(new FilePropertyMgr(new File(string)));
        Connection connection = simpleConnectionMgr.getConnection();
        log.setLevel(Log.DEBUG);
        JDBCSession jDBCSession = JDBCSession.getInstance(log);
        jDBCSession.create(connection, string2);
        System.out.println("creating new transaction id...");
        TransactionToken.create(connection, string2);
        System.out.println("Getting new transaction id from database");
        String string3 = jDBCSession.get(connection, string2, TransactionToken_Key);
        System.out.println("transaction id = " + string3);
        System.out.println("revoking token..");
        TransactionToken.revoke(connection, string2);
        System.out.println("....revoked");
        jDBCSession.get(connection, string2, TransactionToken_Key);
        System.out.println("transaction id = " + string3);
        connection.close();
    }
}

