/*
 * Decompiled with CFR 0.152.
 */
package fc.web.servlet;

import fc.io.HexOutputStream;
import fc.io.IOUtil;
import fc.jdbc.PooledConnection;
import fc.web.servlet.FCBaseServlet;
import fc.web.servlet.JDBCSession;
import fc.web.servlet.SessionUtil;
import fc.web.servlet.WebUtil;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class LoginServlet
extends FCBaseServlet {
    public static final String SID_COOKIE_NAME = "sid";
    protected String login_query;
    protected String loginPage;
    protected String welcomePage;
    protected String logoutWelcomePage;
    protected JDBCSession session;
    protected MessageDigest hash;

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            this.loginPage = WebUtil.getRequiredParam((Servlet)this, "login_page");
            this.welcomePage = WebUtil.getRequiredParam((Servlet)this, "welcome_page");
            this.logoutWelcomePage = WebUtil.getParam((Servlet)this, "logout_welcome_page", this.welcomePage);
            this.login_query = WebUtil.getRequiredParam((Servlet)this, "login_query");
            String string = WebUtil.getParam((Servlet)this, "password_hash", null);
            this.log.bug("login page=", this.loginPage);
            this.log.bug("welcome page=", this.welcomePage);
            this.log.bug("logout welcome page=", this.logoutWelcomePage);
            this.log.bug("login_query=", this.login_query);
            this.log.bug("password_hash=", string);
            this.hash = MessageDigest.getInstance(string);
            this.session = JDBCSession.getInstance();
        }
        catch (Exception exception) {
            this.log.error(IOUtil.throwableToString(exception));
            throw new ServletException(IOUtil.throwableToString(exception));
        }
    }

    public static Cookie getSIDCookie(HttpServletRequest httpServletRequest) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null) {
            return null;
        }
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!cookieArray[i].getName().equals(SID_COOKIE_NAME)) continue;
            return cookieArray[i];
        }
        return null;
    }

    boolean checkHasValidSID(Connection connection, HttpServletRequest httpServletRequest) throws SQLException {
        Cookie cookie = LoginServlet.getSIDCookie(httpServletRequest);
        if (cookie == null) {
            return false;
        }
        String string = cookie.getValue();
        return this.session.exists(connection, string);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            String string = httpServletRequest.getParameter("act");
            if (string != null && string.equals("logout")) {
                if (this.doLogout(connection, httpServletRequest, httpServletResponse)) {
                    this.goToTargetPage(httpServletRequest, httpServletResponse, this.logoutWelcomePage);
                    return;
                }
                return;
            }
            if (this.checkHasValidSID(connection, httpServletRequest)) {
                this.goToTargetPage(httpServletRequest, httpServletResponse, this.welcomePage);
                return;
            }
            if (!this.doLogin(connection, httpServletRequest, httpServletResponse)) {
                this.addFailureMessage(httpServletRequest);
                WebUtil.forward(httpServletRequest, httpServletResponse, this.loginPage);
                return;
            }
            this.goToTargetPage(httpServletRequest, httpServletResponse, this.welcomePage);
            return;
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                throw new ServletException((Throwable)sQLException);
            }
        }
    }

    public String validateUser(Connection connection, String string, String string2) throws SQLException, IOException {
        AutoCloseable autoCloseable;
        PreparedStatement preparedStatement = null;
        if (!(connection instanceof PooledConnection)) {
            preparedStatement = connection.prepareStatement(this.login_query);
        } else {
            autoCloseable = (PooledConnection)connection;
            preparedStatement = ((PooledConnection)autoCloseable).getCachedPreparedStatement(this.login_query);
        }
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, this.encodePassword(string2));
        this.log.bug("Validating logon using: ", preparedStatement);
        autoCloseable = preparedStatement.executeQuery();
        String string3 = null;
        if (autoCloseable.next()) {
            this.log.bug("Successfully validated username=", string, ". Got uid=[", string3 + "]");
            string3 = autoCloseable.getString(1);
        }
        return string3;
    }

    public String encodePassword(String string) throws IOException {
        if (this.hash == null || string == null) {
            return string;
        }
        try {
            MessageDigest messageDigest = (MessageDigest)this.hash.clone();
            byte[] byArray = messageDigest.digest(string.getBytes("UTF-8"));
            string = HexOutputStream.toHex(byArray);
        }
        catch (Exception exception) {
            throw new IOException(IOUtil.throwableToString(exception));
        }
        return string;
    }

    boolean doLogin(Connection connection, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws SQLException, IOException {
        boolean bl;
        String string = httpServletRequest.getParameter("username");
        String string2 = httpServletRequest.getParameter("password");
        if (string == null || string2 == null) {
            this.log.error("username not recieved in request (not present at all)");
            return false;
        }
        if (string2 == null) {
            this.log.error("password not recieved in request (not present at all)");
            return false;
        }
        String string3 = SessionUtil.newSessionID();
        String string4 = this.validateUser(connection, string, string2);
        boolean bl2 = bl = string4 != null;
        if (bl) {
            this.session.create(connection, string3, string4);
            this.addCookie(httpServletResponse, SID_COOKIE_NAME, string3);
            this.addCookie(httpServletResponse, "user.name", string);
            this.onLogin(connection, string3, string, httpServletRequest, httpServletResponse);
        } else {
            this.log.info("login FAILED for username=[", string, "]");
        }
        return bl;
    }

    boolean doLogout(Connection connection, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws SQLException, IOException {
        Cookie cookie = LoginServlet.getSIDCookie(httpServletRequest);
        if (cookie == null) {
            return false;
        }
        String string = cookie.getValue();
        this.log.bug("logging out: ", string);
        boolean bl = false;
        if (this.session.exists(connection, string)) {
            this.session.expire(connection, string);
            bl = true;
        } else {
            this.log.bug("session:", string, " does not exist, ignoring logout");
        }
        this.deleteCookie(httpServletResponse, "user.name");
        this.deleteCookie(httpServletResponse, SID_COOKIE_NAME);
        this.onLogout(connection, string, httpServletRequest, httpServletResponse);
        return bl;
    }

    public void onLogin(Connection connection, String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws SQLException, IOException {
    }

    public void onLogout(Connection connection, String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws SQLException, IOException {
    }

    void goToTargetPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException, ServletException {
        String string2 = null;
        Cookie cookie = WebUtil.getCookie(httpServletRequest, "target");
        if (cookie != null) {
            string2 = cookie.getValue();
            cookie.setPath("/");
            cookie.setMaxAge(0);
            httpServletResponse.addCookie(cookie);
        } else {
            string2 = httpServletRequest.getParameter("target");
        }
        if (string2 == null) {
            WebUtil.clientRedirect(httpServletRequest, httpServletResponse, string);
        } else {
            string2 = URLDecoder.decode(string2);
            WebUtil.clientRedirect(httpServletRequest, httpServletResponse, string2);
        }
    }

    void addFailureMessage(HttpServletRequest httpServletRequest) throws ServletException {
        String string = httpServletRequest.getParameter("retrycount");
        if (string == null) {
            string = "0";
        }
        Integer n = null;
        try {
            n = new Integer(Integer.parseInt(string) + 1);
        }
        catch (NumberFormatException numberFormatException) {
            n = new Integer(1);
            this.log.warn(numberFormatException);
        }
        httpServletRequest.setAttribute("retrycount", (Object)n);
    }

    final void addCookie(HttpServletResponse httpServletResponse, String string, String string2) {
        Cookie cookie = new Cookie(string, string2);
        cookie.setMaxAge(this.session.getExpireTime());
        httpServletResponse.addCookie(cookie);
    }

    final void deleteCookie(HttpServletResponse httpServletResponse, String string) {
        Cookie cookie = new Cookie(string, "");
        cookie.setMaxAge(0);
        httpServletResponse.addCookie(cookie);
    }
}

