/*
 * Decompiled with CFR 0.152.
 */
package fc.web.servlet;

import fc.jdbc.ConnectionMgr;
import fc.web.servlet.AuthFilter;
import fc.web.servlet.JDBCSession;
import fc.web.servlet.LoginServlet;
import fc.web.servlet.WebApp;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.sql.Connection;
import java.sql.SQLException;

public class JDBCAuthFilter
extends AuthFilter {
    private static final boolean dbg = false;
    private static ConnectionMgr cmgr;
    private static JDBCSession session;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        cmgr = WebApp.getInstance(this.appName).getConnectionMgr();
        session = JDBCSession.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserLoggedIn(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws SQLException {
        Cookie cookie = LoginServlet.getSIDCookie(httpServletRequest);
        if (cookie == null) {
            return false;
        }
        boolean bl = false;
        try (Connection connection = null;){
            connection = cmgr.getConnection();
            bl = session.exists(connection, cookie.getValue());
        }
        return bl;
    }
}

