/*
 * Decompiled with CFR 0.152.
 */
package fc.web.servlet;

import fc.io.IOUtil;
import fc.web.servlet.WebUtil;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public final class GzipFileServlet
extends HttpServlet {
    File docroot;
    String d_charset = "text/html; charset=ISO-8859-1";
    String js_content_type = "text/javascript; charset=utf-8";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init();
        ServletContext servletContext = servletConfig.getServletContext();
        ServletContext servletContext2 = servletContext.getContext("/");
        this.docroot = new File(servletContext2.getRealPath("/"));
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("file");
        if (string != null) {
            this.sendFile(string, httpServletRequest, httpServletResponse);
            return;
        }
        String string2 = httpServletRequest.getParameter("js");
        if (string2 != null) {
            this.sendJSFile(string2, httpServletRequest, httpServletResponse);
            return;
        }
        throw new ServletException("Bad request. I need either the \"file\" or the \"jsfile\" parameter.");
    }

    void sendFile(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string2 = WebUtil.getRequiredParam(httpServletRequest, "mimetype");
        String string3 = WebUtil.getRequiredParam(httpServletRequest, "encoding");
        String string4 = string2 + "; charset=" + string3;
        httpServletResponse.setContentType(string4);
        httpServletResponse.setHeader("Content-Encoding", "gzip");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        this.push(servletOutputStream, string);
    }

    void sendJSFile(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType(this.js_content_type);
        httpServletResponse.setHeader("Content-Encoding", "gzip");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        this.push(servletOutputStream, string);
    }

    void push(ServletOutputStream servletOutputStream, String string) throws IOException {
        File file = this.makeFile(string);
        byte[] byArray = IOUtil.fileToByteArray(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)servletOutputStream);
        bufferedOutputStream.write(byArray, 0, byArray.length);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    File makeFile(String object) throws IOException {
        File file;
        if (!((String)object).endsWith(".gz")) {
            object = (String)object + ".gz";
        }
        if (!(file = new File(this.docroot, (String)object)).exists() || !file.isFile()) {
            throw new IOException("\nERROR: file: [" + (String)object + "] not found");
        }
        return file;
    }
}

