/*
 * Decompiled with CFR 0.152.
 */
package fc.web.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;

public abstract class AuthFilter
implements Filter {
    private static final boolean dbg = false;
    boolean use_cookie = true;
    FilterConfig config;
    ServletContext context;
    String login_page;
    String appName;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
        this.context = filterConfig.getServletContext();
        this.login_page = filterConfig.getInitParameter("login_page");
        if (this.login_page == null) {
            throw new ServletException("AuthFilter: the login_page parameter was missing");
        }
        this.appName = filterConfig.getInitParameter("appName");
        if (this.appName == null) {
            throw new ServletException("AuthFilter: the appName parameter was missing");
        }
        String string = filterConfig.getInitParameter("use_cookie");
        if (string != null) {
            this.use_cookie = Boolean.valueOf(string);
        }
    }

    public void destroy() {
        this.config = null;
        this.context = null;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException("Request type was not HTTP/HTTPS");
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        boolean bl = false;
        try {
            bl = this.isUserLoggedIn(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
        if (!bl) {
            this.showLoginPage(httpServletRequest, httpServletResponse);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    protected void showLoginPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        StringBuffer stringBuffer = httpServletRequest.getRequestURL();
        String string = httpServletRequest.getQueryString();
        if (string != null) {
            stringBuffer.append('?');
            stringBuffer.append(string);
        }
        String string2 = URLEncoder.encode(stringBuffer.toString());
        if (this.use_cookie) {
            Cookie cookie = new Cookie("target", string2);
            cookie.setPath("/");
            cookie.setMaxAge(-1);
            httpServletResponse.addCookie(cookie);
        } else {
            this.login_page = this.login_page + "?target=" + string2;
        }
        httpServletResponse.sendRedirect(this.login_page);
    }

    public abstract boolean isUserLoggedIn(HttpServletRequest var1, HttpServletResponse var2) throws Exception;
}

