/*
 * Decompiled with CFR 0.152.
 */
package fc.web.page;

import fc.io.IOUtil;
import fc.util.Argcheck;
import fc.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public final class PageReader
extends Reader {
    static final boolean dbg = false;
    char[] buf = null;
    int pos = 0;
    int count = 0;
    int markpos = 0;
    int line = 1;
    int col = 0;
    int lastcol = 1;
    boolean pushBackNL = false;
    boolean lastWasCR = false;
    String encoding;
    static String DEFAULT_ENCODING = "UTF-8";

    public PageReader(Reader reader) throws IOException {
        Argcheck.notnull(reader, "specified reader was null");
        this.buf = IOUtil.readerToCharArray(reader);
        this.encoding = DEFAULT_ENCODING;
    }

    public PageReader(File file, String string) throws IOException {
        Argcheck.notnull(file, "specified file was null");
        Argcheck.notnull(string, "specified encoding was null");
        this.encoding = string;
        this.buf = IOUtil.fileToCharArray(file, string);
    }

    public PageReader(File file) throws IOException {
        this(file, DEFAULT_ENCODING);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read() throws IOException {
        if (this.pos == this.buf.length) {
            return -1;
        }
        char c = this.buf[this.pos++];
        this.adjustReadLineNum(c);
        return c;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        throw new IOException("not implemented, use the read() method instead");
    }

    public void unread() throws IOException {
        char c = '\u0000';
        if (this.pos == 0) {
            throw new IOException("I am at the beginning of the stream. Cannot unread anything because nothing has been read so far");
        }
        c = this.buf[--this.pos];
        this.adjustUnreadLineNum(c);
    }

    public void unread(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.unread();
        }
    }

    public void insertIntoStream(File file) throws IOException {
        char[] cArray = IOUtil.fileToCharArray(file, this.encoding);
        char[] cArray2 = new char[this.buf.length + cArray.length];
        System.arraycopy(this.buf, 0, cArray2, 0, this.pos);
        System.arraycopy(cArray, 0, cArray2, this.pos, cArray.length);
        System.arraycopy(this.buf, this.pos, cArray2, this.pos + cArray.length, this.buf.length - this.pos);
        this.buf = cArray2;
    }

    public void insertIntoStream(Reader reader) throws IOException {
        char[] cArray = IOUtil.readerToCharArray(reader);
        char[] cArray2 = new char[this.buf.length + cArray.length];
        System.arraycopy(this.buf, 0, cArray2, 0, this.pos);
        System.arraycopy(cArray, 0, cArray2, this.pos, cArray.length);
        System.arraycopy(this.buf, this.pos, cArray2, this.pos + cArray.length, this.buf.length - this.pos);
        this.buf = cArray2;
    }

    void adjustReadLineNum(char c) {
        switch (c) {
            case '\n': {
                if (!this.lastWasCR) {
                    ++this.line;
                    this.lastcol = this.col;
                    this.col = 1;
                    break;
                }
                this.lastWasCR = false;
                break;
            }
            case '\r': {
                ++this.line;
                this.lastcol = this.col;
                this.col = 1;
                this.lastWasCR = true;
                break;
            }
            case '\t': {
                this.col += 4;
                break;
            }
            default: {
                ++this.col;
            }
        }
    }

    void adjustUnreadLineNum(char c) {
        switch (c) {
            case '\n': {
                this.pushBackNL = true;
                --this.line;
                this.col = this.lastcol;
                break;
            }
            case '\r': {
                if (!this.pushBackNL) {
                    --this.line;
                    this.col = this.lastcol;
                    break;
                }
                this.pushBackNL = false;
                break;
            }
            case '\t': {
                this.col -= 4;
                break;
            }
            default: {
                --this.col;
            }
        }
    }

    public int peek() throws IOException {
        return this.buf[this.pos];
    }

    public void skipWhitespace() throws IOException {
        int n = -1;
        while ((n = this.read()) != -1) {
            if (Character.isWhitespace(n)) continue;
            this.unread();
            break;
        }
    }

    public boolean match(int n) throws IOException {
        int n2 = this.read();
        if (n2 == n) {
            return true;
        }
        this.unread();
        return false;
    }

    public boolean match(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Specified target string was null");
        }
        int c = -1;
        for (int i = 0; i < string.length(); ++i) {
            int n = this.read();
            if (n != -1 && n == string.charAt(i)) continue;
            this.unread(i + 1);
            return false;
        }
        return true;
    }

    public boolean matchIgnoreCase(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Specified target string was null");
        }
        int c = -1;
        for (int i = 0; i < string.length(); ++i) {
            int n = this.read();
            if (n != -1 && n == Character.toLowerCase(string.charAt(i))) continue;
            this.unread(i + 1);
            return false;
        }
        return true;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    char[] getBuf() {
        return this.buf;
    }

    int getPos() {
        return this.pos;
    }

    public static void main(String[] stringArray) throws IOException {
        StringReader stringReader;
        StringReader stringReader2 = null;
        PageReader pageReader = null;
        int n = -1;
        System.out.println("Reading an empty string.....");
        stringReader2 = new StringReader("");
        pageReader = new PageReader(stringReader2);
        while ((n = pageReader.read()) != -1) {
            PageReader.testprint(pageReader, n);
        }
        System.out.println("----------------- TEST 2 --------------");
        stringReader2 = new StringReader("abc");
        pageReader = new PageReader(stringReader2);
        while ((n = pageReader.read()) != -1) {
            PageReader.testprint(pageReader, n);
        }
        System.out.println("----------------- TEST 3 --------------");
        stringReader2 = new StringReader("abcde");
        pageReader = new PageReader(stringReader2);
        try {
            n = pageReader.read();
            PageReader.testprint(pageReader, n);
            pageReader.unread();
            PageReader.testprint(pageReader, -10);
            pageReader.unread();
            PageReader.testprint(pageReader, -10);
            n = pageReader.read();
            PageReader.testprint(pageReader, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("----------------- TEST 4 --------------");
        stringReader2 = new StringReader("abcd\ne");
        pageReader = new PageReader(stringReader2);
        try {
            int n2;
            n = pageReader.read();
            PageReader.testprint(pageReader, n);
            pageReader.unread();
            PageReader.testprint(pageReader, -10);
            for (n2 = 0; n2 < 5; ++n2) {
                n = pageReader.read();
                PageReader.testprint(pageReader, n);
            }
            for (n2 = 0; n2 < 5; ++n2) {
                pageReader.unread();
                PageReader.testprint(pageReader, -10);
            }
            for (n2 = 0; n2 < 5; ++n2) {
                n = pageReader.read();
                PageReader.testprint(pageReader, n);
            }
            n = pageReader.read();
            PageReader.testprint(pageReader, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("----------------- TEST 5 --------------");
        stringReader2 = new StringReader("abcd\r\ne");
        pageReader = new PageReader(stringReader2);
        try {
            int n3;
            n = pageReader.read();
            PageReader.testprint(pageReader, n, pageReader.peek());
            pageReader.unread();
            PageReader.testprint(pageReader, -10, pageReader.peek());
            for (n3 = 0; n3 < 5; ++n3) {
                n = pageReader.read();
                PageReader.testprint(pageReader, n, pageReader.peek());
            }
            for (n3 = 0; n3 < 5; ++n3) {
                pageReader.unread();
                PageReader.testprint(pageReader, -10, pageReader.peek());
            }
            for (n3 = 0; n3 < 5; ++n3) {
                n = pageReader.read();
                PageReader.testprint(pageReader, n, pageReader.peek());
            }
            n = pageReader.read();
            PageReader.testprint(pageReader, n, pageReader.peek());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("--------- TEST 6 ---(insert into stream middle)-------");
        stringReader2 = new StringReader("abc");
        pageReader = new PageReader(stringReader2);
        try {
            n = pageReader.read();
            PageReader.testprint(pageReader, n);
            stringReader = new StringReader("123");
            System.out.println("inserting \"123\" into the stream\n");
            pageReader.insertIntoStream(stringReader);
            while ((n = pageReader.read()) != -1) {
                PageReader.testprint(pageReader, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("--------- TEST 7 ---(insert into stream begin)-------");
        stringReader2 = new StringReader("abc");
        pageReader = new PageReader(stringReader2);
        try {
            stringReader = new StringReader("123");
            System.out.println("inserting \"123\" into the beginning of stream\n");
            pageReader.insertIntoStream(stringReader);
            while ((n = pageReader.read()) != -1) {
                PageReader.testprint(pageReader, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("--------- TEST 8 ---(insert into stream end)-------");
        stringReader2 = new StringReader("abc");
        pageReader = new PageReader(stringReader2);
        try {
            while ((n = pageReader.read()) != -1) {
                PageReader.testprint(pageReader, n);
            }
            stringReader = new StringReader("123");
            System.out.println("inserting \"123\" into the end of the stream\n");
            pageReader.insertIntoStream(stringReader);
            while ((n = pageReader.read()) != -1) {
                PageReader.testprint(pageReader, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void testprint(PageReader pageReader, int n, int n2) {
        if (n == -1) {
            System.out.println("====> recieved EOF (-1) from read().......");
        }
        System.out.format("buf=%s, pos=%d, buflen=%d\nline=%d, col=%d, char=[%s]", StringUtil.arrayToString(pageReader.getBuf()), pageReader.getPos(), pageReader.getBuf().length, pageReader.getLine(), pageReader.getCol(), n == -10 ? "N/A" : StringUtil.viewableAscii((char)n));
        if (n2 != -2) {
            System.out.format(", peek=[%s]", StringUtil.viewableAscii((char)n2));
        }
        System.out.print("\n\n");
    }

    private static void testprint(PageReader pageReader, int n) {
        PageReader.testprint(pageReader, n, -2);
    }
}

