/*
 * Decompiled with CFR 0.152.
 */
package fc.web.page;

import fc.io.IOUtil;
import fc.io.Log;
import fc.util.Argcheck;
import fc.util.Args;
import fc.util.StringUtil;
import fc.web.page.PageReader;
import fc.web.page.ParseException;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PageParser {
    private static final boolean dbg = false;
    private static final int EOF = -1;
    private int dbgtab = 0;
    String classname;
    String packagename = "molly.pages";
    PageReader in;
    PrintWriter out;
    Log log;
    File inputFile;
    File outputFile;
    File contextRoot;
    boolean includeMode = false;
    String src_encoding;
    int textNodeCounter = 0;
    CharArrayWriter buf = new CharArrayWriter(4096);
    CharArrayWriter wsbuf = new CharArrayWriter(32);
    int c = -1;
    List decl = new ArrayList();
    List inc_decl = new ArrayList();
    List imps = new ArrayList();
    List tree = new ArrayList();
    Map directives = new HashMap();
    Set circularityTrack = new HashSet();
    public static String d_mimetype = "mimetype";
    public static String mimetype_none = "none";
    public static String d_encoding = "encoding";
    public static String d_src_encoding = "src-encoding";
    public static String d_buffersize = "buffersize";
    public static String d_out = "out";
    public static String d_out_stream1 = "outputstream";
    public static String d_out_stream2 = "stream";
    public static String d_out_writer = "writer";
    public static String d_remove_initial_whitespace = "remove-initial-whitespace";
    private static final int MAX_TEXT_LITERAL_LENGTH = 32772;
    static final Pattern directive_pat = Pattern.compile("\\s*([a-zA-Z_\\-0-9]+)\\s*=\\s*\"((?:.|\r|\n)+?)\"|\\s*([a-zA-Z_\\-0-9]+)\\s*=\\s*(\\S+)");
    final String whiteSpaceOnlyPat = "^(\\\\n(?<!\\\\)|\\\\r(?<!\\\\)|\\\\t(?<!\\\\)| )*$";
    final String whiteSpaceBeginPat = "^(\\\\n(?<!\\\\)|\\\\r(?<!\\\\)|\\\\t(?<!\\\\)| )*";

    private PageParser(File file, File file2, PrintWriter printWriter, String string, Log log) throws IOException {
        this.contextRoot = file;
        this.inputFile = file2;
        this.in = new PageReader(file2);
        this.out = printWriter;
        this.classname = string;
        this.log = log;
        this.circularityTrack.add(file2.getAbsolutePath());
    }

    public PageParser(File file, File file2, File file3, String string) throws IOException {
        this(file, file2, file3, string, (Log)Log.getDefault());
    }

    public PageParser(File file, File file2, File file3, String string, Log log) throws IOException {
        this.contextRoot = file;
        this.inputFile = file2;
        this.in = new PageReader(file2);
        this.outputFile = file3;
        this.classname = string;
        this.log = log;
        this.circularityTrack.add(file2.getAbsolutePath());
    }

    void append(int n) {
        Argcheck.istrue(n >= 0, "Internal error: recieved c=" + n);
        this.buf.append((char)n);
    }

    void append(char c) {
        this.buf.append(c);
    }

    void append(String string) {
        this.buf.append(string);
    }

    PageParser includeMode() {
        this.includeMode = true;
        return this;
    }

    public void parse() throws IOException {
        this.parseText();
        if (!this.includeMode) {
            this.writePage();
            this.out.close();
        } else {
            this.out.flush();
        }
        this.in.close();
    }

    private Text newTextNode() {
        Text text = new Text(this, this.buf);
        this.tree.add(text);
        this.buf.reset();
        return text;
    }

    void parseText() throws IOException {
        block4: while (true) {
            this.c = this.in.read();
            if (this.c == -1) break;
            switch (this.c) {
                case 92: {
                    if (this.in.match("[")) {
                        this.append("[");
                        continue block4;
                    }
                    this.append(this.c);
                    continue block4;
                }
                case 91: {
                    if (this.in.match(91)) {
                        this.newTextNode();
                        this.parseCode();
                        continue block4;
                    }
                    if (this.in.match(61)) {
                        Text text = this.newTextNode();
                        this.parseExpression(text);
                        continue block4;
                    }
                    if (this.in.match(33)) {
                        this.newTextNode();
                        this.parseDeclaration();
                        continue block4;
                    }
                    if (this.in.match("/*")) {
                        this.newTextNode();
                        this.parseComment();
                        continue block4;
                    }
                    if (this.in.matchIgnoreCase("page")) {
                        this.newTextNode();
                        this.parseDirective();
                        continue block4;
                    }
                    if (this.in.matchIgnoreCase("include-file")) {
                        this.newTextNode();
                        this.parseIncludeFile();
                        continue block4;
                    }
                    if (this.in.matchIgnoreCase("include-decl")) {
                        this.newTextNode();
                        this.parseIncludeDecl();
                        continue block4;
                    }
                    if (this.in.matchIgnoreCase("include")) {
                        this.newTextNode();
                        this.parseInclude();
                        continue block4;
                    }
                    if (this.in.matchIgnoreCase("forward")) {
                        this.newTextNode();
                        this.parseForward();
                        continue block4;
                    }
                    if (this.in.matchIgnoreCase("import")) {
                        this.newTextNode();
                        this.parseImport();
                        continue block4;
                    }
                    this.append(this.c);
                    continue block4;
                }
            }
            this.append(this.c);
        }
        this.tree.add(new Text(this, this.buf));
        this.buf.reset();
    }

    void parseCode() throws IOException {
        int n = this.in.getLine();
        int n2 = this.in.getCol();
        block9: while (true) {
            this.c = this.in.read();
            switch (this.c) {
                case -1: {
                    this.unclosed("code", n, n2);
                    return;
                }
                case 47: {
                    this.append(this.c);
                    this.c = this.in.read();
                    this.append(this.c);
                    if (this.c == 47) {
                        this.appendCodeSlashComment();
                        continue block9;
                    }
                    if (this.c != 42) continue block9;
                    this.appendCodeStarComment();
                    continue block9;
                }
                case 34: {
                    this.append(this.c);
                    this.appendCodeString();
                    continue block9;
                }
                case 39: {
                    this.append(this.c);
                    this.appendCodeCharLiteral();
                    continue block9;
                }
                case 93: {
                    if (this.in.match(93)) {
                        this.tree.add(new Code(this, this.buf));
                        this.buf.reset();
                        return;
                    }
                    this.append(this.c);
                    continue block9;
                }
                case 10: 
                case 13: {
                    this.append(this.c);
                    this.readToFirstNonWS();
                    this.c = this.in.read();
                    if (this.c == 35) {
                        this.tree.add(new Code(this, this.buf));
                        this.buf.reset();
                        this.parseHash(this.wsbuf.toString());
                        continue block9;
                    }
                    this.append(this.wsbuf.toString());
                    this.in.unread();
                    continue block9;
                }
                case 35: {
                    this.tree.add(new Code(this, this.buf));
                    this.buf.reset();
                    this.parseHash(null);
                    continue block9;
                }
            }
            this.append(this.c);
        }
    }

    void parseHash(String string) throws IOException {
        int n = this.in.getLine();
        int n2 = this.in.getCol();
        block8: while (true) {
            this.c = this.in.read();
            switch (this.c) {
                case -1: {
                    this.unclosed("hash", n, n2);
                    return;
                }
                case 34: 
                case 39: {
                    this.append(this.c);
                    if (!this.in.match(35)) continue block8;
                    this.append('#');
                    continue block8;
                }
                case 92: {
                    if (this.in.match(91)) {
                        this.append('[');
                        continue block8;
                    }
                    if (this.in.match(35)) {
                        this.append('#');
                        continue block8;
                    }
                    this.append(this.c);
                    continue block8;
                }
                case 91: {
                    if (this.in.match(61)) {
                        Hash hash = new Hash(this, string, this.buf);
                        this.tree.add(hash);
                        this.buf.reset();
                        this.parseExpression(hash);
                        continue block8;
                    }
                    this.append(this.c);
                    continue block8;
                }
                case 10: 
                case 13: {
                    this.append(this.c);
                    this.readToFirstNonWS();
                    this.c = this.in.read();
                    if (this.c == 35) {
                        this.tree.add(new Hash(this, string, this.buf));
                        this.buf.reset();
                        return;
                    }
                    this.append(this.wsbuf.toString());
                    this.in.unread();
                    continue block8;
                }
                case 35: {
                    this.tree.add(new Hash(this, string, this.buf));
                    this.buf.reset();
                    return;
                }
            }
            this.append(this.c);
        }
    }

    void parseHeredoc(StringBuilder stringBuilder) throws IOException {
        int n = this.in.getLine();
        int n2 = this.in.getCol();
        int n3 = stringBuilder.indexOf("<<<");
        String string = stringBuilder.substring(n3 + 3, stringBuilder.length());
        String string2 = string.toString().trim();
        int n4 = string2.length();
        CharArrayWriter charArrayWriter = new CharArrayWriter(2048);
        while (true) {
            this.c = this.in.read();
            if (this.c == -1) {
                this.unclosed("heredoc: <<<" + string2, n, n2);
                break;
            }
            if (this.c == string2.charAt(0)) {
                boolean bl = true;
                if (n4 > 1) {
                    bl = this.in.match(string2.substring(1));
                }
                if (bl) {
                    this.tree.add(new Heredoc(this, charArrayWriter));
                    break;
                }
            }
            charArrayWriter.append((char)this.c);
        }
    }

    void parseExpression(Element element) throws IOException {
        int n = this.in.getLine();
        int n2 = this.in.getCol();
        block5: while (true) {
            this.c = this.in.read();
            switch (this.c) {
                case -1: {
                    this.unclosed("expression", n, n2);
                    return;
                }
                case 92: {
                    if (this.in.match(93)) {
                        this.append(']');
                        continue block5;
                    }
                    this.append(this.c);
                    continue block5;
                }
                case 93: {
                    if (this.buf.toString().trim().length() == 0) {
                        this.error("Empty expression not allowed", n, n2);
                    }
                    element.addExp(new Exp(this, this.buf));
                    this.buf.reset();
                    return;
                }
            }
            this.append(this.c);
        }
    }

    void parseComment() throws IOException {
        int n = this.in.getLine();
        int n2 = this.in.getCol();
        block4: while (true) {
            this.c = this.in.read();
            switch (this.c) {
                case -1: {
                    this.unclosed("comment", n, n2);
                    return;
                }
                case 42: {
                    if (this.in.match("/]")) {
                        this.tree.add(new Comment(this, this.buf));
                        this.buf.reset();
                        return;
                    }
                    this.append(this.c);
                    continue block4;
                }
            }
            this.append(this.c);
        }
    }

    void parseDeclaration() throws IOException {
        int n = this.in.getLine();
        int n2 = this.in.getCol();
        block7: while (true) {
            this.c = this.in.read();
            switch (this.c) {
                case -1: {
                    this.unclosed("declaration", n, n2);
                    return;
                }
                case 33: {
                    if (this.in.match(93)) {
                        this.decl.add(new Decl(this, this.buf));
                        this.buf.reset();
                        return;
                    }
                    this.append(this.c);
                    continue block7;
                }
                case 47: {
                    this.append(this.c);
                    this.c = this.in.read();
                    this.append(this.c);
                    if (this.c == 47) {
                        this.appendCodeSlashComment();
                        continue block7;
                    }
                    if (this.c != 42) continue block7;
                    this.appendCodeStarComment();
                    continue block7;
                }
                case 34: {
                    this.append(this.c);
                    this.appendCodeString();
                    continue block7;
                }
                case 39: {
                    this.append(this.c);
                    this.appendCodeCharLiteral();
                    continue block7;
                }
            }
            this.append(this.c);
        }
    }

    void parseDirective() throws IOException {
        int n = this.in.getLine();
        int n2 = this.in.getCol();
        StringBuilder stringBuilder = new StringBuilder(1024);
        while (true) {
            this.c = this.in.read();
            switch (this.c) {
                case -1: {
                    this.unclosed("directive", n, n2);
                    return;
                }
                case 93: {
                    if (stringBuilder.indexOf("<<<") >= 0) {
                        this.parseHeredoc(stringBuilder);
                    } else {
                        this.addDirectives(stringBuilder);
                    }
                    return;
                }
            }
            stringBuilder.append((char)this.c);
        }
    }

    void addDirectives(StringBuilder stringBuilder) throws ParseException {
        try {
            Matcher matcher = directive_pat.matcher(stringBuilder);
            while (matcher.find()) {
                String string;
                String string2 = matcher.group(1) != null ? matcher.group(1).toLowerCase() : matcher.group(3).toLowerCase();
                String string3 = string = matcher.group(2) != null ? matcher.group(2).toLowerCase() : matcher.group(4).toLowerCase();
                if (string2.equals(d_buffersize)) {
                    this.directives.put(string2, IOUtil.stringToFileSize(string.replace("\"|'", "")));
                    continue;
                }
                if (string2.equals(d_encoding)) {
                    this.directives.put(string2, string.replace("\"|'", ""));
                    continue;
                }
                if (string2.equals(d_src_encoding)) {
                    this.directives.put(string2, string.replace("\"|'", ""));
                    continue;
                }
                if (string2.equals(d_mimetype)) {
                    this.directives.put(string2, string.replace("\"|'", ""));
                    continue;
                }
                if (string2.equals(d_out)) {
                    this.directives.put(string2, string.replace("\"|'", ""));
                    continue;
                }
                if (string2.equals(d_remove_initial_whitespace)) {
                    this.directives.put(string2, string.replace("\"|'", ""));
                    continue;
                }
                throw new Exception("Do not understand directive: " + matcher.group());
            }
        }
        catch (Exception exception) {
            throw new ParseException("File: " + this.inputFile.getAbsolutePath() + ";\n" + exception.toString());
        }
    }

    void parseIncludeFile() throws IOException {
        int n = this.in.getLine();
        int n2 = this.in.getCol();
        String string = null;
        block6: while (true) {
            this.c = this.in.read();
            switch (this.c) {
                case -1: {
                    this.unclosed("include-file", n, n2);
                    return;
                }
                case 91: {
                    if (this.in.match(61)) {
                        this.error("Expressions cannot exist in file includes. The offending static-include section starts at:", n, n2);
                    }
                    this.append(this.c);
                    continue block6;
                }
                case 93: {
                    this.includeFile(this.buf, string);
                    this.buf.reset();
                    return;
                }
                case 111: {
                    if (!this.in.match("ption")) {
                        this.append(this.c);
                        continue block6;
                    }
                    this.skipWS();
                    if (!this.in.match("=")) {
                        this.error("bad option parameter in file include: ", n, n2);
                    }
                    this.skipWS();
                    StringBuilder stringBuilder = new StringBuilder();
                    while (true) {
                        int n3;
                        if ((n3 = this.in.read()) == 93 || n3 == -1 || Character.isWhitespace(n3)) break;
                        stringBuilder.append((char)n3);
                    }
                    this.in.unread();
                    string = stringBuilder.toString();
                    continue block6;
                }
            }
            this.append(this.c);
        }
    }

    void parseIncludeDecl() throws IOException {
        int n = this.in.getLine();
        int n2 = this.in.getCol();
        String string = null;
        block6: while (true) {
            this.c = this.in.read();
            switch (this.c) {
                case -1: {
                    this.unclosed("include-decl", n, n2);
                    return;
                }
                case 91: {
                    if (this.in.match(61)) {
                        this.error("Expressions cannot exist in include-decl. The offending static-include section starts at:", n, n2);
                    }
                    this.append(this.c);
                    continue block6;
                }
                case 93: {
                    IncludeDecl includeDecl = new IncludeDecl(this, this.buf);
                    if (string != null) {
                        includeDecl.setOption(string);
                    }
                    this.inc_decl.add(includeDecl);
                    this.buf.reset();
                    return;
                }
                case 111: {
                    if (!this.in.match("ption")) {
                        this.append(this.c);
                        continue block6;
                    }
                    this.skipWS();
                    if (!this.in.match("=")) {
                        this.error("bad option parameter in include-code: ", n, n2);
                    }
                    this.skipWS();
                    StringBuilder stringBuilder = new StringBuilder();
                    while (true) {
                        int n3;
                        if ((n3 = this.in.read()) == 93 || n3 == -1 || Character.isWhitespace(n3)) break;
                        stringBuilder.append((char)n3);
                    }
                    this.in.unread();
                    string = stringBuilder.toString();
                    continue block6;
                }
            }
            this.append(this.c);
        }
    }

    void parseInclude() throws IOException {
        int n = this.in.getLine();
        int n2 = this.in.getCol();
        Include include = new Include(this);
        block5: while (true) {
            this.c = this.in.read();
            switch (this.c) {
                case -1: {
                    this.unclosed("include", n, n2);
                    return;
                }
                case 91: {
                    if (this.in.match(61)) {
                        include.add(this.buf);
                        this.buf.reset();
                        this.parseExpression(include);
                        continue block5;
                    }
                    this.append(this.c);
                    continue block5;
                }
                case 93: {
                    include.add(this.buf);
                    this.tree.add(include);
                    this.buf.reset();
                    return;
                }
            }
            this.append(this.c);
        }
    }

    void parseForward() throws IOException {
        int n = this.in.getLine();
        int n2 = this.in.getCol();
        Forward forward = new Forward(this);
        block5: while (true) {
            this.c = this.in.read();
            switch (this.c) {
                case -1: {
                    this.unclosed("forward", n, n2);
                    return;
                }
                case 91: {
                    if (this.in.match(61)) {
                        forward.add(this.buf);
                        this.buf.reset();
                        this.parseExpression(forward);
                        continue block5;
                    }
                    this.append(this.c);
                    continue block5;
                }
                case 93: {
                    forward.add(this.buf);
                    this.tree.add(forward);
                    this.buf.reset();
                    return;
                }
            }
            this.append(this.c);
        }
    }

    void parseImport() throws IOException {
        int n = this.in.getLine();
        int n2 = this.in.getCol();
        block5: while (true) {
            this.c = this.in.read();
            switch (this.c) {
                case -1: {
                    this.unclosed("import", n, n2);
                    return;
                }
                case 10: {
                    this.imps.add(new Import(this, this.buf));
                    this.buf.reset();
                    continue block5;
                }
                case 93: {
                    this.imps.add(new Import(this, this.buf));
                    this.buf.reset();
                    return;
                }
            }
            this.append(this.c);
        }
    }

    void appendCodeSlashComment() throws IOException {
        while (true) {
            this.c = this.in.read();
            if (this.c == -1) break;
            if (this.c == 13) {
                this.in.unread();
                break;
            }
            if (this.c == 10) {
                this.in.unread();
                break;
            }
            this.append(this.c);
        }
    }

    void appendCodeStarComment() throws IOException {
        block1: {
            do {
                this.c = this.in.read();
                if (this.c == -1) break block1;
                this.append(this.c);
            } while (this.c != 42 || !this.in.match(47));
            this.append('/');
        }
    }

    void appendCodeString() throws IOException {
        int n = this.in.getLine();
        int n2 = this.in.getCol();
        while (true) {
            this.c = this.in.read();
            if (this.c == -1 || this.c == 13 || this.c == 10) {
                this.unclosed("string literal", n, n2);
            }
            this.append(this.c);
            if (this.c == 92) {
                this.c = this.in.read();
                if (this.c == -1) {
                    this.unclosed("string literal", n, n2);
                } else {
                    this.append(this.c);
                    continue;
                }
            }
            if (this.c == 34) break;
        }
    }

    void appendCodeCharLiteral() throws IOException {
        int n = this.in.getLine();
        int n2 = this.in.getCol();
        while (true) {
            this.c = this.in.read();
            if (this.c == -1 || this.c == 13 || this.c == 10) {
                this.unclosed("char literal", n, n2);
            }
            this.append(this.c);
            if (this.c == 92) {
                this.c = this.in.read();
                if (this.c == -1) {
                    this.unclosed("char literal", n, n2);
                } else {
                    this.append(this.c);
                    continue;
                }
            }
            if (this.c == 39) break;
        }
    }

    void readToFirstNonWS() throws IOException {
        this.wsbuf.reset();
        while (true) {
            this.c = this.in.read();
            if (this.c == 13 || this.c == 10 || this.c == -1 || !Character.isWhitespace(this.c)) break;
            this.wsbuf.append((char)this.c);
        }
        this.in.unread();
    }

    void skipWS() throws IOException {
        int n = -1;
        while ((n = this.in.read()) != -1 && Character.isWhitespace(n)) {
        }
        this.in.unread();
    }

    void skipIfWhitespaceToEnd() throws IOException {
        int n = 0;
        do {
            this.c = this.in.read();
            ++n;
            if (this.c == 13) {
                this.in.match(10);
                return;
            }
            if (this.c != 10 && this.c != -1) continue;
            return;
        } while (Character.isWhitespace(this.c));
        this.in.unread(n);
    }

    void skipToLineEnd() throws IOException {
        block1: {
            int n;
            do {
                if ((n = this.in.read()) != -1) continue;
                this.in.unread();
                break block1;
            } while (n != 10 && n != 13);
            this.in.unread();
        }
    }

    String quote(char c) {
        switch (c) {
            case '\r': {
                return "\\r";
            }
            case '\n': {
                return "\\n";
            }
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return String.valueOf(c);
    }

    String methodName(int n) {
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElementArray[n];
        String string = stackTraceElement.getFileName();
        int n2 = stackTraceElement.getLineNumber();
        String string2 = stackTraceElement.getMethodName();
        String string3 = Thread.currentThread().getName();
        return string2 + "()";
    }

    void dbgenter() {
        System.out.format("%s-->%s\n", StringUtil.repeat('\t', this.dbgtab++), this.methodName(2));
    }

    void dbgexit() {
        System.out.format("%s<--%s\n", StringUtil.repeat('\t', --this.dbgtab), this.methodName(2));
    }

    void dbgread(String string) {
        System.out.format("%s %s\n", StringUtil.repeat('\t', this.dbgtab), StringUtil.viewableAscii(string));
    }

    void dbgread(String string, List list) {
        System.out.format("%s %s: ", StringUtil.repeat('\t', this.dbgtab), StringUtil.viewableAscii(string));
        for (int i = 0; i < list.size(); ++i) {
            System.out.print(StringUtil.viewableAscii((String)list.get(i)));
        }
        System.out.println("");
    }

    void dbgread(char c) {
        System.out.format("%s %s\n", StringUtil.repeat('\t', this.dbgtab), StringUtil.viewableAscii(c));
    }

    void dbgread(CharArrayWriter charArrayWriter) {
        System.out.format("%s %s\n", StringUtil.repeat('\t', this.dbgtab), StringUtil.viewableAscii(charArrayWriter.toString()));
    }

    void unclosed(String string, int n, int n2) throws IOException {
        throw new IOException(string + " tag not closed.\nThis tag was possibly opened in: \nFile:" + String.valueOf(this.inputFile) + ", line:" + n + " column:" + n2 + ".\nCurrent line:" + this.in.getLine() + " column:" + this.in.getCol());
    }

    void error(String string, int n, int n2) throws IOException {
        throw new IOException("Error in File:" + String.valueOf(this.inputFile) + " Line:" + n + " Col:" + n2 + " " + string);
    }

    void error(String string) throws IOException {
        throw new IOException("Error in File:" + String.valueOf(this.inputFile) + " " + string);
    }

    void o(Object object) {
        this.out.print(object);
    }

    void ol(Object object) {
        this.out.println(object);
    }

    void ol() {
        this.out.println();
    }

    String getSourceEncoding() {
        return this.src_encoding;
    }

    void includeFile(CharArrayWriter charArrayWriter, String string) throws IOException {
        String string2 = PageParser.removeLeadingTrailingQuote(charArrayWriter.toString().trim());
        File file = null;
        File file2 = this.inputFile.getParentFile();
        if (file2 == null) {
            file2 = new File(".");
        }
        if (!(file = string2.startsWith("/") ? new File(this.contextRoot, string2) : new File(file2, string2)).exists()) {
            throw new IOException("Include file does not exist: " + file.getCanonicalPath());
        }
        if (this.circularityTrack.contains(file.getAbsolutePath())) {
            throw new IOException("Circularity detected when including: " + file.getCanonicalPath() + "\nAlready included the following files: " + String.valueOf(this.circularityTrack));
        }
        this.tree.add(new MollyComment(this, "//>>>START INCLUDE from: " + file.getAbsolutePath()));
        this.in.insertIntoStream(file);
        this.circularityTrack.add(file.getAbsolutePath());
    }

    void writePage() throws IOException {
        if (!this.includeMode) {
            if (this.directives.containsKey(d_src_encoding)) {
                this.src_encoding = (String)this.directives.get(d_src_encoding);
                this.src_encoding = PageParser.removeLeadingTrailingQuote(this.src_encoding);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.outputFile);
            OutputStreamWriter outputStreamWriter = this.src_encoding != null ? new OutputStreamWriter((OutputStream)fileOutputStream, this.src_encoding) : new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            this.out = new PrintWriter(new BufferedWriter(outputStreamWriter));
        }
        if (!this.includeMode) {
            this.writePackage();
            this.writeImports();
            this.o("public class ");
            this.o(this.classname);
            this.ol(" extends fc.web.page.PageImpl");
            this.ol("{");
        }
        this.writeFields();
        if (!this.includeMode) {
            this.writeConstructor();
        }
        this.writeMethods();
        if (!this.includeMode) {
            this.ol("}");
        }
    }

    void writePackage() {
        this.o("package ");
        this.o(this.packagename);
        this.ol(";");
        this.ol();
    }

    void writeImports() throws IOException {
        this.ol("import jakarta.servlet.*;");
        this.ol("import jakarta.servlet.http.*;");
        this.ol("import java.io.*;");
        this.ol("import java.util.*;");
        this.ol("import fc.web.page.PageServlet;");
        for (int i = 0; i < this.imps.size(); ++i) {
            ((Element)this.imps.get(i)).render();
            this.ol();
        }
        this.ol();
    }

    void writeFields() {
    }

    void writeConstructor() {
    }

    void writeMethods() throws IOException {
        this.writeDeclaredMethods();
        this.writeIncludedMethods();
        this.writeRenderMethod();
    }

    void writeDeclaredMethods() throws IOException {
        for (int i = 0; i < this.decl.size(); ++i) {
            ((Element)this.decl.get(i)).render();
        }
        if (this.decl.size() > 0) {
            this.ol();
        }
    }

    void writeIncludedMethods() throws IOException {
        for (int i = 0; i < this.inc_decl.size(); ++i) {
            ((Element)this.inc_decl.get(i)).render();
        }
        if (this.inc_decl.size() > 0) {
            this.ol();
        }
    }

    void writeRenderMethod() throws IOException {
        if (!this.includeMode) {
            this.writeRenderTop();
        }
        boolean bl = this.directives.containsKey(d_remove_initial_whitespace);
        boolean bl2 = false;
        for (int i = 0; i < this.tree.size(); ++i) {
            Element element = (Element)this.tree.get(i);
            if (element instanceof Text) {
                Text text = (Text)element;
                if (bl && !bl2) {
                    if (text.isOnlyWhiteSpaceNode()) {
                        text.clear();
                    } else {
                        text.removeInitialEmptyLines();
                        bl2 = true;
                    }
                }
            }
            element.render();
        }
        if (!this.includeMode) {
            this.writeRenderBottom();
        }
    }

    void writeRenderTop() throws IOException {
        String string;
        this.ol("public void render(HttpServletRequest req, HttpServletResponse res) throws Exception");
        this.ol("\t{");
        this.ol("\t/* for people used to typing 'request/response' */");
        this.ol("\tfinal HttpServletRequest  request = req;");
        this.ol("\tfinal HttpServletResponse response = res;");
        this.ol();
        Object object = "";
        if (this.directives.containsKey(d_mimetype)) {
            string = (String)this.directives.get(d_mimetype);
            if (!string.equals("") && !string.equals(mimetype_none)) {
                string = PageParser.removeLeadingTrailingQuote(string);
                object = (String)object + string;
            }
        } else {
            object = (String)object + "text/html";
        }
        if (this.directives.containsKey(d_encoding)) {
            string = (String)this.directives.get(d_encoding);
            if (!(string = PageParser.removeLeadingTrailingQuote(string)).trim().equals("")) {
                object = (String)object + "; charset=";
                object = (String)object + string;
            }
        } else {
            object = (String)object + "; charset=";
            object = (String)object + "UTF-8";
        }
        this.o("\tres.setContentType(\"");
        this.o(object);
        this.ol("\");");
        if (this.directives.containsKey(d_buffersize)) {
            this.o("\tres.setBufferSize(");
            this.o(this.directives.get(d_buffersize));
            this.ol(");");
        }
        boolean bl = false;
        if (this.directives.containsKey(d_out)) {
            String string2 = ((String)this.directives.get(d_out)).toLowerCase().intern();
            if (string2 == d_out_stream1 || string2 == d_out_stream2) {
                bl = true;
            } else if (string2 == d_out_writer) {
                bl = false;
            } else {
                this.error("Did not understand directive [directive name=out, value=" + string2 + "]. Choose between (" + d_out_stream1 + ") and (" + d_out_writer + ")");
            }
        }
        if (bl) {
            this.ol("\tServletOutputStream out = res.getOutputStream();");
        } else {
            this.ol("\tPrintWriter out = res.getWriter();");
        }
    }

    void writeRenderBottom() throws IOException {
        this.ol();
        this.ol("\t} //~render end");
    }

    private static String removeLeadingTrailingQuote(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("\"") || string.startsWith("'")) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith("\"") || string.endsWith("'")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static void main(String[] stringArray) throws IOException {
        Args args = new Args(stringArray);
        args.setUsage("java " + args.getMainClassName() + "\nRequired params:\n     -classname output_class_name\n     -in        input_page_file\n\nOptional params:\n     -encoding    <page_encoding>\n     -contextRoot <webapp root-directory or any other directory>\n        this directory is used as the starting directory for absolute (starting\n        with a \"/\") include/forward directives in a page>. If not specified\n        defaults to the same directory as the page file\n     -out <output_file_name>\n        the output file is optional and defaults to the standard out if not specified.");
        File file = new File(args.getRequired("in"));
        File file2 = null;
        file2 = args.flagExists("contextRoot") ? new File(args.get("contextRoot")) : file;
        PrintWriter printWriter = args.get("out") != null ? new PrintWriter(new FileWriter(args.get("out"))) : new PrintWriter(new OutputStreamWriter(System.out));
        PageParser pageParser = new PageParser(file2, file, printWriter, args.getRequired("classname"), (Log)Log.getDefault());
        pageParser.parse();
    }

    class Text
    extends Element {
        String offset_space;
        final List list;
        int nodeNumber;
        final /* synthetic */ PageParser this$0;

        Text(PageParser pageParser, String string, CharArrayWriter charArrayWriter) {
            PageParser pageParser2 = pageParser;
            Objects.requireNonNull(pageParser2);
            this.this$0 = pageParser2;
            super(pageParser);
            this.list = new ArrayList();
            this.nodeNumber = this.this$0.textNodeCounter++;
            this.offset_space = string == null ? "\t" : "\t" + string;
            char[] cArray = charArrayWriter.toCharArray();
            boolean bl = false;
            CharArrayWriter charArrayWriter2 = new CharArrayWriter(256);
            int n = 0;
            int n2 = 0;
            int n3 = 1;
            while (n2 < cArray.length) {
                char c = cArray[n2];
                if (++n > 32772 || n3 == cArray.length) {
                    charArrayWriter2.append(pageParser.quote(c));
                    this.list.add(charArrayWriter2.toString());
                    charArrayWriter2.reset();
                    n = 0;
                } else if (c == '\n') {
                    charArrayWriter2.append(pageParser.quote(c));
                    if (!bl) {
                        this.list.add(charArrayWriter2.toString());
                        charArrayWriter2.reset();
                        n = 0;
                    }
                } else if (c == '\r') {
                    charArrayWriter2.append(pageParser.quote(c));
                    this.list.add(charArrayWriter2.toString());
                    charArrayWriter2.reset();
                    n = 0;
                    bl = true;
                } else {
                    charArrayWriter2.append(pageParser.quote(c));
                    bl = false;
                }
                ++n2;
                ++n3;
            }
        }

        Text(PageParser pageParser, CharArrayWriter charArrayWriter) {
            this(pageParser, null, charArrayWriter);
        }

        @Override
        void addExp(Exp exp) {
            this.list.add(exp);
        }

        @Override
        void render() {
            for (int i = 0; i < this.list.size(); ++i) {
                Object e = this.list.get(i);
                if (e instanceof Exp) {
                    this.this$0.o(this.offset_space);
                    ((Exp)e).render();
                    continue;
                }
                this.this$0.o(this.offset_space);
                this.this$0.o("out.print  (\"");
                this.this$0.o(e);
                this.this$0.ol("\");");
            }
        }

        boolean isOnlyWhiteSpaceLine(String string) {
            return string.matches("^(\\\\n(?<!\\\\)|\\\\r(?<!\\\\)|\\\\t(?<!\\\\)| )*$");
        }

        boolean isOnlyWhiteSpaceNode() {
            for (int i = 0; i < this.list.size(); ++i) {
                Object e = this.list.get(i);
                if (!(e instanceof String)) {
                    return false;
                }
                if (this.isOnlyWhiteSpaceLine((String)e)) continue;
                return false;
            }
            return true;
        }

        void removeInitialEmptyLines() {
            Object e;
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext() && (e = iterator.next()) instanceof String) {
                String string = (String)e;
                if (this.isOnlyWhiteSpaceLine(string)) {
                    iterator.remove();
                    continue;
                }
                string.replaceFirst("^(\\\\n(?<!\\\\)|\\\\r(?<!\\\\)|\\\\t(?<!\\\\)| )*", "");
                break;
            }
        }

        void clear() {
            this.list.clear();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Text (#" + this.nodeNumber + "):");
            if (this.list.size() == 0) {
                this.this$0.append("<EMPTY>");
            } else {
                for (int i = 0; i < this.list.size(); ++i) {
                    stringBuilder.append("[");
                    stringBuilder.append(StringUtil.viewableAscii(String.valueOf(this.list.get(i))));
                    stringBuilder.append("]");
                    if (i + 1 >= this.list.size()) continue;
                    stringBuilder.append(",");
                }
            }
            return stringBuilder.toString();
        }
    }

    abstract class Element {
        Element(PageParser pageParser) {
            Objects.requireNonNull(pageParser);
        }

        abstract void render() throws IOException;

        void addExp(Exp exp) {
            throw new RuntimeException("Internal error: not implemented by this object");
        }
    }

    class Code
    extends Element {
        List list;
        final /* synthetic */ PageParser this$0;

        Code(PageParser pageParser, CharArrayWriter charArrayWriter) {
            PageParser pageParser2 = pageParser;
            Objects.requireNonNull(pageParser2);
            this.this$0 = pageParser2;
            super(pageParser);
            this.list = new ArrayList();
            char[] cArray = charArrayWriter.toCharArray();
            CharArrayWriter charArrayWriter2 = new CharArrayWriter();
            int n = 0;
            int n2 = 1;
            while (n < cArray.length) {
                char c = cArray[n];
                if (n2 == cArray.length) {
                    charArrayWriter2.append(c);
                    this.list.add(charArrayWriter2.toString());
                    charArrayWriter2.reset();
                } else if (c == '\n') {
                    charArrayWriter2.append(c);
                    this.list.add(charArrayWriter2.toString());
                    charArrayWriter2.reset();
                } else {
                    charArrayWriter2.append(c);
                }
                ++n;
                ++n2;
            }
        }

        @Override
        void render() {
            for (int i = 0; i < this.list.size(); ++i) {
                this.this$0.o(Character.valueOf('\t'));
                this.this$0.o(this.list.get(i));
            }
        }

        public String toString() {
            return "Code: " + String.valueOf(this.list);
        }
    }

    class Hash
    extends Text {
        final /* synthetic */ PageParser this$0;

        Hash(PageParser pageParser, String string, CharArrayWriter charArrayWriter) {
            PageParser pageParser2 = pageParser;
            Objects.requireNonNull(pageParser2);
            this.this$0 = pageParser2;
            super(pageParser, string, charArrayWriter);
        }

        @Override
        void render() {
            int n = 0;
            int n2 = 1;
            while (n < this.list.size()) {
                Object e = this.list.get(n);
                if (e instanceof Exp) {
                    this.this$0.o(this.offset_space);
                    ((Exp)e).render();
                } else {
                    this.this$0.o(this.offset_space);
                    this.this$0.o("out.print  (\"");
                    this.this$0.o(e);
                    if (n2 == this.list.size()) {
                        this.this$0.o("\");");
                    } else {
                        this.this$0.ol("\");");
                    }
                }
                ++n;
                ++n2;
            }
        }

        @Override
        public String toString() {
            return "Hash: " + String.valueOf(this.list);
        }
    }

    class Heredoc
    extends Text {
        final /* synthetic */ PageParser this$0;

        Heredoc(PageParser pageParser, CharArrayWriter charArrayWriter) {
            PageParser pageParser2 = pageParser;
            Objects.requireNonNull(pageParser2);
            this.this$0 = pageParser2;
            super(pageParser, null, charArrayWriter);
        }

        @Override
        void addExp(Exp exp) {
            throw new IllegalStateException("Internal implementation error: this method should not be called for a Heredoc object");
        }

        @Override
        void render() {
            int n = 0;
            int n2 = 1;
            while (n < this.list.size()) {
                Object e = this.list.get(n);
                this.this$0.o(this.offset_space);
                this.this$0.o("out.print  (\"");
                this.this$0.o(e);
                this.this$0.ol("\");");
                ++n;
                ++n2;
            }
        }

        @Override
        public String toString() {
            return "Heredoc: " + String.valueOf(this.list);
        }
    }

    class Exp
    extends Element {
        String str;
        final /* synthetic */ PageParser this$0;

        Exp(PageParser pageParser, CharArrayWriter charArrayWriter) {
            PageParser pageParser2 = pageParser;
            Objects.requireNonNull(pageParser2);
            this.this$0 = pageParser2;
            super(pageParser);
            this.str = charArrayWriter.toString();
        }

        @Override
        void render() {
            this.this$0.o("out.print  (");
            this.this$0.o(this.str);
            this.this$0.ol(");");
        }

        public String toString() {
            return "Exp: [" + this.str + "]";
        }
    }

    class Comment
    extends Element {
        String str;

        Comment(PageParser pageParser, CharArrayWriter charArrayWriter) {
            Objects.requireNonNull(pageParser);
            super(pageParser);
            this.str = charArrayWriter.toString();
        }

        @Override
        void render() {
        }

        public String toString() {
            return "Comment: [" + this.str + "]";
        }
    }

    class Decl
    extends Code {
        final /* synthetic */ PageParser this$0;

        Decl(PageParser pageParser, CharArrayWriter charArrayWriter) {
            PageParser pageParser2 = pageParser;
            Objects.requireNonNull(pageParser2);
            this.this$0 = pageParser2;
            super(pageParser, charArrayWriter);
        }

        @Override
        void render() {
            for (int i = 0; i < this.list.size(); ++i) {
                this.this$0.o(this.list.get(i));
            }
        }
    }

    class IncludeDecl
    extends Element {
        String str;
        String opt;
        final /* synthetic */ PageParser this$0;

        IncludeDecl(PageParser pageParser, CharArrayWriter charArrayWriter) {
            PageParser pageParser2 = pageParser;
            Objects.requireNonNull(pageParser2);
            this.this$0 = pageParser2;
            super(pageParser);
            this.str = PageParser.removeLeadingTrailingQuote(charArrayWriter.toString().trim());
        }

        void setOption(String string) {
            this.opt = string;
        }

        @Override
        void render() throws IOException {
            File file = null;
            File file2 = this.this$0.inputFile.getParentFile();
            if (file2 == null) {
                file2 = new File(".");
            }
            int n = this.str.length();
            if (this.str.startsWith("\"") || this.str.startsWith("'")) {
                if (n == 1) {
                    throw new IOException("Bad include file name: " + this.str);
                }
                this.str = this.str.substring(1, n);
            }
            if (this.str.endsWith("\"") || this.str.endsWith("'")) {
                if (n == 1) {
                    throw new IOException("Bad include file name: " + this.str);
                }
                this.str = this.str.substring(0, n - 1);
            }
            if (!(file = this.str.startsWith("/") ? new File(this.this$0.contextRoot, this.str) : new File(file2, this.str)).exists()) {
                throw new IOException("Include file does not exist: " + file.getCanonicalPath());
            }
            this.this$0.o("//>>>START INCLUDE DECLARTIONS from: ");
            this.this$0.o(file.getAbsolutePath());
            this.this$0.ol();
            this.this$0.o(IOUtil.inputStreamToString(new FileInputStream(file)));
            this.this$0.o("//>>>END INCLUDE DECLARATIONS from: ");
            this.this$0.o(file.getAbsolutePath());
            this.this$0.ol();
        }

        public String toString() {
            return "IncludeDecl: [" + this.str + "; options: " + this.opt + "]";
        }
    }

    class Include
    extends ForwardIncludeElement {
        final /* synthetic */ PageParser this$0;

        Include(PageParser pageParser) {
            PageParser pageParser2 = pageParser;
            Objects.requireNonNull(pageParser2);
            this.this$0 = pageParser2;
            super(pageParser);
        }

        @Override
        void render() throws IOException {
            super.render();
            this.this$0.ol("\trd.include(req, res);");
            this.this$0.ol("\t}\t\t//end rd block");
        }
    }

    class Forward
    extends ForwardIncludeElement {
        final /* synthetic */ PageParser this$0;

        Forward(PageParser pageParser) {
            PageParser pageParser2 = pageParser;
            Objects.requireNonNull(pageParser2);
            this.this$0 = pageParser2;
            super(pageParser);
        }

        @Override
        void render() throws IOException {
            super.render();
            this.this$0.ol("\t//WARNING: any uncommitted page content before this forward will be discarded.");
            this.this$0.ol("\t//If the response has already been committed an exception will be thrown. ");
            this.this$0.ol("\trd.forward(req, res);");
            this.this$0.ol("\t//NOTE: You should 'return' right after this line. There should be no content in your ");
            this.this$0.ol("\t//page after the forward statement");
            this.this$0.ol("\t}\t\t//end rd block");
        }
    }

    class Import
    extends Code {
        final /* synthetic */ PageParser this$0;

        Import(PageParser pageParser, CharArrayWriter charArrayWriter) {
            PageParser pageParser2 = pageParser;
            Objects.requireNonNull(pageParser2);
            this.this$0 = pageParser2;
            super(pageParser, charArrayWriter);
        }

        @Override
        void render() {
            for (int i = 0; i < this.list.size(); ++i) {
                this.this$0.o(this.list.get(i));
            }
        }
    }

    class MollyComment
    extends Element {
        String str;
        final /* synthetic */ PageParser this$0;

        MollyComment(PageParser pageParser, String string) {
            PageParser pageParser2 = pageParser;
            Objects.requireNonNull(pageParser2);
            this.this$0 = pageParser2;
            super(pageParser);
            this.str = string;
        }

        @Override
        void render() {
            this.this$0.ol(this.str);
        }

        public String toString() {
            return "MollyComment: [" + this.str + "]";
        }
    }

    class ForwardIncludeElement
    extends Element {
        List parts;
        boolean useBuf;
        final /* synthetic */ PageParser this$0;

        ForwardIncludeElement(PageParser pageParser) {
            PageParser pageParser2 = pageParser;
            Objects.requireNonNull(pageParser2);
            this.this$0 = pageParser2;
            super(pageParser);
            this.parts = new ArrayList();
            this.useBuf = false;
        }

        void add(CharArrayWriter charArrayWriter) {
            this.parts.add(charArrayWriter.toString().trim());
            if (this.parts.size() > 1) {
                this.useBuf = true;
            }
        }

        @Override
        void addExp(Exp exp) {
            this.parts.add(exp);
            this.useBuf = true;
        }

        @Override
        void render() throws IOException {
            if (this.parts.size() == 0) {
                return;
            }
            this.this$0.ol("\t{ //this code block gives 'rd' its own namespace");
            if (!this.useBuf) {
                this.this$0.o("\tfinal RequestDispatcher rd = req.getRequestDispatcher(\"");
                this.this$0.o(PageParser.removeLeadingTrailingQuote(this.parts.get(0).toString()));
                this.this$0.ol("\");");
            } else {
                this.this$0.ol("\tfinal StringBuilder buf = new StringBuilder();");
                for (int i = 0; i < this.parts.size(); ++i) {
                    Object object = this.parts.get(i);
                    if (i == 0 || i + 1 == this.parts.size()) {
                        object = PageParser.removeLeadingTrailingQuote(object.toString());
                    }
                    if (object instanceof String) {
                        this.this$0.o("\tbuf.append(\"");
                        this.this$0.o(object);
                        this.this$0.ol("\");");
                        continue;
                    }
                    this.this$0.o("\tbuf.append(");
                    this.this$0.o(((Exp)object).str);
                    this.this$0.ol(");");
                }
                this.this$0.ol("\tfinal RequestDispatcher rd = req.getRequestDispatcher(buf.toString());");
            }
        }

        public String toString() {
            return "Forward: " + String.valueOf(this.parts);
        }
    }
}

