/*
 * Decompiled with CFR 0.152.
 */
package fc.web.page;

import fc.io.Log;
import fc.util.Argcheck;
import fc.util.Args;
import fc.util.ClassUtil;
import fc.util.StringUtil;
import fc.web.page.Page;
import fc.web.page.PageClassLoader;
import fc.web.page.PageCompiler;
import fc.web.page.PageParser;
import fc.web.page.PageServlet;
import fc.web.page.ParseException;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class PageMgr {
    private static final boolean dbg = false;
    File docroot;
    File scratchdir;
    Map pagemap = new HashMap();
    Log log;
    String classpath;
    PageServlet servlet;
    String docrootStr;
    String scratchdirStr;

    public PageMgr(PageServlet pageServlet, File file, File file2, Log log) {
        Argcheck.notnull(file, "docroot parameter was null");
        this.log = log;
        this.servlet = pageServlet;
        if (!file.exists()) {
            throw new IllegalArgumentException("The specified docroot" + String.valueOf(file) + "] does not exist. How am I supposed to load pages, eh ?");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("The specified docroot [" + String.valueOf(file) + "] is not a directory. Give me your webpage directory, fool !");
        }
        this.docroot = file;
        this.scratchdir = file2;
        this.docrootStr = file.getPath();
        this.scratchdirStr = file2.getPath();
        StringBuilder stringBuilder = new StringBuilder(1028);
        stringBuilder.append(System.getProperty("java.class.path"));
        stringBuilder.append(File.pathSeparator);
        File file3 = new File(file, "WEB-INF");
        stringBuilder.append(new File(file3, "classes").getAbsolutePath());
        File file4 = new File(file3, "lib");
        if (file4.exists()) {
            File[] fileArray = file4.listFiles(new FilenameFilter(this){
                {
                    Objects.requireNonNull(pageMgr);
                }

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith("zip") || string.endsWith("jar");
                }
            });
            for (int i = 0; i < fileArray.length; ++i) {
                stringBuilder.append(File.pathSeparator);
                stringBuilder.append(fileArray[i].getAbsolutePath());
            }
        }
        this.classpath = stringBuilder.toString();
        log.info("Created new PageMgr. Using: \n\t\t\tdocroot:     ", file, "\n\t\t\tscratchroot: ", file2, "\n\t\t\tclasspath:   ", this.classpath);
    }

    void destroy() {
        for (Page page : this.pagemap.values()) {
            page.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPage(String string) throws Exception {
        Object object;
        Argcheck.notnull(string, "Internal error: the contextRelativePath parameter was null");
        Page page = null;
        CharArrayWriter charArrayWriter = new CharArrayWriter(128);
        charArrayWriter.append(this.docrootStr).append(File.separator).append(string);
        File file = new File(charArrayWriter.toString());
        charArrayWriter.reset();
        if (!file.exists()) {
            return null;
        }
        String string2 = StringUtil.fileName(string);
        String string3 = StringUtil.dirName(string);
        if (!string3.equals("/") && !string3.equals("")) {
            charArrayWriter.append(this.scratchdirStr).append(File.separator).append(string3);
            object = new File(charArrayWriter.toString());
            charArrayWriter.reset();
            if (!((File)object).exists()) {
                ((File)object).mkdirs();
            }
        }
        object = PageMgr.getClassNameFromPageName(string3, string2);
        charArrayWriter.append(this.scratchdirStr).append(string3).append(File.separator).append((CharSequence)object).append(".java");
        File file2 = new File(charArrayWriter.toString());
        charArrayWriter.reset();
        charArrayWriter.append(this.scratchdirStr).append(string3).append(File.separator).append((CharSequence)object).append(".class");
        File file3 = new File(charArrayWriter.toString());
        charArrayWriter.reset();
        PageMgr pageMgr = this;
        synchronized (pageMgr) {
            String string4 = null;
            long l = file.lastModified();
            long l2 = file2.lastModified();
            long l3 = file3.lastModified();
            if (l2 == 0L || l > l2) {
                PageParser pageParser = new PageParser(this.docroot, file, file2, (String)object);
                this.log.info("PARSING page:", file2.getPath());
                try {
                    pageParser.parse();
                    string4 = pageParser.getSourceEncoding();
                    if (string4 == null) {
                        string4 = "UTF-8";
                    }
                }
                catch (IOException iOException) {
                    if (file2.exists()) {
                        file2.delete();
                    }
                    throw iOException;
                }
                l2 = file2.lastModified();
            }
            boolean bl = false;
            if (l3 == 0L || l2 > l3) {
                this.log.info("COMPILING page:", file2.getPath());
                PageCompiler pageCompiler = new PageCompiler(file2, this.classpath, string4);
                if (!pageCompiler.compile()) {
                    throw new ParseException(pageCompiler.getError());
                }
                bl = true;
            }
            boolean bl2 = this.pagemap.containsKey(string);
            if (bl || !bl2) {
                PageClassLoader pageClassLoader = new PageClassLoader();
                Class<?> clazz = pageClassLoader.loadClass("molly.pages." + file3.getCanonicalPath());
                page = (Page)clazz.newInstance();
                page.init(this.servlet, string);
                if (bl2) {
                    Page page2 = (Page)this.pagemap.get(string);
                    page2.destroy();
                }
                this.pagemap.put(string, page);
            } else {
                page = (Page)this.pagemap.get(string);
            }
        }
        return page;
    }

    static String getClassNameFromPageName(String string, String string2) throws IOException {
        int n;
        char c;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() > 0) {
            n2 = 0;
            c = string.charAt(0);
            if (c == '/' || c == File.separatorChar) {
                n2 = 1;
            }
            if (n2 == 0) {
                if (!Character.isJavaIdentifierStart(c)) {
                    stringBuilder.append(Integer.toHexString(c));
                } else {
                    stringBuilder.append(c);
                }
            }
            for (n = 1; n < string.length(); ++n) {
                c = string.charAt(n);
                if (c == '/' || c == File.separatorChar) {
                    c = '_';
                }
                if (!Character.isJavaIdentifierPart(c)) {
                    stringBuilder.append(Integer.toHexString(c));
                    continue;
                }
                stringBuilder.append(c);
            }
        }
        if ((n2 = string2.indexOf(".")) != -1) {
            string2 = string2.substring(0, n2);
        }
        if (!Character.isJavaIdentifierPart(c = string2.charAt(0))) {
            stringBuilder.append(Integer.toHexString(c));
        } else {
            stringBuilder.append(c);
        }
        for (n = 1; n < string2.length(); ++n) {
            c = string2.charAt(n);
            if (Character.isJavaIdentifierPart(c)) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(Integer.toHexString(c));
        }
        stringBuilder.append("_mp");
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        Args args = new Args(stringArray);
        args.setUsage("java fc.web.page.PageMgr -docroot path-to-docroot-dir (. for cwd)] [-scratchroot path-to-scratchdir  (default .)]");
        String string = args.getRequired("docroot");
        String string2 = args.get("scratchroot", ".");
        PageMgr pageMgr = new PageMgr(null, new File(string), new File(string2), Log.getDefault());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string3 = null;
        while (true) {
            try {
                while (true) {
                    System.out.print("Enter LOAD <path-to-page>, RELOAD, GC, or QUIT: ");
                    String string4 = bufferedReader.readLine();
                    String[] stringArray2 = string4.split("\\s+");
                    String string5 = stringArray2[0].toUpperCase();
                    if (string5.equals("QUIT")) {
                        return;
                    }
                    if (string5.equals("LOAD")) {
                        string3 = stringArray2[1];
                        PageMgr.testLoad(pageMgr, string3);
                        continue;
                    }
                    if (string5.equals("RELOAD")) {
                        if (string3 == null) {
                            System.out.println("Load a page first.....");
                            continue;
                        }
                        PageMgr.testLoad(pageMgr, string3);
                        continue;
                    }
                    if (!string5.equals("GC")) continue;
                    System.gc();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static void testLoad(PageMgr pageMgr, String string) throws Exception {
        Page page = pageMgr.getPage(string);
        if (page != null) {
            System.out.println(ClassUtil.getClassLoaderInfo(page));
        } else {
            System.out.println("Could not load page. getPage() returned null");
        }
    }
}

