/*
 * Decompiled with CFR 0.152.
 */
package fc.web.forms;

import fc.util.Argcheck;
import fc.web.forms.Field;
import fc.web.forms.Form;
import fc.web.forms.FormData;
import fc.web.forms.FormValidator;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;

public final class VFilledGroup
extends FormValidator {
    Field[] fields;
    boolean allFilledOrEmpty;
    boolean onlyOneEmpty;
    boolean onlyOneFilled;
    boolean oneOrMoreFilled;
    static final boolean dbg = false;

    public VFilledGroup(Form form, String string, String string2, List list) {
        this(form, string, string2, list.toArray(new Field[0]));
    }

    public VFilledGroup(Form form, String string, String string2, Field[] fieldArray) {
        super(form, string, string2);
        Argcheck.istrue(fieldArray.length > 0, "specified field list was empty");
        this.fields = fieldArray;
        this.allFilledOrEmpty = true;
        this.onlyOneEmpty = false;
        this.onlyOneFilled = false;
        this.oneOrMoreFilled = false;
    }

    public VFilledGroup onlyOneEmpty() {
        this.allFilledOrEmpty = false;
        this.onlyOneEmpty = true;
        this.onlyOneFilled = false;
        this.oneOrMoreFilled = false;
        return this;
    }

    public VFilledGroup onlyOneFilled() {
        this.allFilledOrEmpty = false;
        this.onlyOneEmpty = false;
        this.onlyOneFilled = true;
        this.oneOrMoreFilled = false;
        return this;
    }

    public VFilledGroup oneOrMoreFilled() {
        this.allFilledOrEmpty = false;
        this.onlyOneEmpty = false;
        this.onlyOneFilled = false;
        this.oneOrMoreFilled = true;
        return this;
    }

    public VFilledGroup allFilledOrEmpty() {
        this.allFilledOrEmpty = true;
        this.onlyOneEmpty = false;
        this.onlyOneFilled = false;
        this.oneOrMoreFilled = false;
        return this;
    }

    @Override
    public boolean validate(FormData formData, HttpServletRequest httpServletRequest) {
        if (this.oneOrMoreFilled) {
            return this.v_oneOrMoreFilled(formData);
        }
        if (this.onlyOneEmpty) {
            return this.v_onlyOneEmpty(formData);
        }
        if (this.onlyOneFilled) {
            return this.v_onlyOneFilled(formData);
        }
        return this.v_allFilledOrEmpty(formData);
    }

    private boolean v_oneOrMoreFilled(FormData formData) {
        for (Field field : this.fields) {
            if (!field.isFilled(formData)) continue;
            return true;
        }
        return false;
    }

    private boolean v_onlyOneFilled(FormData formData) {
        int n = this.fields.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Field field = this.fields[i];
            if (!field.isFilled(formData)) continue;
            if (bl) {
                return false;
            }
            bl = true;
        }
        return true;
    }

    private boolean v_onlyOneEmpty(FormData formData) {
        int n = this.fields.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Field field = this.fields[i];
            if (field.isFilled(formData)) continue;
            if (bl) {
                return false;
            }
            bl = true;
        }
        return true;
    }

    private boolean v_allFilledOrEmpty(FormData formData) {
        int n = this.fields.length;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        for (int i = 0; i < n; ++i) {
            Field field = this.fields[i];
            if (field.isFilled(formData)) {
                bl = false;
                continue;
            }
            bl2 = false;
        }
        return bl || bl2;
    }
}

