/*
 * Decompiled with CFR 0.152.
 */
package fc.web.forms;

import fc.web.forms.AbstractText;
import fc.web.forms.Field;
import fc.web.forms.FormData;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TextArea
extends AbstractText {
    private WrapType wrap;
    private int rows = 0;
    private int cols = 0;
    static final Pattern pat = Pattern.compile("(?i)</textarea>");

    public TextArea(String string) {
        this(string, "", 0, 0);
    }

    public TextArea(String string, int n, int n2) {
        this(string, "", n, n2);
    }

    public TextArea(String string, String string2) {
        this(string, string2, 0, 0);
    }

    public TextArea(String string, String string2, int n, int n2) {
        super(string, string2);
        this.rows = n;
        this.cols = n2;
    }

    @Override
    public Field.Type getType() {
        return Field.Type.TEXTAREA;
    }

    @Override
    public void renderImpl(FormData formData, Writer writer) throws IOException {
        String string = this.getRenderValue(formData);
        writer.write("<textarea ");
        if (!this.enabled || !this.isEnabled(formData)) {
            writer.write(" disabled");
        }
        writer.write(" name='");
        writer.write(this.name);
        writer.write("'");
        if (this.rows > 0) {
            writer.write(" rows='");
            writer.write(String.valueOf(this.rows));
            writer.write("'");
        }
        if (this.cols > 0) {
            writer.write(" cols='");
            writer.write(String.valueOf(this.cols));
            writer.write("'");
        }
        if (this.wrap != null) {
            writer.write(" wrap='");
            writer.write(this.wrap.type);
            writer.write("'");
        }
        if (this.renderStyleTag) {
            writer.write(" style='");
            writer.write(this.styleTag);
            writer.write("'");
        }
        int n = this.arbitraryString.size();
        for (int i = 0; i < n; ++i) {
            writer.write(" ");
            writer.write(this.arbitraryString.get(i).toString());
        }
        writer.write(">");
        writer.write(this.sanitizedValue(string));
        writer.write("</textarea>");
    }

    public TextArea setCols(int n) {
        this.cols = n;
        return this;
    }

    public TextArea setRows(int n) {
        this.rows = n;
        return this;
    }

    public TextArea setWrap(WrapType wrapType) {
        this.wrap = wrapType;
        return this;
    }

    private String sanitizedValue(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        Matcher matcher = pat.matcher(string);
        String string2 = matcher.replaceAll("&lt;/textarea&gt;");
        return string2;
    }

    public static class WrapType {
        private String type;
        public static final WrapType OFF = new WrapType("off");
        public static final WrapType HARD = new WrapType("hard");
        public static final WrapType SOFT = new WrapType("soft");

        private WrapType(String string) {
            this.type = string;
        }
    }
}

