/*
 * Decompiled with CFR 0.152.
 */
package fc.web.forms;

import fc.io.Log;
import fc.web.forms.Dependency;
import fc.web.forms.DependencyException;
import fc.web.forms.DependentSelect;
import fc.web.forms.Field;
import fc.web.forms.FormData;
import fc.web.forms.Hidden;
import fc.web.forms.Select;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class TestDependency
implements Dependency {
    static List usa_states = Arrays.asList(new Select.Option("pa"), new Select.Option("ny", true));
    static List int_states = Arrays.asList(new Select.Option("int#1"), new Select.Option("int#2"), new Select.Option("int#3"));
    static String selectCountryFirst = "--select a country first--";
    static List select_country_msg = Arrays.asList(new Select.Option(selectCountryFirst));
    Select country;
    DependentSelect states;
    Log log;
    String last_name;

    public TestDependency(Select select, DependentSelect dependentSelect) {
        this.country = select;
        this.states = dependentSelect;
        this.states.addDependency(this);
        this.log = DependentSelect.log;
        this.last_name = select.name + "_last_value_id";
    }

    @Override
    public Object getInitialValues(Field field) {
        DependentSelect.Data data = new DependentSelect.Data();
        data.addOption(new Select.Option(selectCountryFirst));
        return data;
    }

    @Override
    public void updateValues(FormData formData, HttpServletRequest httpServletRequest) throws DependencyException {
        Hidden hidden;
        String string = this.country.getStringValue(formData);
        this.log.bug("country_val:", string);
        if (this.needsUpdate(string, formData)) {
            this.log.bug("needsupdate=true");
            formData.setDependencyUpdated();
        }
        String string2 = (hidden = formData.getDynamicField(this.last_name)) != null ? hidden.getValue(formData).intern() : "";
        DependentSelect.Data data = (DependentSelect.Data)formData.getData(this.states.getName());
        if (string == null || string.equalsIgnoreCase("--- select ---")) {
            this.states.setValue(data, select_country_msg);
        } else if (string.equalsIgnoreCase("usa")) {
            this.states.setValue(data, usa_states);
            if (string2 != "usa") {
                data.clearSubmittedData();
            }
        } else if (string.equalsIgnoreCase("uk")) {
            this.states.setValue(data, int_states);
            if (string2 != "uk") {
                data.clearSubmittedData();
            }
        } else {
            throw new DependencyException("Bad country value (" + string + "), cannot calculate state dependency from this country");
        }
    }

    boolean needsUpdate(String string, FormData formData) {
        if (string == null) {
            return false;
        }
        Hidden hidden = formData.getDynamicField(this.last_name);
        this.log.bug("prev_country: ", hidden);
        if (hidden == null) {
            return true;
        }
        String string2 = hidden.getValue(formData);
        this.log.bug("country_val: ", string, "; prev_value:", string2);
        return !string.equals(string2);
    }

    @Override
    public void setDependencyDataFromSubmit(FormData formData, HttpServletRequest httpServletRequest) {
        Object[] objectArray = httpServletRequest.getParameterValues(this.last_name);
        this.log.bug("hidden_values=", Arrays.toString(objectArray));
        if (objectArray != null) {
            Hidden hidden = new Hidden(this.last_name, (String[])objectArray);
            formData.addDynamicField(hidden);
        }
    }

    @Override
    public void renderDependencyData(FormData formData, Writer writer) throws SQLException, IOException {
        String string;
        this.log.bug("start..");
        if (formData != null && (string = this.country.getStringValue(formData)) != null) {
            Hidden hidden = new Hidden(this.last_name, string);
            hidden.render(writer);
        }
    }

    @Override
    public boolean isSubmitDataValid(FormData formData) {
        return true;
    }

    public String toString() {
        return "country-->state dependency";
    }
}

