/*
 * Decompiled with CFR 0.152.
 */
package fc.web.forms;

import fc.util.Argcheck;
import fc.web.forms.Field;
import fc.web.forms.Form;
import fc.web.forms.FormData;
import fc.web.forms.Select;
import fc.web.forms.SubmitHackedException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class RefreshableSelect
extends Select {
    public RefreshableSelect(String string) {
        super(string);
    }

    public RefreshableSelect(String string, List list) {
        super(string);
        Argcheck.notnull(list, "values param was null");
        this.initOptions(list);
    }

    @Override
    public Field.Type getType() {
        return Field.Type.SELECT;
    }

    public void setValue(FormData formData, List list) {
        Argcheck.notnull(formData, "specified fd param was null");
        Argcheck.notnull(list, "specified values param was null");
        Data data = new Data();
        data.options = new LinkedHashMap();
        data.origSelectedMap = new HashMap();
        formData.putData(this.name, data);
        for (int i = 0; i < list.size(); ++i) {
            Select.Option option = (Select.Option)list.get(i);
            String string = option.getValue();
            data.options.put(string, option);
            if (!option.isOrigSelected()) continue;
            data.origSelectedMap.put(string, option);
        }
    }

    public void setSelectedValue(FormData formData, String string) {
        Argcheck.notnull(formData, "specified fd param was null");
        Argcheck.notnull(string, "specified selected param was null");
        Data data = new Data();
        data.options = new LinkedHashMap(this.options);
        data.origSelectedMap = new HashMap();
        formData.putData(this.name, data);
        for (Select.Option option : data.options.values()) {
            String string2 = option.getValue();
            if (!string2.equals(string)) continue;
            data.origSelectedMap.put(string2, option);
        }
    }

    public void setSelectedValue(FormData formData, int n) {
        this.setSelectedValue(formData, String.valueOf(n));
    }

    @Override
    public List getValue(FormData formData) {
        Data data = (Data)formData.getData(this.name);
        if (data == null) {
            return Form.empty_list;
        }
        return data.selectedList;
    }

    @Override
    public String getStringValue(FormData formData) {
        String string = null;
        Data data = (Data)formData.getData(this.name);
        if (data == null) {
            return null;
        }
        List list = data.selectedList;
        if (list == null || list.size() == 0) {
            return string;
        }
        Select.Option option = (Select.Option)list.get(0);
        return option.getValue();
    }

    @Override
    public int getIntValue(FormData formData) {
        return Integer.parseInt(this.getStringValue(formData));
    }

    @Override
    public boolean getBooleanValue(FormData formData) {
        return Boolean.valueOf(this.getStringValue(formData));
    }

    @Override
    public boolean isFilled(FormData formData) {
        if (formData == null) {
            return false;
        }
        Data data = (Data)formData.getData(this.name);
        if (data == null) {
            return false;
        }
        List list = data.selectedList;
        return list != null && list.size() != 0;
    }

    @Override
    public void setValueFromSubmit(FormData formData, HttpServletRequest httpServletRequest) throws SubmitHackedException {
        String[] stringArray = httpServletRequest.getParameterValues(this.name);
        if (stringArray == null) {
            return;
        }
        Data data = new Data();
        data.selectedMap = new HashMap();
        data.selectedList = new ArrayList();
        formData.putData(this.name, data);
        if (this.multiple && stringArray.length > 1) {
            this.hacklert(httpServletRequest, "recieved multiple values for a single value select");
        }
        if (this.multiple) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addSelectedOpt(httpServletRequest, data, stringArray[i]);
            }
        } else {
            this.addSelectedOpt(httpServletRequest, data, stringArray[0]);
        }
    }

    private void addSelectedOpt(HttpServletRequest httpServletRequest, Data data, String string) {
        Select.Option option = new Select.Option(string);
        data.selectedMap.put(option.getValue(), option);
        data.selectedList.add(option);
    }

    @Override
    public void renderImpl(FormData formData, Writer writer) throws IOException {
        Data data = null;
        LinkedHashMap linkedHashMap = this.options;
        Map map = this.origSelectedMap;
        if (formData != null && (data = (Data)formData.getData(this.name)) != null && data.options != null) {
            linkedHashMap = data.options;
            map = data.origSelectedMap;
        }
        writer.write("<select");
        writer.write(" name='");
        writer.write(this.name);
        writer.write("'");
        if (this.size > 0) {
            writer.write(" size='");
            writer.write(String.valueOf(this.size));
            writer.write("'");
        }
        if (!this.enabled || !this.isEnabled(formData)) {
            writer.write(" disabled");
        }
        if (this.multiple) {
            writer.write(" multiple");
        }
        if (this.renderStyleTag) {
            writer.write(" style='");
            writer.write(this.styleTag);
            writer.write("'");
        }
        int n = this.arbitraryString.size();
        for (int i = 0; i < n; ++i) {
            writer.write(" ");
            writer.write(this.arbitraryString.get(i).toString());
        }
        writer.write(">\n");
        for (Select.Option option : linkedHashMap.values()) {
            String string = option.getValue();
            boolean bl = false;
            bl = formData != null ? (data.selectedMap != null ? data.selectedMap.containsKey(string) : map.containsKey(string)) : map.containsKey(string);
            writer.write(option.render(bl));
            writer.write("\n");
        }
        writer.write("</select>");
    }

    @Override
    public void add(Select.Option option) {
        Argcheck.notnull(option, "opt param was null");
        String string = option.getValue();
        this.options.put(string, option);
        if (option.isOrigSelected()) {
            this.origSelectedMap.put(string, option);
        }
    }

    @Override
    public void add(String string) {
        Argcheck.notnull(string, "item param was null");
        Select.Option option = new Select.Option(string);
        this.add(option);
    }

    @Override
    public void reset() {
        this.options.clear();
        this.origSelectedMap.clear();
    }

    @Override
    public Select setSize(int n) {
        this.size = n;
        return this;
    }

    @Override
    public Select allowMultiple(boolean bl) {
        this.multiple = bl;
        return this;
    }

    static final class Data {
        private LinkedHashMap options;
        private Map origSelectedMap;
        private Map selectedMap = null;
        private List selectedList = null;

        Data() {
        }
    }
}

