/*
 * Decompiled with CFR 0.152.
 */
package fc.web.forms;

import fc.io.Log;
import fc.io.SystemLog;
import fc.util.Argcheck;
import fc.web.forms.FieldRefresher;
import fc.web.forms.FieldValidator;
import fc.web.forms.Form;
import fc.web.forms.FormData;
import fc.web.forms.SubmitHackedException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class Field {
    protected static SystemLog log;
    protected Form form;
    protected String name;
    protected List arbitraryString;
    protected boolean renderStyleTag;
    protected String styleTag;
    protected String label;
    protected List validators;
    protected FieldRefresher refresher;
    protected boolean enabled = true;

    public Field(String string) {
        Argcheck.notnull(string, "fieldName parameter was null");
        this.name = string;
        log = Log.getDefault();
        this.renderStyleTag = true;
        this.styleTag = this.name;
        this.validators = new ArrayList();
        this.arbitraryString = new ArrayList(8);
    }

    public String getName() {
        return this.name;
    }

    public abstract Type getType();

    public abstract void setValueFromSubmit(FormData var1, HttpServletRequest var2) throws SubmitHackedException;

    public abstract boolean isFilled(FormData var1);

    public abstract void renderImpl(FormData var1, Writer var2) throws SQLException, IOException;

    public void render(FormData formData, Writer writer) throws SQLException, IOException {
        if (this.refresher != null) {
            if (formData == null) {
                log.info("Looks like Field:[", this.name, "] is being rendered for the first time. Attached ", this.refresher, " will not be invoked. Remember to construct/init the field with an appropriate value to see initial values.");
            } else {
                this.refresher.refresh(formData);
            }
        }
        this.renderImpl(formData, writer);
    }

    public void render(Writer writer) throws SQLException, IOException {
        this.render(null, writer);
    }

    public void render(FormData formData, Writer writer, String string, String string2) throws SQLException, IOException {
        if (string != null) {
            writer.write(string);
        }
        this.render(formData, writer);
        if (string2 != null) {
            writer.write(string2);
        }
    }

    public Field renderError(FormData formData, Writer writer) throws IOException {
        return this.renderError(formData, writer, "<br>\n");
    }

    public Field renderError(FormData formData, Writer writer, String string) throws IOException {
        List list = this.getValidateErrors(formData);
        if (list == null) {
            return this;
        }
        if (this.renderStyleTag) {
            writer.write("<span class='form-errmsg'>");
        }
        for (String string2 : list) {
            writer.write(string2);
            writer.write(string);
        }
        if (this.renderStyleTag) {
            writer.write("</span>");
        }
        return this;
    }

    public void addError(FormData formData, String string) {
        List list = formData.createFieldErrorList(this);
        list.add(string);
    }

    public void add(FieldRefresher fieldRefresher) {
        this.refresher = fieldRefresher;
        fieldRefresher.field = this;
    }

    public void addString(String string) {
        this.arbitraryString.add(string);
    }

    public void addLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean validate(FormData formData, HttpServletRequest httpServletRequest) {
        int n = this.validators.size();
        if (n == 0) {
            return true;
        }
        boolean bl = true;
        List list = null;
        for (int i = 0; i < n; ++i) {
            FieldValidator fieldValidator = (FieldValidator)this.validators.get(i);
            if (fieldValidator.validate(formData, httpServletRequest)) continue;
            bl = false;
            String string = fieldValidator.getErrorMessage();
            log.bug("Field validate error: ", this.name, string);
            list = formData.createFieldErrorList(this);
            list.add(string);
        }
        return bl;
    }

    public List getValidateErrors(FormData formData) {
        if (formData == null) {
            return null;
        }
        List list = formData.getFieldErrors(this);
        return list;
    }

    void addValidator(FieldValidator fieldValidator) {
        this.validators.add(fieldValidator);
    }

    List getValidators() {
        return this.validators;
    }

    public void enable(FormData formData) {
        if (formData != null) {
            formData.enableField(this.name, true);
        }
    }

    public void disable(FormData formData) {
        if (formData != null) {
            formData.enableField(this.name, false);
        }
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled(FormData formData) {
        if (formData == null) {
            return true;
        }
        return formData.isEnabled(this.name);
    }

    void setParentForm(Form form) {
        Argcheck.notnull(form, "form parameter was null");
        this.form = form;
    }

    public void setStyleTag(String string) {
        this.styleTag = string;
    }

    public void renderStyleTag(boolean bl) {
        this.renderStyleTag = bl;
    }

    protected void hacklert(HttpServletRequest httpServletRequest, String string) throws SubmitHackedException {
        this.form.handleSubmitHacked(httpServletRequest, string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Field name='").append(this.name);
        if (this.form != null) {
            stringBuffer.append("' (@form=").append(this.form.getName()).append(")");
        }
        stringBuffer.append("; type='").append(this.getType()).append("']");
        if (this.refresher != null) {
            stringBuffer.append(" Attached refresher: ");
            stringBuffer.append(this.refresher);
        }
        return stringBuffer.toString();
    }

    public static class Type {
        private String name;
        public static final Type CHECKBOX = new Type("checkbox");
        public static final Type HIDDEN = new Type("hidden");
        public static final Type TEXT = new Type("text");
        public static final Type TEXTAREA = new Type("textarea");
        public static final Type PASSWORD = new Type("password");
        public static final Type RADIO = new Type("radio");
        public static final Type SELECT = new Type("select");

        private Type(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

