/*
 * Decompiled with CFR 0.152.
 */
package fc.web.forms;

import fc.util.Argcheck;
import fc.web.forms.Field;
import fc.web.forms.FormData;
import fc.web.forms.SubmitHackedException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Writer;

public abstract class Choice
extends Field {
    private boolean orig_selected;
    private String value;

    protected Choice(String string, String string2, boolean bl) {
        super(string);
        this.value = string2;
        this.orig_selected = bl;
    }

    @Override
    public abstract Field.Type getType();

    public String getValue(FormData formData) {
        Data data = (Data)formData.getData(this.name);
        if (data == null) {
            return null;
        }
        return data.submit_value;
    }

    public void setValue(FormData formData, String string) {
        Argcheck.notnull(formData, "specified fd param was null");
        if (string == null) {
            return;
        }
        Data data = new Data();
        formData.putData(this.name, data);
        data.submit_value = string;
    }

    public void setValue(FormData formData, boolean bl) {
        Argcheck.notnull(formData, "specified fd param was null");
        if (bl) {
            Data data = new Data();
            formData.putData(this.name, data);
            data.submit_value = "on";
        }
    }

    public void setValue(String string, boolean bl) {
        Argcheck.notnull(string, "specified value was null");
        this.value = string;
        this.orig_selected = bl;
    }

    public int getIntValue(FormData formData) {
        String string = this.getValue(formData);
        if (string != null) {
            string = string.trim();
        }
        return Integer.parseInt(string);
    }

    public short getShortValue(FormData formData) {
        String string = this.getValue(formData);
        if (string != null) {
            string = string.trim();
        }
        return Short.parseShort(string);
    }

    public boolean getBooleanValue(FormData formData) {
        String string = this.getValue(formData);
        if (string == null) {
            return false;
        }
        if (string.equalsIgnoreCase("on")) {
            string = "true";
        }
        return Boolean.valueOf(string);
    }

    @Override
    public void setValueFromSubmit(FormData formData, HttpServletRequest httpServletRequest) throws SubmitHackedException {
        String string = httpServletRequest.getParameter(this.name);
        if (string == null) {
            return;
        }
        Data data = new Data();
        formData.putData(this.name, data);
        if (this.value != null && !this.value.equals(string)) {
            this.hacklert(httpServletRequest, "submitted value: [" + string + "] does not equal the value [" + this.value + "]of this field.");
        }
        data.submit_value = string;
    }

    @Override
    public void renderImpl(FormData formData, Writer writer) throws IOException {
        boolean bl = false;
        if (formData == null) {
            bl = this.orig_selected;
        } else {
            String string = this.getValue(formData);
            if (string != null) {
                bl = true;
            }
        }
        writer.write("<input type='");
        writer.write(this.getType().toString());
        writer.write("' name='");
        writer.write(this.name);
        writer.write("'");
        if (this.value != null) {
            writer.write(" value='");
            writer.write(this.value);
            writer.write("'");
        }
        if (!this.enabled || !this.isEnabled(formData)) {
            writer.write(" disabled");
        }
        if (bl) {
            writer.write(" checked");
        }
        if (this.renderStyleTag) {
            writer.write(" style='");
            writer.write(this.styleTag);
            writer.write("'");
        }
        int n = this.arbitraryString.size();
        for (int i = 0; i < n; ++i) {
            writer.write(" ");
            writer.write(this.arbitraryString.get(i).toString());
        }
        writer.write(">");
        writer.write("</input>");
    }

    @Override
    public boolean isFilled(FormData formData) {
        return this.getValue(formData) != null;
    }

    public void setSelected(boolean bl) {
        this.orig_selected = bl;
    }

    @Override
    public String toString() {
        return super.toString() + "; Orig. value: [" + this.value + "]; Orig. selected: [" + this.orig_selected + "]";
    }

    static class Data {
        private String submit_value;

        Data() {
        }
    }
}

