/*
 * Decompiled with CFR 0.152.
 */
package fc.web.forms;

import fc.util.Argcheck;
import fc.web.forms.Field;
import fc.web.forms.FormData;
import fc.web.forms.SubmitHackedException;
import jakarta.servlet.http.HttpServletRequest;

public abstract class AbstractText
extends Field {
    String orig_value;
    boolean trimValues = true;

    AbstractText(String string) {
        super(string);
    }

    AbstractText(String string, String string2) {
        super(string);
        if (string2 == null) {
            log.warn("specified value was null, defaulting to \"\"");
            string2 = "";
        }
        this.orig_value = string2;
    }

    @Override
    public void setValueFromSubmit(FormData formData, HttpServletRequest httpServletRequest) throws SubmitHackedException {
        String string = httpServletRequest.getParameter(this.name);
        if (string == null) {
            if (!this.enabled || !this.isEnabled(formData)) {
                return;
            }
            this.hacklert(httpServletRequest, "Did not find [" + this.name + "] field in the request (but expected to), defaulting to \"\"");
            return;
        }
        if (this.trimValues) {
            string = string.trim();
        }
        if (string.equals("")) {
            return;
        }
        Data data = new Data();
        formData.putData(this.name, data);
        data.value = string;
    }

    public void setValue(String string) {
        if (string == null) {
            log.warn("specified value was null, defaulting to \"\"");
            string = "";
        }
        this.orig_value = string;
    }

    public void setValue(FormData formData, String string) {
        Argcheck.notnull(formData, "specified fd param was null");
        if (string == null) {
            log.warn("specified value was null, defaulting to \"\"");
            string = "";
        }
        Data data = new Data();
        formData.putData(this.name, data);
        data.value = string;
    }

    public String getValue(FormData formData) {
        Data data = (Data)formData.getData(this.name);
        if (data == null) {
            return null;
        }
        return data.value;
    }

    public String getStringValue(FormData formData) {
        String string = this.getValue(formData);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public int getIntValue(FormData formData) {
        String string = this.getValue(formData);
        if (string != null) {
            string = string.trim();
        }
        return Integer.parseInt(string);
    }

    public short getShortValue(FormData formData) {
        String string = this.getValue(formData);
        if (string != null) {
            string = string.trim();
        }
        return Short.parseShort(string);
    }

    public float getFloatValue(FormData formData) {
        String string = this.getValue(formData);
        if (string != null) {
            string = string.trim();
        }
        return Float.parseFloat(string);
    }

    public double getDoubleValue(FormData formData) {
        String string = this.getValue(formData);
        if (string != null) {
            string = string.trim();
        }
        return Double.parseDouble(string);
    }

    public boolean getBooleanValue(FormData formData) {
        return Boolean.valueOf(this.getValue(formData));
    }

    String getRenderValue(FormData formData) {
        if (!this.enabled) {
            return this.orig_value;
        }
        if (formData != null) {
            Data data = (Data)formData.getData(this.name);
            if (data == null) {
                return "";
            }
            return data.value;
        }
        return this.orig_value;
    }

    @Override
    public boolean isFilled(FormData formData) {
        Data data = (Data)formData.getData(this.name);
        if (data == null) {
            return false;
        }
        String string = data.value;
        if (string == null) {
            log.error("Internal error: unexpected state");
        }
        return true;
    }

    public void reset(FormData formData) {
        Data data = (Data)formData.getData(this.name);
        if (data != null) {
            data.value = this.orig_value;
        }
    }

    public void trimValues(boolean bl) {
        this.trimValues = bl;
    }

    @Override
    public String toString() {
        return super.toString() + "; Orig. value: [" + this.orig_value + "]";
    }

    static class Data {
        String value;

        Data() {
        }
    }
}

