/*
 * Decompiled with CFR 0.152.
 */
package fc.util.pagetemplate;

import fc.io.Log;
import fc.jdbc.SimpleConnectionMgr;
import fc.util.Args;
import fc.util.FilePropertyMgr;
import fc.util.PropertyMgr;
import fc.util.pagetemplate.TemplateClassLoader;
import fc.util.pagetemplate.TemplateCompiler;
import fc.util.pagetemplate.TemplatePage;
import fc.util.pagetemplate.TemplateParseException;
import fc.util.pagetemplate.TemplateParser;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class TemplateMgr {
    private static final boolean dbg = false;
    static Map pagemap = new HashMap();
    static Log log;
    static File tmpdir;
    static String classpath;

    public static TemplatePage get(String string) throws Exception {
        return TemplateMgr.getTemplate(new File(string));
    }

    public static TemplatePage get(File file) throws Exception {
        return TemplateMgr.getTemplate(file);
    }

    public static TemplatePage getTemplate(String string) throws Exception {
        return TemplateMgr.getTemplate(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TemplatePage getTemplate(File file) throws Exception {
        if (!file.exists()) {
            throw new IllegalArgumentException("The specified template file " + String.valueOf(file) + "] does not exist. How am I supposed to load it, eh ?");
        }
        StringBuilder stringBuilder = new StringBuilder(1028);
        log = Log.getDefault();
        classpath = System.getProperty("java.class.path");
        tmpdir = new File(System.getProperty("java.io.tmpdir"));
        TemplatePage templatePage = null;
        CharArrayWriter charArrayWriter = new CharArrayWriter(128);
        String string = TemplateMgr.getClassNameFromPageName(file);
        File file2 = new File(tmpdir, string + ".java");
        File file3 = new File(tmpdir, string + ".class");
        Class<TemplateMgr> clazz = TemplateMgr.class;
        synchronized (TemplateMgr.class) {
            long l = file.lastModified();
            long l2 = file2.lastModified();
            long l3 = file3.lastModified();
            if (l2 == 0L || l > l2) {
                TemplateParser templateParser = new TemplateParser(file, file2, string, log);
                log.bug("PARSING page:", file2.getPath());
                try {
                    templateParser.parse();
                }
                catch (IOException iOException) {
                    if (file2.exists()) {
                        file2.delete();
                    }
                    throw iOException;
                }
                l2 = file2.lastModified();
            }
            boolean bl = false;
            if (l3 == 0L || l2 > l3) {
                log.bug("COMPILING page:", file2.getPath());
                TemplateCompiler templateCompiler = new TemplateCompiler(file2, classpath);
                if (!templateCompiler.compile()) {
                    throw new TemplateParseException(templateCompiler.getError());
                }
                bl = true;
            }
            boolean bl2 = pagemap.containsKey(file.getAbsolutePath());
            if (bl || !bl2) {
                TemplateClassLoader templateClassLoader = new TemplateClassLoader(log);
                Class<?> clazz2 = templateClassLoader.loadClass(TemplatePage.PACKAGE_NAME + "." + file3.getCanonicalPath());
                templatePage = (TemplatePage)clazz2.newInstance();
                templatePage.setSourcePath(file);
                if (bl2) {
                    TemplatePage templatePage2 = (TemplatePage)pagemap.get(file.getAbsolutePath());
                }
                pagemap.put(file.getAbsolutePath(), templatePage);
            } else {
                templatePage = (TemplatePage)pagemap.get(file.getAbsolutePath());
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return templatePage;
        }
    }

    static String getClassNameFromPageName(File file) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = file.getAbsolutePath();
        char c = string.charAt(0);
        if (c == '/' || c == File.separatorChar) {
            stringBuilder.append("_");
        } else if (!Character.isJavaIdentifierStart(c)) {
            stringBuilder.append(Integer.toHexString(c));
        } else {
            stringBuilder.append(c);
        }
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c == '/' || c == File.separatorChar || c == '.') {
                stringBuilder.append("_");
                continue;
            }
            if (!Character.isJavaIdentifierPart(c)) {
                stringBuilder.append(Integer.toHexString(c));
                continue;
            }
            stringBuilder.append(c);
        }
        String string2 = stringBuilder.toString();
        if (string2.length() > 1 && string2.startsWith("_")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Args args = new Args(stringArray);
        args.setUsage("java fc.util.template.TemplateMgr \n-file <path-to-page-template-file>\n-out <path-to-output-file>\n ------------------- optional ------------------ \n-conf <db-config file>\n-dbg|debug (turns log level to debug)\n");
        log = Log.getDefault();
        log.setLevel(Log.INFO);
        if (args.flagExists("dbg") || args.flagExists("debug")) {
            log.setLevel(Log.DEBUG);
        }
        HashMap<String, SimpleConnectionMgr> hashMap = new HashMap<String, SimpleConnectionMgr>();
        String string = args.get("conf");
        if (string != null) {
            object = new FilePropertyMgr(new File(string));
            SimpleConnectionMgr simpleConnectionMgr = new SimpleConnectionMgr((PropertyMgr)object);
            hashMap.put("cmgr", simpleConnectionMgr);
        }
        object = TemplateMgr.getTemplate(args.getRequired("file"));
        ((TemplatePage)object).setContext(hashMap);
        ((TemplatePage)object).render(new File(args.getRequired("out")));
    }
}

