/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class SortedCollection
extends AbstractCollection {
    final boolean dbg = true;
    List items;
    Comparator comparator;

    public SortedCollection() {
        this((Comparator)null);
    }

    public SortedCollection(Collection collection) {
        this((Comparator)null);
        this.addAll(collection);
    }

    public SortedCollection(Comparator comparator) {
        this.comparator = comparator;
        this.items = new LinkedList();
    }

    @Override
    public boolean add(Object object) {
        System.out.println("SortedCollection.add(" + String.valueOf(object) + "): ENTER");
        boolean bl = false;
        if (this.items.size() == 0) {
            this.items.add(object);
            bl = true;
        } else {
            ListIterator listIterator = this.items.listIterator();
            while (listIterator.hasNext()) {
                Object e = listIterator.next();
                int n = this.compare(e, object);
                if (n < 0) continue;
                int n2 = listIterator.previousIndex();
                this.items.add(n2 > 0 ? n2 : 0, object);
                bl = true;
                break;
            }
        }
        System.out.println("SortedCollection.add(" + String.valueOf(object) + "): EXIT; result=" + bl + "; collection=" + String.valueOf(this.items));
        return bl;
    }

    @Override
    public Iterator iterator() {
        return this.items.iterator();
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public String toString() {
        return this.items.toString();
    }

    private int compare(Object object, Object object2) {
        int n = this.comparator == null ? ((Comparable)object).compareTo(object2) : this.comparator.compare(object, object2);
        System.out.println("SortedCollection.compare(" + String.valueOf(object) + "," + String.valueOf(object2) + "): result = " + n);
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        List<String> list = Arrays.asList("x", "c", "d", "a");
        SortedCollection sortedCollection = new SortedCollection(list);
        sortedCollection.add("z");
        sortedCollection.add("x");
        sortedCollection.add("b");
        sortedCollection.add("c");
        System.out.println(sortedCollection);
    }
}

