/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.Argcheck;
import fc.util.Range;

public class CharRange
extends Range {
    char startChar;
    char endChar;

    public CharRange(char c, char c2) {
        Argcheck.istrue(c <= c2, "end char lesser than start char in the specified range, start=[" + c + "], end=[" + c2 + "]");
        this.startChar = c;
        this.endChar = c2;
    }

    public char getStart() {
        return this.startChar;
    }

    public char getEnd() {
        return this.endChar;
    }

    public boolean inRange(char c) {
        boolean bl;
        boolean bl2 = bl = c >= this.startChar && c <= this.endChar;
        if (this.negated) {
            return !bl;
        }
        return bl;
    }

    public void setEnd(char c) {
        Argcheck.istrue(this.startChar <= c, "end char lesser than start char in the specified range, start=[" + this.startChar + "], specified end=[" + c + "]");
        this.endChar = c;
    }

    public void setStart(char c) {
        Argcheck.istrue(c <= this.endChar, "start char greater than end char in the specified range, end=[" + this.endChar + "], specified start=[" + c + "]");
        this.startChar = c;
    }

    public String toString() {
        Object object = "CharRange:[";
        if (this.isNegated()) {
            object = (String)object + "^";
        }
        object = (String)object + "'" + this.startChar + "'-'" + this.endChar + "']";
        return object;
    }

    public static void main(String[] stringArray) {
        CharRange charRange = new CharRange('b', 'z');
        System.out.println("constructed range:" + String.valueOf(charRange));
        CharRange.test(charRange);
        charRange.setNegated(true);
        System.out.println("setting the range to be negated:" + String.valueOf(charRange));
        CharRange.test(charRange);
        System.out.println("the following should throw an exception");
        charRange = new CharRange('b', 'a');
    }

    private static void test(CharRange charRange) {
        System.out.println("'b' in range:" + charRange.inRange('b'));
        System.out.println("'z' in range:" + charRange.inRange('z'));
        System.out.println("'d' in range:" + charRange.inRange('d'));
        System.out.println("'a' in range:" + charRange.inRange('a'));
        System.out.println("'A' in range:" + charRange.inRange('A'));
    }
}

