/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.Args;
import fc.util.ToString;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class CalendarUtil {
    private static final boolean debug = false;
    public static final long ONE_SEC = 1000L;
    public static final long ONE_MIN = 60000L;
    public static final long TWO_MIN = 120000L;
    public static final long FIVE_MIN = 300000L;
    public static final long TEN_MIN = 600000L;
    public static final long THIRTY_MIN = 1800000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long TWO_HOUR = 0x6DDD00L;
    public static final long FOUR_HOUR = 14400000L;
    public static final long EIGHT_HOUR = 28800000L;
    public static final long TWELVE_HOUR = 43200000L;
    public static final long TWENTY_FOUR_HOUR = 86400000L;
    public static final long ONE_DAY = 86400000L;
    public static final long THREE_DAY = 259200000L;
    public static final long ONE_WEEK = 604800000L;
    public static final long TWO_WEEK = 1209600000L;
    public static final long ONE_MONTH = 2592000000L;
    public static final long TWO_MONTH = 5184000000L;
    public static final long THREE_MONTH = 7776000000L;
    public static final long SIX_MONTH = 15552000000L;
    public static final long ONE_YEAR = 31536000000L;

    public static final void setMonth(Calendar calendar, int n) {
        switch (n) {
            case 0: {
                calendar.set(2, 0);
                break;
            }
            case 1: {
                calendar.set(2, 1);
                break;
            }
            case 2: {
                calendar.set(2, 2);
                break;
            }
            case 3: {
                calendar.set(2, 3);
                break;
            }
            case 4: {
                calendar.set(2, 4);
                break;
            }
            case 5: {
                calendar.set(2, 5);
                break;
            }
            case 6: {
                calendar.set(2, 6);
                break;
            }
            case 7: {
                calendar.set(2, 7);
                break;
            }
            case 8: {
                calendar.set(2, 8);
                break;
            }
            case 9: {
                calendar.set(2, 9);
                break;
            }
            case 10: {
                calendar.set(2, 10);
                break;
            }
            case 11: {
                calendar.set(2, 11);
                break;
            }
            default: {
                throw new RuntimeException("Month value out of range [" + n + "]");
            }
        }
    }

    public static Date addHours(Calendar calendar, Date date, int n) {
        calendar = (Calendar)calendar.clone();
        calendar.setTime(date);
        calendar.add(11, n);
        return calendar.getTime();
    }

    public static Date getBeginOfHour(Calendar calendar, Date date) {
        calendar = (Calendar)calendar.clone();
        calendar.setTime(date);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        return calendar.getTime();
    }

    public static Date getBeginOfCurrentHour(Calendar calendar) {
        return CalendarUtil.getBeginOfHour(calendar, new Date());
    }

    public static Date getEndOfHour(Calendar calendar, Date date) {
        calendar = (Calendar)calendar.clone();
        calendar.setTime(date);
        calendar.roll(11, 1);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        return calendar.getTime();
    }

    public static Date getEndOfCurrentHour(Calendar calendar) {
        return CalendarUtil.getEndOfHour(calendar, new Date());
    }

    public static Date getBeginOfDay(Calendar calendar, Date date) {
        calendar = (Calendar)calendar.clone();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        return calendar.getTime();
    }

    public static Date getBeginOfCurrentDay(Calendar calendar) {
        return CalendarUtil.getBeginOfDay(calendar, new Date());
    }

    public static Date getEndOfDay(Calendar calendar, Date date) {
        calendar = (Calendar)calendar.clone();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getEndOfCurrentDay(Calendar calendar) {
        return CalendarUtil.getEndOfDay(calendar, new Date());
    }

    public static Date getFirstDayOfWeek(Calendar calendar, Date date) {
        calendar = (Calendar)calendar.clone();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        calendar.set(7, calendar.getFirstDayOfWeek());
        return calendar.getTime();
    }

    public static Date getFirstDayOfCurrentWeek(Calendar calendar) {
        return CalendarUtil.getFirstDayOfWeek(calendar, new Date());
    }

    public static Date getLastDayOfWeek(Calendar calendar, Date date) {
        calendar = (Calendar)calendar.clone();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        calendar.set(7, calendar.getFirstDayOfWeek() + 6);
        return calendar.getTime();
    }

    public static Date getLastDayOfCurrentWeek(Calendar calendar) {
        return CalendarUtil.getLastDayOfWeek(calendar, new Date());
    }

    public static Date getFirstDayOfMonth(Calendar calendar, Date date) {
        List list = CalendarUtil.getLastNMonths(calendar, date, 1, Locale.getDefault());
        return ((Date[])list.get(0))[0];
    }

    public static Date getFirstDayOfCurrentMonth(Calendar calendar) {
        return CalendarUtil.getFirstDayOfMonth(calendar, new Date());
    }

    public static Date getLastDayOfMonth(Calendar calendar, Date date) {
        List list = CalendarUtil.getLastNMonths(calendar, date, 1, Locale.getDefault());
        return ((Date[])list.get(0))[1];
    }

    public static Date getLastDayOfCurrentMonth(Calendar calendar) {
        return CalendarUtil.getLastDayOfMonth(calendar, new Date());
    }

    public static List getLastNMonths(Calendar calendar, int n) {
        return CalendarUtil.getLastNMonths(calendar, new Date(), n, Locale.getDefault());
    }

    public static List getLastNMonths(Calendar calendar, Date date, int n, Locale locale) {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        String[] stringArray = dateFormatSymbols.getShortMonths();
        calendar = (Calendar)calendar.clone();
        calendar.setTime(date);
        ArrayList<Date[]> arrayList = new ArrayList<Date[]>();
        for (int i = 0; i < n; ++i) {
            int n2 = calendar.get(2);
            int n3 = calendar.getActualMaximum(5);
            Date[] dateArray = new Date[2];
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.clear(12);
            calendar.clear(13);
            calendar.clear(14);
            dateArray[0] = calendar.getTime();
            calendar.set(5, n3);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
            dateArray[1] = calendar.getTime();
            arrayList.add(dateArray);
            calendar.roll(2, -1);
        }
        return arrayList;
    }

    public static boolean withinLastNDays(long l, int n) {
        return System.currentTimeMillis() - l <= (long)n * 86400000L;
    }

    public static boolean withinLastNDays(Date date, int n) {
        return System.currentTimeMillis() - date.getTime() <= (long)n * 86400000L;
    }

    public static boolean withinLastNHours(long l, int n) {
        return System.currentTimeMillis() - l <= (long)n * 3600000L;
    }

    public static boolean withinLastNHours(Date date, int n) {
        return System.currentTimeMillis() - date.getTime() <= (long)n * 3600000L;
    }

    public static boolean withinLastNMin(Date date, int n) {
        return System.currentTimeMillis() - date.getTime() <= (long)n * 60000L;
    }

    public static boolean withinLastNSeconds(Date date, int n) {
        return System.currentTimeMillis() - date.getTime() <= (long)(n * 1000);
    }

    public static long daysToMillis(int n) {
        return (long)n * 86400000L;
    }

    public static long hoursToMillis(int n) {
        return (long)n * 3600000L;
    }

    public static long minutesToMillis(int n) {
        return (long)n * 60000L;
    }

    public static int hoursBetween(Date date, Date date2) {
        long l = Math.abs(date.getTime() - date2.getTime());
        return (int)TimeUnit.HOURS.convert(l, TimeUnit.MILLISECONDS);
    }

    public static Timestamp getNowTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Timestamp now() {
        return CalendarUtil.getNowTimestamp();
    }

    public static void main(String[] stringArray) throws Exception {
        Args args = new Args(stringArray);
        ToString.Style style = new ToString.Style();
        style.reflectStatics = true;
        System.out.println(new ToString((Object)new CalendarUtil(), style).reflect().render());
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        if (args.flagExists("date")) {
            date = DateFormat.getDateInstance(3).parse(args.get("date"));
        }
        System.out.println("========== hour =========");
        System.out.println("beginOfHour: " + String.valueOf(CalendarUtil.getBeginOfHour(calendar, date)));
        System.out.println("endOfHour: " + String.valueOf(CalendarUtil.getEndOfHour(calendar, date)));
        System.out.println("beginOfCurrentHour: " + String.valueOf(CalendarUtil.getBeginOfCurrentHour(calendar)));
        System.out.println("endOfCurrentHour: " + String.valueOf(CalendarUtil.getEndOfCurrentHour(calendar)));
        System.out.println("========== day =========");
        System.out.println("beginOfDay: " + String.valueOf(CalendarUtil.getBeginOfDay(calendar, date)));
        System.out.println("endOfDay: " + String.valueOf(CalendarUtil.getEndOfDay(calendar, date)));
        System.out.println("beginOfCurrentDay: " + String.valueOf(CalendarUtil.getBeginOfCurrentDay(calendar)));
        System.out.println("endOfCurrentDay: " + String.valueOf(CalendarUtil.getEndOfCurrentDay(calendar)));
        System.out.println("========== week =========");
        System.out.println("firstDayOfWeek: " + String.valueOf(CalendarUtil.getFirstDayOfWeek(calendar, date)));
        System.out.println("lastDayOfWeek: " + String.valueOf(CalendarUtil.getLastDayOfWeek(calendar, date)));
        System.out.println("firstDayOfCurrentWeek: " + String.valueOf(CalendarUtil.getFirstDayOfCurrentWeek(calendar)));
        System.out.println("lastDayOfCurrentWeek: " + String.valueOf(CalendarUtil.getLastDayOfCurrentWeek(calendar)));
        System.out.println("========== month =========");
        System.out.println("firstDayOfMonth: " + String.valueOf(CalendarUtil.getFirstDayOfMonth(calendar, date)));
        System.out.println("lastDayOfMonth: " + String.valueOf(CalendarUtil.getLastDayOfMonth(calendar, date)));
        System.out.println("firstDayOfCurrentMonth: " + String.valueOf(CalendarUtil.getFirstDayOfCurrentMonth(calendar)));
        System.out.println("lastDayOfCurrentMonth: " + String.valueOf(CalendarUtil.getLastDayOfCurrentMonth(calendar)));
        System.out.println("==== lastNMonths(6) ======");
        System.out.println(Arrays.deepToString(CalendarUtil.getLastNMonths(calendar, date, 6, Locale.getDefault()).toArray()));
    }

    public static enum Duration {
        HOURLY,
        DAILY,
        WEEKLY,
        MONTHLY;


        public static Date getDateAfterDuration(Date date, Duration duration) {
            Calendar calendar = Calendar.getInstance();
            Date date2 = null;
            switch (duration.ordinal()) {
                case 0: {
                    date2 = CalendarUtil.getEndOfHour(calendar, date);
                    break;
                }
                case 1: {
                    date2 = CalendarUtil.getEndOfDay(calendar, date);
                    break;
                }
                case 2: {
                    date2 = CalendarUtil.getLastDayOfWeek(calendar, date);
                    break;
                }
                case 3: {
                    date2 = CalendarUtil.getLastDayOfMonth(calendar, date);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Don't know how to handle this duration");
                }
            }
            return date2;
        }
    }
}

