/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.io.IOUtil;
import fc.util.CalendarUtil;
import fc.util.ClassUtil;
import fc.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class Args {
    static boolean _internal_testing = false;
    protected String usage;
    protected String[] input;
    protected Map flagMap;
    public static String DEFAULT_FLAGNAME = "default";
    public static String FLAG_REPEAT_VALUE_DELIM = ",";

    public Args(String[] stringArray) {
        this.input = stringArray;
        this.parseFlags();
    }

    public Args(InputStream inputStream) {
        this.toStringArray(inputStream);
        this.parseFlags();
    }

    public boolean flagExists(String string) {
        boolean bl = false;
        if (this.flagMap.containsKey(string)) {
            bl = true;
        }
        return bl;
    }

    public int getFlagCount() {
        return this.flagMap.size();
    }

    public String getMainClassName() {
        return ClassUtil.getMainClassName();
    }

    public String get(int n) {
        return this.input[n];
    }

    public String getRequired(int n) {
        if (n < 0 || n > this.input.length - 1) {
            this.handleError("Missing required argument at position [" + n + "]");
        }
        return this.input[n];
    }

    public String get(String string) {
        return (String)this.flagMap.get(string);
    }

    public String get(String string, String string2) {
        String string3 = this.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.get(string);
        if (string2 == null) {
            return bl;
        }
        return this.toBoolean(string2);
    }

    public int getInt(String string, int n) {
        String string2 = this.get(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Cannot convert flag '" + string + "', into a number, returning backup value " + n);
            }
        }
        return n;
    }

    public long getLong(String string, long l) {
        String string2 = this.get(string);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Cannot convert flag '" + string + "', into a number, returning backup value " + l);
            }
        }
        return l;
    }

    public String getRequired(String string) {
        if (string.equals("")) {
            this.handleError("This program expects invocation flag(s).");
            return null;
        }
        String string2 = this.get(string);
        if (string2 == null) {
            this.handleError("Missing required flag: " + string);
        }
        return string2;
    }

    public String getRequiredString(String string) {
        return this.getRequired(string);
    }

    public boolean getRequiredBoolean(String string) {
        String string2 = this.getRequired(string);
        return this.toBoolean(string2);
    }

    public File getRequiredFile(String string) {
        String string2 = this.getRequired(string);
        File file = new File(string2);
        if (!file.exists()) {
            this.handleError(string + " does not exist/is not a valid file");
        }
        return file;
    }

    public int getRequiredInt(String string) {
        String string2 = this.getRequired(string);
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Cannot convert flag '" + string + "', into a number");
            this.handleError(string);
        }
        return n;
    }

    public int getRequiredInteger(String string) {
        return this.getRequiredInt(string);
    }

    public long getRequiredLong(String string) {
        String string2 = this.getRequired(string);
        long l = 0L;
        try {
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Cannot convert flag '" + string + "', into a number");
            this.handleError(string);
        }
        return l;
    }

    public Date getRequiredFriendlyDate(String string) {
        Calendar calendar = Calendar.getInstance(Locale.US);
        Date date = null;
        String string2 = this.getRequired(string);
        if ((string2 = string2.toLowerCase().intern()) == "now" || string2 == "today") {
            date = new Date();
        } else if (string2 == "tomorrow") {
            date = new Date(System.currentTimeMillis() + 86400000L);
        } else if (string2 == "nextweek") {
            date = new Date(System.currentTimeMillis() + 604800000L);
        } else if (string2 == "atweekbegin" || string2 == "atbeginweek" || string2 == "atbeginofweek") {
            date = CalendarUtil.getFirstDayOfWeek(calendar, new Date());
        } else {
            try {
                date = Args.parseDate(string2);
            }
            catch (ParseException parseException) {
                this.handleError("Cannot parse flag name=[" + string + "], value=[" + string2 + "] as a friendly date..");
            }
        }
        return date;
    }

    public Date getFriendlyDate(String string) {
        Calendar calendar = Calendar.getInstance(Locale.US);
        Object var3_3 = null;
        String string2 = this.get(string);
        if (string2 == null) {
            return null;
        }
        return this.getRequiredFriendlyDate(string);
    }

    public void onlyOneOf(String ... stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Specify at least one argument to this method!");
        }
        BitSet bitSet = new BitSet(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.flagExists(stringArray[i])) continue;
            bitSet.set(i);
        }
        if (bitSet.cardinality() != 1) {
            this.handleError(bitSet.cardinality() + " mutually exclusive flags specified. Can only specify one of the following: \n    " + Arrays.toString(stringArray) + "\n");
        }
    }

    public void isMutuallyExclusive(String ... stringArray) {
        this.onlyOneOf(stringArray);
    }

    private static Date parseDate(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            date = simpleDateFormat2.parse(string);
        }
        return date;
    }

    public String[] rawValues() {
        return this.input;
    }

    public Map values() {
        return Collections.unmodifiableMap(this.flagMap);
    }

    public void setUsage(String string) {
        this.usage = string;
    }

    public void setDefaultUsage(Object object) {
        try {
            Class<?> clazz = object.getClass();
            String string = StringUtil.fileName(clazz.getName().replace('.', '/')) + "_usage.txt";
            InputStream inputStream = clazz.getResourceAsStream(string);
            if (inputStream != null) {
                this.setUsage(IOUtil.inputStreamToString(inputStream, false));
            } else {
                this.setUsage("Cannot display usage instructions, " + string + " not found");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setDefaultUsage(String string) {
        try {
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
            if (inputStream != null) {
                this.setUsage(IOUtil.inputStreamToString(inputStream, false));
            } else {
                this.setUsage("Cannot display usage instructions, " + string + " not found");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void showError() {
        this.getRequired("");
    }

    protected PrintStream getOutputStream() {
        return System.err;
    }

    final boolean toBoolean(String string) {
        return (string = string.trim().toLowerCase().intern()) == "true" || string == "yes" || string == "1";
    }

    protected void handleError(String string) {
        PrintStream printStream = this.getOutputStream();
        printStream.println(string);
        if (this.usage != null) {
            printStream.println(this.usage);
        }
        printStream.println();
        printStream.println("-------- Stack Trace --------");
        new Exception().printStackTrace(printStream);
        if (!_internal_testing) {
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        new Test(stringArray);
    }

    private void toStringArray(InputStream inputStream) {
        try {
            int n = inputStream.available();
            byte[] byArray = new byte[n];
            new BufferedInputStream(inputStream).read(byArray, 0, n);
            String string = new String(byArray, "ISO-8859-1");
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n2 = stringTokenizer.countTokens();
            this.input = new String[n2];
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.input[n3++] = stringTokenizer.nextToken().trim();
            }
        }
        catch (IOException iOException) {
            this.input = null;
        }
    }

    private void parseFlags() {
        if (this.input == null) {
            return;
        }
        this.flagMap = new HashMap();
        String string = null;
        Object object = null;
        int n = this.findNextFlag(0);
        int n2 = 0;
        int n3 = 0;
        while (n != -1) {
            string = this.input[n];
            object = null;
            int n4 = string.indexOf(61);
            if (n4 != -1) {
                object = string.substring(n4 + 1, string.length());
                string = string.substring(0, n4);
            }
            n3 = (n2 = this.findNextFlag(n + 1)) == -1 ? this.input.length : n2;
            for (int i = n + 1; i < n3; ++i) {
                object = object == null ? this.input[i] : (String)object + " " + this.input[i];
            }
            if (this.flagMap.containsKey(string = string.length() == 1 ? DEFAULT_FLAGNAME : string.substring(1, string.length()))) {
                object = String.valueOf(this.flagMap.get(string)) + FLAG_REPEAT_VALUE_DELIM + (String)object;
            }
            this.flagMap.put(string, object);
            n = n2;
        }
    }

    private int findNextFlag(int n) {
        for (int i = n; i < this.input.length; ++i) {
            if (!this.input[i].startsWith("-")) continue;
            return i;
        }
        return -1;
    }

    private static class Test {
        Test(String[] stringArray) throws Exception {
            Args args = new Args(stringArray);
            System.out.println("Main Class Name: " + args.getMainClassName());
            System.out.println("Command line parsed as: " + String.valueOf(args.values()));
            String string = "-port 80 -port2=5000 -flow c:\\program files -foo -moo \"moo moo\" -x aaa -x bbb - default fasf";
            Args args2 = new Args(new ByteArrayInputStream(string.getBytes("ISO-8859-1")));
            Map map = args2.values();
            System.out.println("testbyte string parsed as: " + String.valueOf(map));
            try {
                map.put("foo", "bar");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String[] stringArray2 = args2.rawValues();
            System.out.println("raw values=" + String.valueOf(Arrays.asList(stringArray2)));
            System.out.println("get(port2)=" + args2.get("port2"));
            System.out.println("get(default)=" + args2.get(DEFAULT_FLAGNAME));
            System.out.println("get(x)=" + args2.get("x"));
            System.out.println("flagExists(moo)=" + args2.flagExists("flow"));
            System.out.println("flagExists(moo)=" + args2.flagExists("foo"));
            System.out.println("flagExists(doesnotexits)=" + args2.flagExists("doesnotexist"));
            string = "-testdate now -testdate2 nextweek -testdate3 atbeginweek -testdate4 2015-03-01";
            Args args3 = new Args(new ByteArrayInputStream(string.getBytes("ISO-8859-1")));
            System.out.println("friendly date test, using as input:\n\t" + string);
            System.out.println("now=" + String.valueOf(new Date()));
            System.out.println("testdate1=" + String.valueOf(args3.getRequiredFriendlyDate("testdate")));
            System.out.println("testdate2=" + String.valueOf(args3.getRequiredFriendlyDate("testdate2")));
            System.out.println("testdate3=" + String.valueOf(args3.getRequiredFriendlyDate("testdate3")));
            System.out.println("testdate4=" + String.valueOf(args3.getRequiredFriendlyDate("testdate4")));
            _internal_testing = true;
            try {
                args2.setUsage("Usage: java Args.java your arguments here");
                args2.getRequired("doesnotexist");
            }
            catch (Exception exception) {
                System.out.println(IOUtil.throwableToString(exception));
            }
            try {
                string = "-flag1 -flag2 -flag3";
                Args args4 = new Args(new ByteArrayInputStream(string.getBytes("ISO-8859-1")));
                args4.setUsage("Testing only 1 mutually flag present");
                System.out.print("this should work...myarg4.onlyOneOf(\"flag1\")");
                args4.onlyOneOf("flag1");
                System.out.println("..yes");
                System.out.println("this should fail..");
                args4.onlyOneOf("flag1", "flag2");
            }
            catch (Exception exception) {
                System.out.println(IOUtil.throwableToString(exception));
            }
        }
    }
}

