/*
 * Decompiled with CFR 0.152.
 */
package fc.jdbc.dbo;

import fc.io.Log;
import fc.io.SystemLog;
import fc.jdbc.dbo.ColumnData;
import fc.jdbc.dbo.Table;
import fc.util.Argcheck;
import fc.util.Args;
import fc.util.PropertyMgr;
import fc.util.StringUtil;
import fc.util.ToString;

class NameWrangle {
    Log log;
    Type wrangle_classname;
    Type wrangle_methodname;
    String wrangle_sentence_delimiter;
    static ToString.Style style = new ToString.Style();

    public NameWrangle(PropertyMgr propertyMgr, Log log) {
        this.log = log;
        String string = "generate.wrangle.classname";
        String string2 = propertyMgr.get(string, "none");
        log.bug(string, "=", string2);
        try {
            this.wrangle_classname = Type.parseString(string2);
        }
        catch (RuntimeException runtimeException) {
            log.error("make sure '", string, "' is specified properly");
            throw runtimeException;
        }
        if (this.wrangle_classname == Type.NONE_UNDER) {
            throw new IllegalArgumentException("none_under is not a valid option for 'generate.wrangle.classname'");
        }
        string = "generate.wrangle.methodname";
        string2 = propertyMgr.get(string, "none_under");
        log.bug(string, "=", string2);
        try {
            this.wrangle_methodname = Type.parseString(string2);
        }
        catch (RuntimeException runtimeException) {
            log.error("make sure '", string, "' is specified properly");
            throw runtimeException;
        }
        this.wrangle_sentence_delimiter = propertyMgr.get("generate.wrangle.sentence.delimiter", "_");
    }

    String getClassName(Table table) {
        return this.getClassName(table.getName());
    }

    String getGetName(ColumnData columnData) {
        return this.getWrangledMethodName(columnData.getName(), "get");
    }

    String getSetName(ColumnData columnData) {
        return this.getWrangledMethodName(columnData.getName(), "set");
    }

    String getSetNullName(ColumnData columnData) {
        return this.getWrangledMethodName(columnData.getName(), "setNull");
    }

    String getIsModifiedName(ColumnData columnData) {
        return this.getWrangledMethodName(columnData.getName(), "isModified");
    }

    String getIsModifiedNullName(ColumnData columnData) {
        return this.getWrangledMethodName(columnData.getName(), "isModifiedSetNull");
    }

    String getIsNullInDBName(ColumnData columnData) {
        return this.getWrangledMethodName(columnData.getName(), "isNullInDB");
    }

    String getIncName(ColumnData columnData) {
        return this.getWrangledMethodName(columnData.getName(), "inc");
    }

    String getDecName(ColumnData columnData) {
        return this.getWrangledMethodName(columnData.getName(), "dec");
    }

    String getClassName(String string) {
        Object object = null;
        if (this.wrangle_classname == Type.NONE) {
            object = string;
        } else if (this.wrangle_classname == Type.UPPER) {
            object = string.toUpperCase();
        } else if (this.wrangle_classname == Type.LOWER) {
            object = string.toLowerCase();
        } else if (this.wrangle_classname == Type.SENTENCE) {
            object = StringUtil.sentenceCase(string, this.wrangle_sentence_delimiter);
        } else if (this.wrangle_classname == Type.FIRSTUP) {
            object = string.substring(0, 1).toUpperCase() + string.substring(1, string.length()).toLowerCase();
        } else {
            this.log.error("this code should not be reached");
            throw new IllegalArgumentException("An internal error occured");
        }
        return object;
    }

    String getWrangledMethodName(String string, String string2) {
        String string3 = null;
        if (this.wrangle_methodname == Type.NONE) {
            string3 = string2 + string;
        } else if (this.wrangle_methodname == Type.NONE_UNDER) {
            string3 = string2 + "_" + string;
        } else if (this.wrangle_methodname == Type.UPPER) {
            string3 = string2 + string.toUpperCase();
        } else if (this.wrangle_methodname == Type.LOWER) {
            string3 = string2 + string.toLowerCase();
        } else if (this.wrangle_methodname == Type.SENTENCE) {
            string3 = string2 + StringUtil.sentenceCase(string, this.wrangle_sentence_delimiter);
        } else if (this.wrangle_methodname == Type.FIRSTUP) {
            string3 = string2 + string.substring(0, 1).toUpperCase() + string.substring(1, string.length()).toLowerCase();
        } else {
            this.log.error("this code should not be reached");
            throw new IllegalArgumentException("An internal error occured");
        }
        return string3;
    }

    public String toString() {
        return new ToString((Object)this, style).reflect().render();
    }

    public static void main(String[] stringArray) {
        final Args args = new Args(stringArray);
        args.setUsage("java fc.jdbc.dbo.NameWrangle\n\t-teststr string_to_be_wrangled\nThe following are optional\n\t-generate.wrangle.classname  valid_value_allowed_by_generate_config_file\n\t-generate.wrangle.methodname valid_value_allowed_by_generate_config_file\n\t-generate.wrangle.sentence.delimiter valid_value_allowed_by_generate_config_file\n");
        String string = args.getRequired("teststr");
        SystemLog systemLog = Log.getDefault();
        systemLog.setLevel(SystemLog.DEBUG);
        PropertyMgr propertyMgr = new PropertyMgr(){

            @Override
            public String get(String string) {
                return args.get(string);
            }

            @Override
            public void save() {
                this.log.error("this should not be called");
            }

            @Override
            public String set(String string, String string2) {
                this.log.error("this should not be called");
                return null;
            }
        };
        NameWrangle nameWrangle = new NameWrangle(propertyMgr, systemLog);
        System.out.println();
        System.out.println("getClassName=" + nameWrangle.getClassName(string));
        System.out.println("getWrangledMethodName=" + nameWrangle.getWrangledMethodName(string, "get"));
        System.out.println("getWrangledMethodName=" + nameWrangle.getWrangledMethodName(string, "set"));
        System.out.println("getWrangledMethodName=" + nameWrangle.getWrangledMethodName(string, "isModified"));
    }

    static {
        NameWrangle.style.reflectVisibleLevel = ToString.Style.VisibleLevel.PRIVATE;
    }

    static class Type {
        final String typedesc;
        final int typenum;
        public static final Type NONE = new Type("none", 0);
        public static final Type NONE_UNDER = new Type("none_under", 1);
        public static final Type UPPER = new Type("upper", 2);
        public static final Type LOWER = new Type("lower", 3);
        public static final Type SENTENCE = new Type("sentence", 4);
        public static final Type FIRSTUP = new Type("firstup", 5);

        private Type(String string, int n) {
            this.typedesc = string;
            this.typenum = n;
        }

        public static Type parseString(String string) {
            Argcheck.notnull(string, "typedesc paramater was null");
            Type type = null;
            string = string.toLowerCase().intern();
            if (string == "none") {
                type = NONE;
            } else if (string == "none_under") {
                type = NONE_UNDER;
            } else if (string == "upper") {
                type = UPPER;
            } else if (string == "lower") {
                type = LOWER;
            } else if (string == "sentence") {
                type = SENTENCE;
            } else if (string == "firstup") {
                type = FIRSTUP;
            } else {
                throw new IllegalArgumentException("wrangle type: [" + string + "] could not be parsed");
            }
            return type;
        }

        public String toString() {
            return "NameWrangle.Type='" + this.typedesc + "'";
        }
    }
}

