/*
 * Decompiled with CFR 0.152.
 */
package fc.jdbc;

import fc.io.Log;
import fc.io.SystemLog;
import fc.jdbc.ConnectionMgr;
import fc.jdbc.QueryUtil;
import fc.util.Args;
import fc.util.FilePropertyMgr;
import fc.util.PropertyMgr;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SimpleConnectionMgr
extends ConnectionMgr {
    public SimpleConnectionMgr(String string, String string2, String string3, String string4, String string5) throws Exception {
        super(string, string2, string3, string4, string5);
    }

    public SimpleConnectionMgr(PropertyMgr propertyMgr) throws Exception {
        super(propertyMgr);
    }

    public SimpleConnectionMgr(PropertyMgr propertyMgr, String string) throws Exception {
        super(propertyMgr, string);
    }

    public SimpleConnectionMgr(SystemLog systemLog, PropertyMgr propertyMgr) throws Exception {
        super(systemLog, propertyMgr);
    }

    @Override
    protected boolean handleMgrShutdown() {
        return true;
    }

    @Override
    protected Connection getConImpl() throws SQLException {
        Connection connection = null;
        this.log.bug("enter");
        if (this.log.getLevel() == Log.DEBUG) {
            DriverManager.setLogStream(System.err);
        }
        try {
            connection = DriverManager.getConnection(this.url, this.user, this.password);
            this.log.bug("getOneImpl(), got connection: " + String.valueOf(connection));
        }
        catch (SQLException sQLException) {
            this.log.warn("getOneConnection(): Could not get a database connection.", sQLException);
            String string = System.getProperty("socksProxyHost");
            if (string != null) {
                this.log.warn("A network proxy is in use (this could be the reason): ", "socksProxyHost=", string, ", socksProxyPort=", System.getProperty("socksProxyPort"));
                this.log.warn("Invoke java with -DsocksProxyHost='' to get rid of the proxy");
            }
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return connection;
    }

    public static void main(String[] stringArray) throws Exception {
        Args args = new Args(stringArray);
        args.setUsage("java fc.jdbc.SimpleConnectionMgr -conf <path-to-config-file> [-query query-to-execute]");
        String string = args.get("query", null);
        String string2 = args.getRequired("conf");
        try {
            SimpleConnectionMgr simpleConnectionMgr = new SimpleConnectionMgr(new FilePropertyMgr(new File(string2)));
            Connection connection = simpleConnectionMgr.getConnection();
            System.out.println("GOT CONNECTION:" + String.valueOf(connection));
            if (string != null) {
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                System.out.println("======= query using connection ===");
                QueryUtil.printRS(resultSet);
                System.out.println("==================================");
                statement.close();
            }
            System.out.println("The following should give an error");
            simpleConnectionMgr.close();
            simpleConnectionMgr.getConnection();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

