/*
 * Decompiled with CFR 0.152.
 */
package fc.io.fileselectors;

import fc.io.fileselectors.ChainedFileSelector;
import fc.io.fileselectors.NormalFileSelector;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class SuffixSelector
extends ChainedFileSelector {
    List matchlist = new ArrayList();

    public SuffixSelector(String string) {
        this(string, null);
    }

    public SuffixSelector(String string, ChainedFileSelector chainedFileSelector) {
        super(chainedFileSelector);
        if (string.equals("")) {
            this.matchlist.add("");
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.matchlist.add(stringTokenizer.nextToken());
            }
        }
    }

    @Override
    protected boolean thisfilter(File file) {
        String string = file.toString();
        ListIterator listIterator = this.matchlist.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) throws Exception {
        new Test();
    }

    private static class Test {
        Test() throws Exception {
            File file = new File("c:\\temp");
            SuffixSelector suffixSelector = new SuffixSelector(".jpg", new NormalFileSelector());
            File[] fileArray = file.listFiles(suffixSelector);
            List<File> list = Arrays.asList(fileArray);
            System.out.println("total=" + list.size() + ", files=" + String.valueOf(list));
            suffixSelector = new SuffixSelector("");
            fileArray = file.listFiles(suffixSelector);
            list = Arrays.asList(fileArray);
            System.out.println("total=" + list.size() + ", files=" + String.valueOf(list));
        }
    }
}

