#!/bin/bash

HOME="$(dirname $0)"
cd "${HOME}"
HOME="$PWD"

DOCPATH="${HOME}/javadocs/"
SOURCEPATH="${HOME}"

if [ ! -d "$DOCPATH" ]; then
	echo "Cannot change directory to $DOCPATH. Exiting...";
	exit 1;
fi

cd "${DOCPATH}"

rm -rf *.html
rm -rf fc/*.html 

#we generate the form data with no protected fields because
#otherwise the tons of protected fields/methods clutter the
#docs. protected fields can be turned on whilst developing

echo "Running javadoc command from within the distribution";
echo "Javadoc output dir: $DOCPATH";
echo "Java source dir   : $SOURCEPATH";

javadoc \
-Xdoclint:none \
-J-Xmx200M \
-linksource \
-windowtitle "MollyPages.org Foundation API" \
-doctitle "MollyPages.org FoundationClasses (fc.*) API" \
-use \
-version \
-sourcepath "$SOURCEPATH" \
-sourcetab 2 \
-d "$DOCPATH" \
-link "https://docs.oracle.com/javase/8/docs/api/" \
-link "https://tomcat.apache.org/tomcat-9.0-doc/servletapi/index.html" \
-public \
fc.io \
fc.io.fileselectors \
fc.jdbc \
fc.jdbc.dbo \
fc.jdbc.dbo.generated \
fc.net \
fc.util \
fc.util.cache \
fc.util.pagetemplate \
fc.web.page \
fc.web.servlet \
fc.web.forms \
fc.web.simpleforms


cp javadoc_stylesheet.css "$DOCPATH/stylesheet.css"

