// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.simpleforms;

import jakarta.servlet.*;
import jakarta.servlet.http.*;
import java.io.*;
import java.util.*;

import fc.io.*;
import fc.util.*;

/**
Represents an option for a select input type. This class is the
fc.web.simpleforms equivalent to the similar class {@link
fc.web.forms.Select.Option} found in package fc.web.forms

@author hursh jain
*/
public final class SelectOption 
	{
	private String 	value;
	private String 	text;
	private boolean orig_selected;
	
	/** 
	Constructs a new option with the specified text and 
	value of the option tag.
	
	@param	text		the html text of the option tag 
	@param	value	 	the value of the option tag
	@param	selected 	<tt>true</tt> if this option is selected
						by default. If more than one selected option
						is added to a select field and that select
						field does <b>not</b> have it's multiple
						attribute set, then the option displayed as
						selected is browser dependent (Moz1, IE6
						show the last selected, N4 the first). More
						than one selected option should not be shown
						for non multiple select fields anyway.
	**/
	public SelectOption(String text, String value, boolean selected) 
		{
		this.text = text;
		this.value = value;
		this.orig_selected = selected;
		}

	/** 
	Constructs a new unselected option with the specified 
	text and value of the option tag.
	
	@param	text	the html text of the option tag 
	@param	value	the value of the option tag
 	**/
	public SelectOption(String text, String value) {
		this(text, value, false);
		}
	
 	/** 
 	Constructs a new option with the specified text (and no
 	separate value tag).
 	
	@param	text		the html text of the option tag 
	@param 	selected 	<tt>true</tt> to select this option
						<tt>false</tt> otherwise
 	**/
 	public SelectOption(String text, boolean selected) {
 		this(text, null, selected);
 		}

 	/** 
 	Constructs a new unselected option with the specified
	html text and no separate value.

	@param	text	the html text of the option tag 
 	**/
 	public SelectOption(String text) {
 		this(text, null, false);
 		}
		
 	boolean selected() {
		return orig_selected;
		}
				
	/** 
	Returns the value of this option tag. If no value is set, 
	returns the html text value for this option tag 
	**/
	public String getValue() 
		{
		if (value != null)
			return value;
		else
			return text;
		}	
		
	/**
	Returns the html text for this option.
	*/
	public String getHTML()
		{
		return text;
		}
				
	} //~class SelectOption
