create table sessiondata (	
  sessionid    varchar(50),
  name         varchar(100) not null,
  value        text
  );

create table sessionmaster (
  sessionid    varchar(50) primary key,  -- the session id
  created      timestamp not null,   -- session create time
  accessed     timestamp not null,   -- session last accessed				
  is_expired   bool default 'f',     -- true if expired 
  -- a reference to the user table that associates a userid
  -- with one or more sessionid's. Optional so should be 
  -- nullable if used.
  userid       integer
  );

alter table sessiondata add 
   FOREIGN KEY (sessionid) REFERENCES sessionmaster (sessionid) 
     on delete cascade;

-- The following if a user table is present
-- alter table prefix_master add
-- FOREIGN KEY (userid) REFERENCES 
-- NAME_OF_USER_TABLE;
 
 
