// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.servlet;

import java.io.*;
import java.util.*;
import java.util.logging.*;
import jakarta.servlet.*;

import fc.io.*;
import fc.util.*;

/**	
Loads properties for a servlet. Intended to be used in
application/context scope by all servlets belonging to one web
context/application.
<p>
ThreadSafety: This class <b>is</b> thread safe and can be used by
multiple threads concurrently.

@author hursh jain 
@version 1.0 12/30/2001
*/
public class ServletPropertyMgr extends PropertyMgr
{
ServletContext context;

/**
@param	context  the {@link jakarta.servlet.ServletContext}
				 to load init parameters from.
*/
public ServletPropertyMgr(ServletContext context) 
	throws IOException
	{
	this.context = context;
	}

public String get(String name) {
	return context.getInitParameter(name);		
	}

public void save() {
	throw new RuntimeException("not implemented");
	}
	
public String set(String name, String backup) {
	throw new RuntimeException("not implemented");
	}

/**
Overrides the {@link fc.app.PropertyMgr#handleError} method
to <b>not</b>exit the application is case of an error.
Instead an error is logged and a ServletException is thrown.
**/
protected void handleError(String str) throws PropertyNotFoundException
	{
	//don't specify 'this' for the object because then that prints the
	//entire list of loaded properties every time - leads to too much clutter
	System.err.println("Property: '" + str + "' not found"); 
	throw new PropertyNotFoundException("Could not load required property: " + str);
	}
}