// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.servlet;

import jakarta.servlet.*;
import jakarta.servlet.http.*;
import java.io.*;
import java.util.*;
import fc.web.servlet.*;
import fc.io.*;

/**
A convenient base class for servlets that use path info (must
be path mapped; extension mapped servlets (like *.mp) do not
have any path info associated with them.
<p>
If the request has a non-null non-empty path, then that path
is sent to the {@link doPathInfo doPathInfo} method, which 
a subclass should implement. A request with an empty or null
path info results in sending a 404 error back to the client.

@author hursh jain
*/
public abstract class PathServlet extends jakarta.servlet.http.HttpServlet
{
private static final boolean dbg = false;

public void init(ServletConfig conf) throws ServletException 
	{
	super.init();
	}
	
public void doPost(final HttpServletRequest req, final HttpServletResponse res) 
throws ServletException, IOException
	{
	doGet(req, res);
	}
	
public void doGet(final HttpServletRequest req, final HttpServletResponse res) 
throws ServletException, IOException
	{
	res.setContentType("text/html");
	final String pathinfo = req.getPathInfo();
	if (dbg) {
		final PrintWriter out = res.getWriter();
		out.println("PathInfo: "+ pathinfo);
		}
		
	if (pathinfo == null || pathinfo.length() == 0) {
		error(res, "Page not found");
		return;
		}
	
	doPathInfo(req, res, pathinfo);
	}

/**
Sends a 404 (page not found) error to the client. Invoke
this method if there is missing/bad path info and return
from the servlet.
*/
public void error(final HttpServletResponse res, final String msg)
throws IOException
	{
	res.sendError(res.SC_NOT_FOUND, msg);
	}

/**
The pathinfo parameter is not <tt>intern()</tt>'ed but can be
if/as needed in this method.
*/
public abstract void doPathInfo(final HttpServletRequest req, final HttpServletResponse res, String pathinfo)
throws ServletException, IOException;
}
