// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.servlet;

import java.io.*;
import java.util.*;
import java.sql.*;

import jakarta.servlet.*;
import jakarta.servlet.http.*;

import fc.jdbc.*;
import fc.io.*;

/** 
A basic servlet that other servlets should extend. Keeps track of servlet
loaded/unloaded counts and other statistics. The {@link WebApp} servlet should
be loaded before this servlet and the <tt>appName</tt> parameter specified in
the WebApp servlet must be the same as specified to this servlet.
<p>
Each servlet instantiates and uses it's own {@link SystemLogger}. This is
useful because per servlet/jsp log-levels can be set (via the {@link
AdminServlet})
<p>
Each servlet also stores an instance of itself in a map containing all
servlets in the servletcontext (This map can be obtained via the context
attribute of name {@link ContextInit#ALL_SERVLETS_KEY}). Within the map,
a particular servlet is stored with the key obtained via calling:
<tt>that_servlet.getClass().getName()</tt>

@author hursh jain
*/
public class FCBaseServlet extends HttpServlet
{
private 	int				invokeCount = 0;
private 	java.util.Date 	loadTime;
protected 	Log				log;
protected	String			appName;
protected	WebApp			app;

public void init(ServletConfig conf) throws ServletException 
	{
	//FYI: getServletName() is not reliable, returns 'jsp' for all jsp's
		
	super.init(conf);

	ServletContext context = conf.getServletContext();

	loadTime  = new java.util.Date();
	String myname = getClass().getName();
	
	appName = WebUtil.getRequiredParam(context, "appName");
	app = WebApp.getInstance(appName);

	if (app == null) {
		System.out.println("No WebApp installed for this website/context. Calling WebApp related methods will throw an exception...");
		log = Log.get(appName);
		}
	else
		{
		log = app.getAppLog();	
		if (app.allServletsMap != null) {
			app.allServletsMap.put(getClass().getName(), this);
			}
		}	
	log.info (myname, " Finished super.init() in FCBaseServlet"); 
	}
	
/**
Convience method that calls {@link WebApp#getConnection(String)}
*/
protected Connection getConnection(String dbname) throws SQLException 
	{
	if (app == null) {
		throw new RuntimeException("WebApp [" + appName + "] is not configured. To use this convenience method, specify a WebApp (that reads property files and creates a connection pool) in your contexts web.xml. Else override this method and/or create a connection yourself.");
		}
	return app.getConnection(dbname);
	}

/**
Convience method that calls {@link WebApp#getConnection()}
*/
protected Connection getConnection() throws SQLException 
	{
	if (app == null) {
		throw new RuntimeException("WebApp [" + appName + "] is not configured. To use this convenience method, specify a WebApp (that reads property files and creates a connection pool) in your contexts web.xml. Else override this method and/or create a connection yourself.");
		}
	return app.getConnection();
	}

protected void service(HttpServletRequest req,
                       HttpServletResponse res)
throws ServletException, java.io.IOException
	{
	invokeCount++;
	super.service(req, res);
	}
                       
public String toString() {
	return  getClass().getName();
	}	
	
/**
Returns the logger for this servlet.
*/
public Log getLog()
	{
	return log;
	}

/**
Returns usage statistics about this servlet. The
returned string is HTML formatted.
*/
public String stats() {
	return
	"Invoked: " + invokeCount + " times <br>" +
	"Last loaded at: " + loadTime;
	}
	
public void destroy() 
	{
	log.info(this, "..destroy called"); 
	//since allServlets is used to view running servlets
	//we remove ourselves from it since we are now destroyed
	if (WebApp.getInstance(appName).allServletsMap != null) {
		WebApp.getInstance(appName).allServletsMap.remove(getClass().getName());
		}
	log.close();
	}	
	
}
