// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.servlet;

import jakarta.servlet.*;
import jakarta.servlet.http.*;
import java.io.*;
import java.util.*;

import fc.io.*;

/** 
For debugging session attribute set/get events. Enable this listener in the
server configuration file to ease <i>development time</i> debugging.

@author hursh jain
**/
public class DebugSessionListener implements 
			 HttpSessionListener, HttpSessionAttributeListener
{
Log log;

void initLog(HttpSession session)
	{
	if (log == null) {
		log = Log.getDefault();
		}
	}

//Session Listener
public void sessionCreated(HttpSessionEvent event)
	{
	synchronized (this) { 
		HttpSession session = event.getSession();
		initLog(session); 
		log.bug("session CREATED=", session); 
		}
	}

public void sessionDestroyed(HttpSessionEvent event)
	{
	synchronized (this) { 
		HttpSession session = event.getSession();
		initLog(session); 
		log.bug("session DESTROYED=", session); 
		}
	}

//AttributeListener	
public void attributeAdded(HttpSessionBindingEvent event) 
	{
	synchronized (this) { 
		HttpSession session = event.getSession();
		initLog(session); 
		log.bug("attribute ADDED to session=", session,
			"name=", event.getName(),
			"value=", event.getValue());
		}
	}
	
public void attributeRemoved(HttpSessionBindingEvent event) 
	{
	synchronized (this) { 
		HttpSession session = event.getSession();
		initLog(session); 
		log.bug("attribute REMOVED to session=", session, 
			"name=", event.getName(),
			"value=", event.getValue());
		}
	}

public void attributeReplaced(HttpSessionBindingEvent event) {
	synchronized (this) { 
		HttpSession session = event.getSession();
		initLog(session); 
		log.bug("attribute REPLACED to session=", session, 
			"name=", event.getName(),
			"value=", event.getValue());
		}
	}
}