// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import jakarta.servlet.*;
import jakarta.servlet.http.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/**
Validates that a select field has:
<ol>
<li>some value(s)
<li>the values(s) are <b>not</b> a pre-specified value. 
</ol>

This is useful to see if the select field (popup) was selected by the user
(typically, select fields may be displayed with a dummy default
<i><tt>---choose an option---</tt></i> type selection. In that case, we would
check to see if the select value was <b>not</b> <i><tt>---choose an
option---</tt></i>.

@author hursh jain
**/
public final class VSelectValue extends FieldValidator
{
String errorval;

/** 
@param	field				the parent field
@param	badSelectValue		the select value which will cause the
							validation to fail
@param	errorMessage		error message for unsuccessful validation error.							
**/
public VSelectValue(
Select field, String errorMessage, String badSelectValue) 
	{
	super(field, errorMessage);
	this.errorval = badSelectValue;
	}

/** 
Works with the {@link Select} field. 

@throws ClassCastException  If the field's {@link Field#getValue} method
							does not return a collection of 
							{@link Select.Option} objects
**/
public boolean validate(FormData fd, HttpServletRequest req) 
	{
	Collection list = ((Select)field).getValue(fd);
	
	if (list == null || list.size() == 0)
		return false;
		
	Iterator it = list.iterator();
	while (it.hasNext()) {
		Select.Option item = (Select.Option) it.next();			
		if (item.getValue().equals(errorval))
			return false;
		}	

	return true;
	}	
}          //~class VSelectValue

