// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import jakarta.servlet.*;
import jakarta.servlet.http.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/**
Validates that some condition/state for a group of fields
implies some other condition/state for another group of fields.
The pre/post conditions are both the result of {@VFilledGroup}
validators attached to the pre/post fields.

@author hursh jain
**/
public abstract class VFilledOnFilled  extends VConditional
{
VFilledGroup pre;
VFilledGroup post;

/** 
@param	name		  name for this validator
@param	errorMessage  validation error message
@param	preValidator  a pre condition validator
@param	postValidator a post condition validator
*/
public VFilledOnFilled(
 Form f, String name, String errorMessage, 
 VFilledGroup preValidator, VFilledGroup postValidator)
	{
	super(f, name, errorMessage);
	Argcheck.istrue(preValidator != null, "specified pre validator was null");
	Argcheck.istrue(postValidator != null, "specified post validator was null");
	this.pre = preValidator;
	this.post = postValidator;
	}

public boolean preConditionMet(FormData fd, HttpServletRequest req)
	{
	return pre.validate(fd, req);
	}

public boolean postConditionMet(FormData fd, HttpServletRequest req)
	{
	return post.validate(fd, req);
	}	

}          //~class VFilledOnFilled

