// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import jakarta.servlet.*;
import jakarta.servlet.http.*;
import java.io.*;
import java.util.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/** 
Represents an HTML text field 

@author hursh jain
**/
public final class Text extends MaxSizable
{
/** 
Creates a new text element with a initial value of "". 
**/
public Text(String name)
	{
	this(name, "");
	}
	
/**
Creates a new text element with the specified initial value.
If the specified value is <tt>null</tt>, then the initial
value is set to "" (the empty string).
**/
public Text(String name, String value)
	{
	super(name, value);
	}
	
public Field.Type getType() {
	return Field.Type.TEXT;
	}

public void renderImpl(FormData fd, Writer writer) throws IOException 
	{
	String value = getRenderValue(fd);
	writer.write("<input type='");
	writer.write(getType().toString());
	writer.write("' name='");
	writer.write(name);
	writer.write("'");

	if (value != null) {
		writer.write(" value='");
		writer.write(value);
		writer.write("'"); 
		}
	
	if (! enabled || ! isEnabled(fd)) {
		writer.write(" disabled");
		}
	
	if (size > 0) {
		writer.write(" size='");
		writer.write(String.valueOf(size));
		writer.write("'"); 
		}
	
	if (maxlen > 0) {
		writer.write(" maxlength='");
		writer.write(String.valueOf(maxlen));
		writer.write("'"); 
		}
		
	if (renderStyleTag) {
		writer.write(" style='");
		writer.write(styleTag);
		writer.write("'");
		}
		
	final int arlen = arbitraryString.size();
	for (int n = 0; n < arlen; n++) {
		writer.write(" ");
		writer.write(arbitraryString.get(n).toString());
		}

	writer.write("></input>");
	}
									
}          //~class Text