// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import jakarta.servlet.*;
import jakarta.servlet.http.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/** 
Represents a HTML form's radio element.

@author hursh jain
**/
public final class Radio extends Choice
{
/** 
Creates a new radio object.

@param 	name		the field name
@param 	value		the value of this choice item
@param	selected	<tt>true</tt> if this choice is 
					originally selected
**/
public Radio(String name, String value, boolean selected)
	{
	super(name, value, selected);
	}

/** 
Constructs a new unselected radio with the specified value 
and HTML text. 

@param	name		the name of this choice
@param 	value		the value of this choice item
**/
public Radio(String name, String value) {
	this(name, value, false);
	}

/** 
Constructs a new unselected radio with no separate 
value attribute

@param	name		the name of this choice
**/
public Radio(String name) {
	this(name, null, false);
	}

public Field.Type getType() {
	return Field.Type.RADIO;
	}

}          //~class Radio