// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import jakarta.servlet.*;
import jakarta.servlet.http.*;
import java.io.*;
import java.util.*;

import fc.jdbc.*;
import fc.io.*;
import fc.util.*;

/** 
Represents an HTML field that accepts a 'maxlength' html 
attribute 
**/
public abstract class MaxSizable extends AbstractText
{
protected int 	size = 0;
protected int 	maxlen = 0;

protected MaxSizable(String name)
	{
	this(name, "");
	}
	
protected MaxSizable(String name, String value)
	{
	super(name, value);
	}
	

/** 
Specifies the size of this text box. This value (if set) is
rendered as the html <tt>SIZE</tt> tag.

@return	this object for method chaining convenience
**/
public MaxSizable setSize(int size) {
	this.size = size;
	return this;
	}	

/** 
Specifies the maximum number of characters a text box can accept.
This value (if set) is rendered as the html <tt>MAXLENGTH</tt> tag.

@return	this object for method chaining convenience
**/
public MaxSizable setMaxSize(int maxlen) {
	this.maxlen = maxlen;
	return this;
	}	

}          //~class MaxSize